/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ForgeHooks {
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN;
    private static ThreadLocal<zj> craftingPlayer;
    private static ThreadLocal<Deque<LootTableContext>> lootContext;

    public static adq getGrassSeed(Random rand, int fortune) {
        SeedEntry entry = (SeedEntry)ov.a((Random)rand, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.getStack(rand, fortune);
    }

    public static boolean canHarvestBlock(ajt block, zj player, ahx world, cl pos) {
        ard state = world.o(pos);
        if ((state = state.t().b(state, world, pos)).a().l()) {
            return true;
        }
        adq stack = player.bs.h();
        String tool = block.getHarvestTool(state);
        if (stack == null || tool == null) {
            return player.b(state);
        }
        int toolLevel = stack.b().getHarvestLevel(stack, tool);
        if (toolLevel < 0) {
            return player.b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean canToolHarvestBlock(ahx world, cl pos, adq stack) {
        ard state = world.o(pos);
        state = state.t().b(state, world, pos);
        String tool = state.t().getHarvestTool(state);
        if (stack == null || tool == null) {
            return false;
        }
        return stack.b().getHarvestLevel(stack, tool) >= state.t().getHarvestLevel(state);
    }

    public static float blockStrength(ard state, zj player, aht world, cl pos) {
        float hardness = state.b(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(state.t(), player, (ahx)world, pos)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    public static boolean isToolEffective(ahx world, cl pos, adq stack) {
        ard state = world.o(pos);
        state = state.t().b(state, world, pos);
        for (String type : stack.b().getToolClasses(stack)) {
            if (!state.t().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        ajt[] oreBlocks;
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ReflectionHelper.getPrivateValue(aeb.class, null, 0);
        for (ajt block : blocks) {
            block.setHarvestLevel("pickaxe", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(aen.class, null, 0);
        for (ajt block : blocks) {
            block.setHarvestLevel("shovel", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(abz.class, null, 0);
        for (ajt block : blocks) {
            block.setHarvestLevel("axe", 0);
        }
        aju.Z.setHarvestLevel("pickaxe", 3);
        aju.bC.setHarvestLevel("pickaxe", 0);
        for (ajt block : oreBlocks = new ajt[]{aju.bP, aju.bT, aju.ag, aju.ah, aju.o, aju.R, aju.aC, aju.aD}) {
            block.setHarvestLevel("pickaxe", 2);
        }
        aju.p.setHarvestLevel("pickaxe", 1);
        aju.S.setHarvestLevel("pickaxe", 1);
        aju.x.setHarvestLevel("pickaxe", 1);
        aju.y.setHarvestLevel("pickaxe", 1);
        aju.co.setHarvestLevel("pickaxe", 0);
    }

    public static int getTotalArmorValue(zj player) {
        int ret = 0;
        for (int x = 0; x < player.bs.b.length; ++x) {
            adq stack = player.bs.b[x];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)stack.b()).getArmorDisplay(player, stack, x);
                continue;
            }
            if (stack == null || !(stack.b() instanceof abw)) continue;
            ret += ((abw)stack.b()).d;
        }
        return ret;
    }

    public static boolean onPickBlock(bbg target, zj player, aht world) {
        adq result = null;
        boolean isCreative = player.bK.d;
        apv te = null;
        if (target.a == bbg.a.b) {
            ard state = world.o(target.a());
            if (state.t().isAir(state, (ahx)world, target.a())) {
                return false;
            }
            if (isCreative && bez.q() && state.t().hasTileEntity(state)) {
                te = world.r(target.a());
            }
            result = state.t().getPickBlock(state, target, world, target.a(), player);
        } else {
            if (target.a != bbg.a.c || target.d == null || !isCreative) {
                return false;
            }
            result = target.d.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        if (result.b() == null) {
            String s1 = "";
            if (target.a == bbg.a.b) {
                s1 = ((kl)ajt.h.b((Object)world.o(target.a()).t())).toString();
            } else if (target.a == bbg.a.c) {
                s1 = rt.b((rr)target.d);
            }
            FMLLog.warning("Picking on: [%s] %s gave null item", target.a, s1);
            return true;
        }
        if (te != null) {
            bcd.z().a(result, te);
        }
        if (isCreative) {
            player.bs.a(result);
            bcd.z().c.a(player.b(qm.a), 36 + player.bs.d);
            return true;
        }
        int slot = player.bs.b(result);
        if (slot != -1) {
            if (zi.e((int)slot)) {
                player.bs.d = slot;
            } else {
                bcd.z().c.a(slot);
            }
            return true;
        }
        return false;
    }

    public static void onLivingSetAttackTarget(sa entity, sa target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(sa entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(sa entity, rc src, float amount) {
        return !MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(sa entity, rc src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.getAmount();
    }

    public static boolean onLivingDeath(sa entity, rc src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(sa entity, rc source, ArrayList<yd> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    public static float[] onLivingFall(sa entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static boolean isLivingOnLadder(ard state, aht world, cl pos, sa entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof zj && ((zj)entity).y();
        if (isSpectator) {
            return false;
        }
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            return state != null && state.t().isLadder(state, (ahx)world, pos, entity);
        }
        bbf bb = entity.bm();
        int mX = on.c((double)bb.a);
        int mY = on.c((double)bb.b);
        int mZ = on.c((double)bb.c);
        int y2 = mY;
        while ((double)y2 < bb.e) {
            int x2 = mX;
            while ((double)x2 < bb.d) {
                int z2 = mZ;
                while ((double)z2 < bb.f) {
                    cl tmp = new cl(x2, y2, z2);
                    state = world.o(tmp);
                    if (state.t().isLadder(state, (ahx)world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(sa entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static yd onPlayerTossEvent(zj player, adq item, boolean includeName) {
        player.captureDrops = true;
        yd ret = player.a(item, false, includeName);
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        if (!player.l.E) {
            player.e().a((rr)event.getEntityItem());
        }
        return event.getEntityItem();
    }

    public static float getEnchantPower(aht world, cl pos) {
        return world.o(pos).t().getEnchantPowerBonus(world, pos);
    }

    public static ew onServerChatEvent(mc net, String raw, ew comp) {
        ServerChatEvent event = new ServerChatEvent(net.b, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.getComponent();
    }

    public static ew newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static ew newChatWithLinks(String string, boolean allowMissingHeader) {
        fc ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            fc link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new fc(part);
                    } else {
                        ichat.a(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new fc(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new fc(url);
                            continue;
                        }
                        ichat.a(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new fc(url);
                        continue;
                    }
                    ichat.a(url);
                    continue;
                }
            }
            ev click = new ev(ev.a.a, url);
            link.b().a(click);
            link.b().d(Boolean.valueOf(true));
            link.b().a(a.j);
            if (ichat == null) {
                ichat = link;
                continue;
            }
            ichat.a((ew)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new fc(end);
        } else if (end.length() > 0) {
            ichat.a(string.substring(lastEnd));
        }
        return ichat;
    }

    public static boolean canInteractWith(zj player, aau openContainer) {
        PlayerOpenContainerEvent event = new PlayerOpenContainerEvent(player, openContainer);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() == Event.Result.DEFAULT ? event.isCanInteractWith() : event.getResult() == Event.Result.ALLOW;
    }

    public static int onBlockBreakEvent(aht world, ahw.a gameType, ls entityPlayer, cl pos) {
        boolean preCancelEvent = false;
        if (gameType.d() && entityPlayer.cc() != null && entityPlayer.cc().b() instanceof aex) {
            preCancelEvent = true;
        }
        if (gameType.c()) {
            adq itemstack;
            if (gameType == ahw.a.e) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.cV() || (itemstack = entityPlayer.cc()) != null && itemstack.a(world.o(pos).t()))) {
                preCancelEvent = true;
            }
        }
        if (world.r(pos) == null) {
            fw packet = new fw(world, pos);
            packet.b = aju.a.u();
            entityPlayer.a.a((fh)packet);
        }
        ard state = world.o(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (zj)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled()) {
            fu pkt;
            entityPlayer.a.a((fh)new fw(world, pos));
            apv tileentity = world.r(pos);
            if (tileentity != null && (pkt = tileentity.D_()) != null) {
                entityPlayer.a.a((fh)pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static qo onPlaceItemIntoWorld(adq itemstack, zj player, aht world, cl pos, cs side, float hitX, float hitY, float hitZ, qm hand) {
        int meta = itemstack.h();
        int size = itemstack.b;
        dq nbt = null;
        if (itemstack.o() != null) {
            nbt = (dq)itemstack.o().b();
        }
        if (!(itemstack.b() instanceof acj)) {
            world.captureBlockSnapshots = true;
        }
        qo ret = itemstack.b().a(itemstack, player, world, pos, hand, side, hitX, hitY, hitZ);
        world.captureBlockSnapshots = false;
        if (ret == qo.a) {
            int newMeta = itemstack.h();
            int newSize = itemstack.b;
            dq newNBT = null;
            if (itemstack.o() != null) {
                newNBT = (dq)itemstack.o().b();
            }
            BlockEvent.PlaceEvent placeEvent = null;
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.b(meta);
            itemstack.b = size;
            if (nbt != null) {
                itemstack.d(nbt);
            }
            if (blockSnapshots.size() > 1) {
                placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace(player, blockSnapshots, side);
            } else if (blockSnapshots.size() == 1) {
                placeEvent = ForgeEventFactory.onPlayerBlockPlace(player, (BlockSnapshot)blockSnapshots.get(0), side);
            }
            if (placeEvent != null && placeEvent.isCanceled()) {
                ret = qo.c;
                for (BlockSnapshot blocksnapshot : blockSnapshots) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.b(newMeta);
                itemstack.b = newSize;
                if (nbt != null) {
                    itemstack.d(newNBT);
                }
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    ard oldBlock = snap.getReplacedBlock();
                    ard newBlock = world.o(snap.getPos());
                    if (newBlock != null && !newBlock.t().hasTileEntity(newBlock)) {
                        newBlock.t().c(world, snap.getPos(), newBlock);
                    }
                    world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
                }
                player.b(nu.a((ado)itemstack.b()));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    public static boolean onAnvilChange(aaw container, adq left, adq right, qg outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            return false;
        }
        if (e.getOutput() == null) {
            return true;
        }
        outputSlot.a(0, e.getOutput());
        container.a = e.getCost();
        container.k = e.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(zj player, adq output, adq left, adq right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post(e);
        return e.getBreakChance();
    }

    public static boolean onNoteChange(aql te, byte old) {
        NoteBlockEvent.Change e = new NoteBlockEvent.Change(te.D(), te.v(), te.D().o(te.v()), old, te.a);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            te.a = old;
            return false;
        }
        te.a = (byte)e.getVanillaNoteId();
        return true;
    }

    public static adq[] defaultRecipeGetRemainingItems(abc inv) {
        adq[] ret = new adq[inv.u_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ForgeHooks.getContainerItem(inv.a(i));
        }
        return ret;
    }

    public static void setCraftingPlayer(zj player) {
        craftingPlayer.set(player);
    }

    public static zj getCraftingPlayer() {
        return craftingPlayer.get();
    }

    public static adq getContainerItem(adq stack) {
        if (stack == null) {
            return null;
        }
        if (stack.b().hasContainerItem(stack)) {
            if ((stack = stack.b().getContainerItem(stack)) != null && stack.e() && stack.i() > stack.j()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return null;
            }
            return stack;
        }
        return null;
    }

    public static boolean isInsideOfMaterial(axe material, rr entity, cl pos) {
        ard state = entity.l.o(pos);
        ajt block = state.t();
        double eyes = entity.q + (double)entity.bo();
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)block).getFilledPercentage(entity.l, pos);
        } else if (block instanceof amo) {
            filled = amo.e((int)block.e(state));
        }
        if (filled < 0.0) {
            return eyes > (double)(pos.q() + 1) + (1.0 - (filled *= -1.0));
        }
        return eyes < (double)(pos.q() + 1) + filled;
    }

    public static boolean onPlayerAttackTarget(zj player, rr target) {
        if (MinecraftForge.EVENT_BUS.post(new AttackEntityEvent(player, target))) {
            return false;
        }
        adq stack = player.cc();
        return stack == null || !stack.b().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(rr entity, int dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled() && entity instanceof aak) {
            ((aak)entity).b = true;
        }
        return !event.isCanceled();
    }

    public static bbg rayTraceEyes(sa entity, double length) {
        bbh startPos = new bbh(entity.p, entity.q + (double)entity.bo(), entity.r);
        bbh endPos = startPos.e(new bbh(entity.aB().b * length, entity.aB().c * length, entity.aB().d * length));
        return entity.l.a(startPos, endPos);
    }

    public static bbh rayTraceEyeHitVec(sa entity, double length) {
        bbg git = ForgeHooks.rayTraceEyes(entity, length);
        return git == null ? null : git.c;
    }

    public static boolean onInteractEntityAt(zj player, rr entity, bbg ray, adq stack, qm hand) {
        bbh vec3d = new bbh(ray.c.b - entity.p, ray.c.c - entity.q, ray.c.d - entity.r);
        return ForgeHooks.onInteractEntityAt(player, entity, vec3d, stack, hand);
    }

    public static boolean onInteractEntityAt(zj player, rr entity, bbh vec3d, adq stack, qm hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.EntityInteractSpecific(player, hand, stack, entity, vec3d));
    }

    public static boolean onInteractEntity(zj player, rr entity, adq item, qm hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.EntityInteract(player, hand, item, entity));
    }

    public static boolean onItemRightClick(zj player, qm hand, adq stack) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickItem(player, hand, stack));
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(zj player, cl pos, cs face, bbh hitVec) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(zj player, qm hand, adq stack, cl pos, cs face, bbh hitVec) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, stack, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static void onEmptyClick(zj player, qm hand) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could to grab json context!");
        }
        return ctx;
    }

    public static azw loadLootTable(Gson gson, kl name, String data, boolean custom) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        azw ret = null;
        try {
            que.push(new LootTableContext(name, custom));
            ret = (azw)gson.fromJson(data, azw.class);
            que.pop();
        }
        catch (JsonParseException e) {
            que.pop();
            throw e;
        }
        if (!custom) {
            ret = ForgeEventFactory.loadLootTable(name, ret);
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("name")) {
            return oe.h((JsonObject)json, (String)"name");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        if (!ctx.vanilla) {
            throw new JsonParseException("Loot Table \"" + ctx.name.toString() + "\" Missing `name` entry for pool #" + (ctx.poolCount - 1));
        }
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(oe.h((JsonObject)json, (String)"entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = oe.h((JsonObject)json, (String)"name");
        } else if ("loot_table".equals(type)) {
            name = oe.h((JsonObject)json, (String)"name");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static azv deserializeJsonLootEntry(String type, JsonObject json, int weight, int quality, bap[] conditions) {
        return null;
    }

    public static String getLootEntryType(azv entry) {
        return null;
    }

    static {
        seedList.add(new SeedEntry(new adq(ads.P), 10){

            @Override
            public adq getStack(Random rand, int fortune) {
                return new adq(ads.P, 1 + rand.nextInt(fortune * 2 + 1));
            }
        });
        ForgeHooks.initTools();
        URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
        craftingPlayer = new ThreadLocal();
        lootContext = new ThreadLocal();
    }

    private static class LootTableContext {
        public final kl name;
        private final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(kl name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.b());
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(String name) {
            if (!this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            if (!this.vanilla) {
                throw new JsonParseException("Loot Table \"" + this.name.toString() + "\" Duplicate entry name \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
            }
            int x = 0;
            while (this.entryNames.contains(name + "#" + x)) {
                ++x;
            }
            name = name + "#" + x;
            this.entryNames.add(name);
            return name;
        }
    }

    static class SeedEntry
    extends ov.a {
        public final adq seed;

        public SeedEntry(adq seed, int weight) {
            super(weight);
            this.seed = seed;
        }

        public adq getStack(Random rand, int fortune) {
            return this.seed.k();
        }
    }
}

