/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;

public class ForgeChunkManager {
    private static int defaultMaxCount;
    private static int defaultMaxChunks;
    private static boolean overridesEnabled;
    private static Map<aht, Multimap<String, Ticket>> tickets;
    private static Map<String, Integer> ticketConstraints;
    private static Map<String, Integer> chunkConstraints;
    private static SetMultimap<String, Ticket> playerTickets;
    private static Map<String, LoadingCallback> callbacks;
    private static Map<aht, ImmutableSetMultimap<ahn, Ticket>> forcedChunks;
    private static BiMap<UUID, Ticket> pendingEntities;
    private static Map<aht, Cache<Long, asf>> dormantChunkCache;
    private static File cfgFile;
    private static Configuration config;
    private static int playerTicketLength;
    private static int dormantChunkCacheSize;
    public static final List<String> MOD_PROP_ORDER;
    private static Set<String> warnedMods;

    public static Iterator<asf> getPersistentChunksIterableFor(final aht world, Iterator<asf> chunkIterator) {
        ImmutableSetMultimap<ahn, Ticket> persistentChunksFor = ForgeChunkManager.getPersistentChunksFor(world);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        world.C.a("forcedChunkLoading");
        builder.addAll(Iterators.transform((Iterator)persistentChunksFor.keys().iterator(), (Function)new Function<ahn, asf>(){

            @Nullable
            public asf apply(@Nullable ahn input) {
                return world.a(input.a, input.b);
            }
        }));
        world.C.c("regularChunkLoading");
        builder.addAll(chunkIterator);
        world.C.b();
        return builder.build().iterator();
    }

    public static boolean savedWorldHasForcedChunkTickets(File chunkDir) {
        File chunkLoaderData = new File(chunkDir, "forcedchunks.dat");
        if (chunkLoaderData.exists() && chunkLoaderData.isFile()) {
            try {
                dq forcedChunkData = dz.a((File)chunkLoaderData);
                return forcedChunkData.c("TicketList", 10).c() > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static void loadWorld(aht world) {
        ArrayListMultimap newTickets = ArrayListMultimap.create();
        tickets.put(world, (Multimap<String, Ticket>)newTickets);
        forcedChunks.put(world, (ImmutableSetMultimap<ahn, Ticket>)ImmutableSetMultimap.of());
        if (!(world instanceof lq)) {
            return;
        }
        dormantChunkCache.put(world, (Cache<Long, asf>)CacheBuilder.newBuilder().maximumSize((long)dormantChunkCacheSize).build());
        lq worldServer = (lq)world;
        File chunkDir = worldServer.getChunkSaveLocation();
        File chunkLoaderData = new File(chunkDir, "forcedchunks.dat");
        if (chunkLoaderData.exists() && chunkLoaderData.isFile()) {
            LoadingCallback loadingCallback;
            Object tickets;
            dq forcedChunkData;
            ArrayListMultimap loadedTickets = ArrayListMultimap.create();
            HashMap playerLoadedTickets = Maps.newHashMap();
            try {
                forcedChunkData = dz.a((File)chunkLoaderData);
            }
            catch (IOException e) {
                FMLLog.log(Level.WARN, e, "Unable to read forced chunk data at %s - it will be ignored", chunkLoaderData.getAbsolutePath());
                return;
            }
            dw ticketList = forcedChunkData.c("TicketList", 10);
            for (int i = 0; i < ticketList.c(); ++i) {
                dq ticketHolder = ticketList.b(i);
                String modId = ticketHolder.l("Owner");
                boolean isPlayer = "Forge".equals(modId);
                if (!isPlayer && !Loader.isModLoaded(modId)) {
                    FMLLog.warning("Found chunkloading data for mod %s which is currently not available or active - it will be removed from the world save", modId);
                    continue;
                }
                if (!isPlayer && !callbacks.containsKey(modId)) {
                    FMLLog.warning("The mod %s has registered persistent chunkloading data but doesn't seem to want to be called back with it - it will be removed from the world save", modId);
                    continue;
                }
                tickets = ticketHolder.c("Tickets", 10);
                for (int j = 0; j < tickets.c(); ++j) {
                    dq ticket = tickets.b(j);
                    modId = ticket.e("ModId") ? ticket.l("ModId") : modId;
                    Type type = Type.values()[ticket.f("Type")];
                    Ticket tick = new Ticket(modId, type, world);
                    if (ticket.e("ModData")) {
                        tick.modData = ticket.o("ModData");
                    }
                    if (ticket.e("Player")) {
                        tick.player = ticket.l("Player");
                        if (!playerLoadedTickets.containsKey(tick.modId)) {
                            playerLoadedTickets.put(modId, ArrayListMultimap.create());
                        }
                        ((ListMultimap)playerLoadedTickets.get(tick.modId)).put((Object)tick.player, (Object)tick);
                    } else {
                        loadedTickets.put((Object)modId, (Object)tick);
                    }
                    if (type != Type.ENTITY) continue;
                    tick.entityChunkX = ticket.h("chunkX");
                    tick.entityChunkZ = ticket.h("chunkZ");
                    UUID uuid = new UUID(ticket.i("PersistentIDMSB"), ticket.i("PersistentIDLSB"));
                    pendingEntities.put((Object)uuid, (Object)tick);
                }
            }
            for (Ticket tick : ImmutableSet.copyOf((Collection)pendingEntities.values())) {
                if (tick.ticketType != Type.ENTITY || tick.entity != null) continue;
                world.a(tick.entityChunkX, tick.entityChunkZ);
            }
            for (Ticket tick : ImmutableSet.copyOf((Collection)pendingEntities.values())) {
                if (tick.ticketType != Type.ENTITY || tick.entity != null) continue;
                FMLLog.warning("Failed to load persistent chunkloading entity %s from store.", pendingEntities.inverse().get((Object)tick));
                loadedTickets.remove((Object)tick.modId, (Object)tick);
            }
            pendingEntities.clear();
            for (String modId : loadedTickets.keySet()) {
                loadingCallback = callbacks.get(modId);
                if (loadingCallback == null) continue;
                int maxTicketLength = ForgeChunkManager.getMaxTicketLengthFor(modId);
                tickets = loadedTickets.get((Object)modId);
                if (loadingCallback instanceof OrderedLoadingCallback) {
                    OrderedLoadingCallback orderedLoadingCallback = (OrderedLoadingCallback)loadingCallback;
                    tickets = orderedLoadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf((Collection)tickets), world, maxTicketLength);
                }
                if (tickets.size() > maxTicketLength) {
                    FMLLog.warning("The mod %s has too many open chunkloading tickets %d. Excess will be dropped", modId, tickets.size());
                    tickets.subList(maxTicketLength, tickets.size()).clear();
                }
                ForgeChunkManager.tickets.get(world).putAll((Object)modId, (Iterable)tickets);
                loadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf((Collection)tickets), world);
            }
            for (String modId : playerLoadedTickets.keySet()) {
                loadingCallback = callbacks.get(modId);
                if (loadingCallback == null) continue;
                ListMultimap<String, Ticket> tickets2 = (ListMultimap<String, Ticket>)playerLoadedTickets.get(modId);
                if (loadingCallback instanceof PlayerOrderedLoadingCallback) {
                    PlayerOrderedLoadingCallback orderedLoadingCallback = (PlayerOrderedLoadingCallback)loadingCallback;
                    tickets2 = orderedLoadingCallback.playerTicketsLoaded((ListMultimap<String, Ticket>)ImmutableListMultimap.copyOf((Multimap)tickets2), world);
                    playerTickets.putAll(tickets2);
                }
                ForgeChunkManager.tickets.get(world).putAll((Object)"Forge", (Iterable)tickets2.values());
                loadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf((Collection)tickets2.values()), world);
            }
        }
    }

    static void unloadWorld(aht world) {
        if (!(world instanceof lq)) {
            return;
        }
        forcedChunks.remove(world);
        dormantChunkCache.remove(world);
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().w()) {
            playerTickets.clear();
            tickets.clear();
        }
    }

    public static void setForcedChunkLoadingCallback(Object mod, LoadingCallback callback) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container == null) {
            FMLLog.warning("Unable to register a callback for an unknown mod %s (%s : %x)", mod, mod.getClass().getName(), System.identityHashCode(mod));
            return;
        }
        callbacks.put(container.getModId(), callback);
    }

    public static int ticketCountAvailableFor(Object mod, aht world) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            String modId = container.getModId();
            int allowedCount = ForgeChunkManager.getMaxTicketLengthFor(modId);
            return allowedCount - tickets.get(world).get((Object)modId).size();
        }
        return 0;
    }

    private static ModContainer getContainer(Object mod) {
        ModContainer container = (ModContainer)Loader.instance().getModObjectList().inverse().get(mod);
        return container;
    }

    public static int getMaxTicketLengthFor(String modId) {
        int allowedCount = ticketConstraints.containsKey(modId) && overridesEnabled ? ticketConstraints.get(modId) : defaultMaxCount;
        return allowedCount;
    }

    public static int getMaxChunkDepthFor(String modId) {
        int allowedCount = chunkConstraints.containsKey(modId) && overridesEnabled ? chunkConstraints.get(modId) : defaultMaxChunks;
        return allowedCount;
    }

    public static int ticketCountAvailableFor(String username) {
        return playerTicketLength - playerTickets.get((Object)username).size();
    }

    public static Ticket requestPlayerTicket(Object mod, String player, aht world, Type type) {
        ModContainer mc2 = ForgeChunkManager.getContainer(mod);
        if (mc2 == null) {
            FMLLog.log(Level.ERROR, "Failed to locate the container for mod instance %s (%s : %x)", mod, mod.getClass().getName(), System.identityHashCode(mod));
            return null;
        }
        if (playerTickets.get((Object)player).size() > playerTicketLength) {
            FMLLog.warning("Unable to assign further chunkloading tickets to player %s (on behalf of mod %s)", player, mc2.getModId());
            return null;
        }
        Ticket ticket = new Ticket(mc2.getModId(), type, world, player);
        playerTickets.put((Object)player, (Object)ticket);
        tickets.get(world).put((Object)"Forge", (Object)ticket);
        return ticket;
    }

    public static Ticket requestTicket(Object mod, aht world, Type type) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container == null) {
            FMLLog.log(Level.ERROR, "Failed to locate the container for mod instance %s (%s : %x)", mod, mod.getClass().getName(), System.identityHashCode(mod));
            return null;
        }
        String modId = container.getModId();
        if (!callbacks.containsKey(modId)) {
            FMLLog.severe("The mod %s has attempted to request a ticket without a listener in place", modId);
            throw new RuntimeException("Invalid ticket request");
        }
        int allowedCount = ForgeChunkManager.getMaxTicketLengthFor(modId);
        if (tickets.get(world).get((Object)modId).size() >= allowedCount) {
            if (!warnedMods.contains(modId)) {
                FMLLog.info("The mod %s has attempted to allocate a chunkloading ticket beyond it's currently allocated maximum : %d", modId, allowedCount);
                warnedMods.add(modId);
            }
            return null;
        }
        Ticket ticket = new Ticket(modId, type, world);
        tickets.get(world).put((Object)modId, (Object)ticket);
        return ticket;
    }

    public static void releaseTicket(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        if (ticket.isPlayerTicket() ? !playerTickets.containsValue((Object)ticket) : !tickets.get(ticket.world).containsEntry((Object)ticket.modId, (Object)ticket)) {
            return;
        }
        if (ticket.requestedChunks != null) {
            for (ahn chunk : ImmutableSet.copyOf((Collection)ticket.requestedChunks)) {
                ForgeChunkManager.unforceChunk(ticket, chunk);
            }
        }
        if (ticket.isPlayerTicket()) {
            playerTickets.remove((Object)ticket.player, (Object)ticket);
            tickets.get(ticket.world).remove((Object)"Forge", (Object)ticket);
        } else {
            tickets.get(ticket.world).remove((Object)ticket.modId, (Object)ticket);
        }
    }

    public static void forceChunk(Ticket ticket, ahn chunk) {
        if (ticket == null || chunk == null) {
            return;
        }
        if (ticket.ticketType == Type.ENTITY && ticket.entity == null) {
            throw new RuntimeException("Attempted to use an entity ticket to force a chunk, without an entity");
        }
        if (ticket.isPlayerTicket() ? !playerTickets.containsValue((Object)ticket) : !tickets.get(ticket.world).containsEntry((Object)ticket.modId, (Object)ticket)) {
            FMLLog.severe("The mod %s attempted to force load a chunk with an invalid ticket. This is not permitted.", ticket.modId);
            return;
        }
        ticket.requestedChunks.add(chunk);
        MinecraftForge.EVENT_BUS.post(new ForceChunkEvent(ticket, chunk));
        ImmutableSetMultimap newMap = ImmutableSetMultimap.builder().putAll((Multimap)forcedChunks.get(ticket.world)).put((Object)chunk, (Object)ticket).build();
        forcedChunks.put(ticket.world, (ImmutableSetMultimap<ahn, Ticket>)newMap);
        if (ticket.maxDepth > 0 && ticket.requestedChunks.size() > ticket.maxDepth) {
            ahn removed = (ahn)ticket.requestedChunks.iterator().next();
            ForgeChunkManager.unforceChunk(ticket, removed);
        }
    }

    public static void reorderChunk(Ticket ticket, ahn chunk) {
        if (ticket == null || chunk == null || !ticket.requestedChunks.contains(chunk)) {
            return;
        }
        ticket.requestedChunks.remove(chunk);
        ticket.requestedChunks.add(chunk);
    }

    public static void unforceChunk(Ticket ticket, ahn chunk) {
        if (ticket == null || chunk == null) {
            return;
        }
        ticket.requestedChunks.remove(chunk);
        MinecraftForge.EVENT_BUS.post(new UnforceChunkEvent(ticket, chunk));
        LinkedHashMultimap copy = LinkedHashMultimap.create((Multimap)((Multimap)forcedChunks.get(ticket.world)));
        copy.remove((Object)chunk, (Object)ticket);
        ImmutableSetMultimap newMap = ImmutableSetMultimap.copyOf((Multimap)copy);
        forcedChunks.put(ticket.world, (ImmutableSetMultimap<ahn, Ticket>)newMap);
    }

    static void loadConfiguration() {
        ticketConstraints.clear();
        chunkConstraints.clear();
        for (String mod : config.getCategoryNames()) {
            if (mod.equals("Forge") || mod.equals("defaults")) continue;
            Property modTC = config.get(mod, "maximumTicketCount", 200);
            Property modCPT = config.get(mod, "maximumChunksPerTicket", 25);
            ticketConstraints.put(mod, modTC.getInt(200));
            chunkConstraints.put(mod, modCPT.getInt(25));
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static ImmutableSetMultimap<ahn, Ticket> getPersistentChunksFor(aht world) {
        return forcedChunks.containsKey(world) ? forcedChunks.get(world) : ImmutableSetMultimap.of();
    }

    static void saveWorld(aht world) {
        if (!(world instanceof lq)) {
            return;
        }
        lq worldServer = (lq)world;
        File chunkDir = worldServer.getChunkSaveLocation();
        File chunkLoaderData = new File(chunkDir, "forcedchunks.dat");
        dq forcedChunkData = new dq();
        dw ticketList = new dw();
        forcedChunkData.a("TicketList", (ed)ticketList);
        Multimap<String, Ticket> ticketSet = tickets.get(worldServer);
        if (ticketSet == null) {
            return;
        }
        for (String modId : ticketSet.keySet()) {
            dq ticketHolder = new dq();
            ticketList.a((ed)ticketHolder);
            ticketHolder.a("Owner", modId);
            dw tickets = new dw();
            ticketHolder.a("Tickets", (ed)tickets);
            for (Ticket tick : ticketSet.get((Object)modId)) {
                dq ticket = new dq();
                ticket.a("Type", (byte)tick.ticketType.ordinal());
                ticket.a("ChunkListDepth", (byte)tick.maxDepth);
                if (tick.isPlayerTicket()) {
                    ticket.a("ModId", tick.modId);
                    ticket.a("Player", tick.player);
                }
                if (tick.modData != null) {
                    ticket.a("ModData", (ed)tick.modData);
                }
                if (tick.ticketType == Type.ENTITY && tick.entity != null && tick.entity.d(new dq())) {
                    ticket.a("chunkX", on.c((double)((Ticket)tick).entity.ab));
                    ticket.a("chunkZ", on.c((double)((Ticket)tick).entity.ad));
                    ticket.a("PersistentIDMSB", tick.entity.getPersistentID().getMostSignificantBits());
                    ticket.a("PersistentIDLSB", tick.entity.getPersistentID().getLeastSignificantBits());
                    tickets.a((ed)ticket);
                    continue;
                }
                if (tick.ticketType == Type.ENTITY) continue;
                tickets.a((ed)ticket);
            }
        }
        try {
            dz.b((dq)forcedChunkData, (File)chunkLoaderData);
        }
        catch (IOException e) {
            FMLLog.log(Level.WARN, e, "Unable to write forced chunk data to %s - chunkloading won't work", chunkLoaderData.getAbsolutePath());
            return;
        }
    }

    static void loadEntity(rr entity) {
        UUID id = entity.getPersistentID();
        Ticket tick = (Ticket)pendingEntities.get((Object)id);
        if (tick != null) {
            tick.bindEntity(entity);
            pendingEntities.remove((Object)id);
        }
    }

    public static void putDormantChunk(long coords, asf chunk) {
        Cache<Long, asf> cache = dormantChunkCache.get(chunk.q());
        if (cache != null) {
            cache.put((Object)coords, (Object)chunk);
        }
    }

    public static asf fetchDormantChunk(long coords, aht world) {
        Cache<Long, asf> cache = dormantChunkCache.get(world);
        if (cache == null) {
            return null;
        }
        asf chunk = (asf)cache.getIfPresent((Object)coords);
        if (chunk != null) {
            for (nz eList : chunk.t()) {
                Iterator itr = eList.iterator();
                while (itr.hasNext()) {
                    ((rr)itr.next()).resetEntityId();
                }
            }
        }
        return chunk;
    }

    static void captureConfig(File configDir) {
        cfgFile = new File(configDir, "forgeChunkLoading.cfg");
        config = new Configuration(cfgFile, true);
        try {
            config.load();
        }
        catch (Exception e) {
            File dest = new File(cfgFile.getParentFile(), "forgeChunkLoading.cfg.bak");
            if (dest.exists()) {
                dest.delete();
            }
            cfgFile.renameTo(dest);
            FMLLog.log(Level.ERROR, e, "A critical error occurred reading the forgeChunkLoading.cfg file, defaults will be used - the invalid file is backed up at forgeChunkLoading.cfg.bak", new Object[0]);
        }
        ForgeChunkManager.syncConfigDefaults();
    }

    public static void syncConfigDefaults() {
        ArrayList<String> propOrder = new ArrayList<String>();
        config.setCategoryComment("defaults", "Default configuration for forge chunk loading control").setCategoryRequiresWorldRestart("defaults", true);
        Property temp = config.get("defaults", "enabled", true);
        temp.setComment("Are mod overrides enabled?");
        temp.setLanguageKey("forge.configgui.enableModOverrides");
        overridesEnabled = temp.getBoolean(true);
        propOrder.add("enabled");
        temp = config.get("defaults", "maximumChunksPerTicket", 25);
        temp.setComment("The default maximum number of chunks a mod can force, per ticket, \nfor a mod without an override. This is the maximum number of chunks a single ticket can force.");
        temp.setLanguageKey("forge.configgui.maximumChunksPerTicket");
        temp.setMinValue(0);
        defaultMaxChunks = temp.getInt(25);
        propOrder.add("maximumChunksPerTicket");
        temp = config.get("defaults", "maximumTicketCount", 200);
        temp.setComment("The default maximum ticket count for a mod which does not have an override\nin this file. This is the number of chunk loading requests a mod is allowed to make.");
        temp.setLanguageKey("forge.configgui.maximumTicketCount");
        temp.setMinValue(0);
        defaultMaxCount = temp.getInt(200);
        propOrder.add("maximumTicketCount");
        temp = config.get("defaults", "playerTicketCount", 500);
        temp.setComment("The number of tickets a player can be assigned instead of a mod. This is shared across all mods and it is up to the mods to use it.");
        temp.setLanguageKey("forge.configgui.playerTicketCount");
        temp.setMinValue(0);
        playerTicketLength = temp.getInt(500);
        propOrder.add("playerTicketCount");
        temp = config.get("defaults", "dormantChunkCacheSize", 0);
        temp.setComment("Unloaded chunks can first be kept in a dormant cache for quicker\nloading times. Specify the size (in chunks) of that cache here");
        temp.setLanguageKey("forge.configgui.dormantChunkCacheSize");
        temp.setMinValue(0);
        dormantChunkCacheSize = temp.getInt(0);
        propOrder.add("dormantChunkCacheSize");
        FMLLog.info("Configured a dormant chunk cache size of %d", temp.getInt(0));
        config.setCategoryPropertyOrder("defaults", propOrder);
        config.addCustomCategoryComment("Forge", "Sample mod specific control section.\nCopy this section and rename the with the modid for the mod you wish to override.\nA value of zero in either entry effectively disables any chunkloading capabilities\nfor that mod");
        temp = config.get("Forge", "maximumTicketCount", 200);
        temp.setComment("Maximum ticket count for the mod. Zero disables chunkloading capabilities.");
        temp = config.get("Forge", "maximumChunksPerTicket", 25);
        temp.setComment("Maximum chunks per ticket for the mod.");
        for (String mod : config.getCategoryNames()) {
            if (mod.equals("Forge") || mod.equals("defaults")) continue;
            config.get(mod, "maximumTicketCount", 200).setLanguageKey("forge.configgui.maximumTicketCount").setMinValue(0);
            config.get(mod, "maximumChunksPerTicket", 25).setLanguageKey("forge.configgui.maximumChunksPerTicket").setMinValue(0);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    public static ConfigCategory getDefaultsCategory() {
        return config.getCategory("defaults");
    }

    public static List<ConfigCategory> getModCategories() {
        ArrayList<ConfigCategory> list = new ArrayList<ConfigCategory>();
        for (String mod : config.getCategoryNames()) {
            if (mod.equals("Forge") || mod.equals("defaults")) continue;
            list.add(config.getCategory(mod));
        }
        return list;
    }

    public static ConfigCategory getConfigFor(Object mod) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            return config.getCategory(container.getModId());
        }
        return null;
    }

    public static void addConfigProperty(Object mod, String propertyName, String value, Property.Type type) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            ConfigCategory cat = config.getCategory(container.getModId());
            Property prop = new Property(propertyName, value, type).setLanguageKey("forge.configgui." + propertyName);
            if (type == Property.Type.INTEGER) {
                prop.setMinValue(0);
            }
            cat.put(propertyName, prop);
        }
    }

    static {
        tickets = new MapMaker().weakKeys().makeMap();
        ticketConstraints = Maps.newHashMap();
        chunkConstraints = Maps.newHashMap();
        playerTickets = HashMultimap.create();
        callbacks = Maps.newHashMap();
        forcedChunks = new MapMaker().weakKeys().makeMap();
        pendingEntities = HashBiMap.create();
        dormantChunkCache = new MapMaker().weakKeys().makeMap();
        MOD_PROP_ORDER = new ArrayList<String>(2);
        warnedMods = Sets.newHashSet();
        MOD_PROP_ORDER.add("maximumTicketCount");
        MOD_PROP_ORDER.add("maximumChunksPerTicket");
    }

    public static class UnforceChunkEvent
    extends Event {
        private final Ticket ticket;
        private final ahn location;

        public UnforceChunkEvent(Ticket ticket, ahn location) {
            this.ticket = ticket;
            this.location = location;
        }

        public Ticket getTicket() {
            return this.ticket;
        }

        public ahn getLocation() {
            return this.location;
        }
    }

    public static class ForceChunkEvent
    extends Event {
        private final Ticket ticket;
        private final ahn location;

        public ForceChunkEvent(Ticket ticket, ahn location) {
            this.ticket = ticket;
            this.location = location;
        }

        public Ticket getTicket() {
            return this.ticket;
        }

        public ahn getLocation() {
            return this.location;
        }
    }

    public static class Ticket {
        private String modId;
        private Type ticketType;
        private LinkedHashSet<ahn> requestedChunks;
        private dq modData;
        public final aht world;
        private int maxDepth;
        private int entityChunkX;
        private int entityChunkZ;
        private rr entity;
        private String player;

        Ticket(String modId, Type type, aht world) {
            this.modId = modId;
            this.ticketType = type;
            this.world = world;
            this.maxDepth = ForgeChunkManager.getMaxChunkDepthFor(modId);
            this.requestedChunks = Sets.newLinkedHashSet();
        }

        Ticket(String modId, Type type, aht world, String player) {
            this(modId, type, world);
            if (player == null) {
                FMLLog.log(Level.ERROR, "Attempt to create a player ticket without a valid player", new Object[0]);
                throw new RuntimeException();
            }
            this.player = player;
        }

        public void setChunkListDepth(int depth) {
            if (depth > ForgeChunkManager.getMaxChunkDepthFor(this.modId) || depth <= 0 && ForgeChunkManager.getMaxChunkDepthFor(this.modId) > 0) {
                FMLLog.warning("The mod %s tried to modify the chunk ticket depth to: %d, its allowed maximum is: %d", this.modId, depth, ForgeChunkManager.getMaxChunkDepthFor(this.modId));
            } else {
                this.maxDepth = depth;
            }
        }

        public int getChunkListDepth() {
            return this.maxDepth;
        }

        public int getMaxChunkListDepth() {
            return ForgeChunkManager.getMaxChunkDepthFor(this.modId);
        }

        public void bindEntity(rr entity) {
            if (this.ticketType != Type.ENTITY) {
                throw new RuntimeException("Cannot bind an entity to a non-entity ticket");
            }
            this.entity = entity;
        }

        public dq getModData() {
            if (this.modData == null) {
                this.modData = new dq();
            }
            return this.modData;
        }

        public rr getEntity() {
            return this.entity;
        }

        public boolean isPlayerTicket() {
            return this.player != null;
        }

        public String getPlayerName() {
            return this.player;
        }

        public String getModId() {
            return this.modId;
        }

        public Type getType() {
            return this.ticketType;
        }

        public ImmutableSet<ahn> getChunkList() {
            return ImmutableSet.copyOf(this.requestedChunks);
        }
    }

    public static enum Type {
        NORMAL,
        ENTITY;

    }

    public static interface PlayerOrderedLoadingCallback
    extends LoadingCallback {
        public ListMultimap<String, Ticket> playerTicketsLoaded(ListMultimap<String, Ticket> var1, aht var2);
    }

    public static interface OrderedLoadingCallback
    extends LoadingCallback {
        public List<Ticket> ticketsLoaded(List<Ticket> var1, aht var2, int var3);
    }

    public static interface LoadingCallback {
        public void ticketsLoaded(List<Ticket> var1, aht var2);
    }
}

