/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class MultiLayerModel
implements IModelCustomData {
    public static final MultiLayerModel INSTANCE = new MultiLayerModel((ImmutableMap<Optional<ahm>, bxq>)ImmutableMap.of());
    private final ImmutableMap<Optional<ahm>, bxq> models;

    public MultiLayerModel(ImmutableMap<Optional<ahm>, bxq> models) {
        this.models = models;
    }

    @Override
    public Collection<kl> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    @Override
    public Collection<kl> getTextures() {
        return ImmutableList.of();
    }

    private static ImmutableMap<Optional<ahm>, bxl> buildModels(ImmutableMap<Optional<ahm>, bxq> models, IModelState state, bvo format, Function<kl, bve> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((kl)models.get((Object)key), "Couldn't load MultiLayerModel dependency: " + models.get((Object)key));
            builder.put((Object)key, (Object)model.bake(new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    @Override
    public bxl bake(IModelState state, bvo format, Function<kl, bve> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), IPerspectiveAwareModel.MapWrapper.getTransforms(state));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (ahm layer : ahm.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put((Object)Optional.of((Object)layer), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new MultiLayerModel((ImmutableMap<Optional<ahm>, bxq>)models);
    }

    private bxq getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new bxq(e.getAsString());
        }
        FMLLog.severe("Expect ModelResourceLocation, got: ", json);
        return new bxq("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void a(bwd resourceManager) {
        }

        @Override
        public boolean accepts(kl modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("multi-layer") || modelLocation.a().equals("models/block/multi-layer") || modelLocation.a().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(kl modelLocation) {
            return INSTANCE;
        }
    }

    private static final class MultiLayerBakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<Optional<ahm>, bxl> models;
        private final ImmutableMap<bop.b, TRSRTransformation> cameraTransforms;
        private final bxl base;
        private final bxl missing;
        private final ImmutableMap<Optional<cs>, ImmutableList<boc>> quads;

        public MultiLayerBakedModel(ImmutableMap<Optional<ahm>, bxl> models, bxl missing, ImmutableMap<bop.b, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = models.containsKey((Object)Optional.absent()) ? (bxl)models.get((Object)Optional.absent()) : missing;
            ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
            quadBuilder.put((Object)Optional.absent(), MultiLayerBakedModel.buildQuads(models, (Optional<cs>)Optional.absent()));
            for (cs side : cs.values()) {
                quadBuilder.put((Object)Optional.of((Object)side), MultiLayerBakedModel.buildQuads(models, (Optional<cs>)Optional.of((Object)side)));
            }
            this.quads = quadBuilder.build();
        }

        private static ImmutableList<boc> buildQuads(ImmutableMap<Optional<ahm>, bxl> models, Optional<cs> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (bxl model : models.values()) {
                builder.addAll((Iterable)model.a(null, (cs)side.orNull(), 0L));
            }
            return builder.build();
        }

        public List<boc> a(ard state, cs side, long rand) {
            ahm layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                return (List)this.quads.get((Object)Optional.fromNullable((Object)side));
            }
            bxl model = !this.models.containsKey((Object)Optional.of((Object)layer)) ? this.missing : (bxl)this.models.get((Object)Optional.of((Object)layer));
            return model.a(state, side, rand);
        }

        public boolean a() {
            return this.base.a();
        }

        public boolean b() {
            return this.base.b();
        }

        public boolean c() {
            return this.base.c();
        }

        public bve d() {
            return this.base.d();
        }

        public bop e() {
            return bop.a;
        }

        @Override
        public Pair<? extends bxl, Matrix4f> handlePerspective(bop.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((bxl)this, this.cameraTransforms, cameraTransformType);
        }

        public bon f() {
            return bon.a;
        }
    }
}

