/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.injection.struct.InvalidMemberDescriptorException;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.SrgMethod;
import org.spongepowered.tools.MirrorUtils;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandler;
import org.spongepowered.tools.obfuscation.AnnotatedMixins;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.struct.Message;

class AnnotatedMixinInjectorHandler
extends AnnotatedMixinElementHandler {
    AnnotatedMixinInjectorHandler(IMixinAnnotationProcessor ap, AnnotatedMixin mixin) {
        super(ap, mixin);
    }

    public Message registerInjector(ExecutableElement method, AnnotationMirror inject, boolean remap) {
        if (this.mixin.isInterface()) {
            this.ap.printMessage(Diagnostic.Kind.ERROR, "Injector in interface is unsupported", method);
        }
        String originalReference = (String)MirrorUtils.getAnnotationValue(inject, "method");
        MemberInfo targetMember = MemberInfo.parse(originalReference);
        if (targetMember.name == null) {
            return null;
        }
        try {
            targetMember.validate();
        }
        catch (InvalidMemberDescriptorException ex) {
            this.ap.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), method, inject);
        }
        String type = "@" + inject.getAnnotationType().asElement().getSimpleName() + "";
        if (targetMember.desc != null) {
            this.validateReferencedTarget(method, inject, targetMember, type);
        }
        if (!remap || !this.validateSingleTarget(type, method)) {
            return null;
        }
        String desc = this.mixin.getPrimaryTarget().findDescriptor(targetMember);
        if (desc == null) {
            if (this.mixin.getPrimaryTarget().isImaginary()) {
                this.ap.printMessage(Diagnostic.Kind.WARNING, type + " target requires method signature because enclosing type information is unavailable", method, inject);
            } else if (!"<init>".equals(targetMember.name)) {
                this.ap.printMessage(Diagnostic.Kind.WARNING, "Unable to determine signature for " + type + " target method", method, inject);
            }
            return null;
        }
        ObfuscationData<SrgMethod> obfData = this.obf.getObfMethod(new SrgMethod(this.mixin.getPrimaryTargetRef() + "/" + targetMember.name, desc));
        if (obfData.isEmpty()) {
            Diagnostic.Kind error = "<init>".equals(targetMember.name) ? Diagnostic.Kind.WARNING : Diagnostic.Kind.ERROR;
            return new Message(error, "No obfuscation mapping for " + type + " target " + targetMember.name, method, inject);
        }
        this.obf.addMethodMapping(this.classRef, originalReference, obfData);
        return null;
    }

    public int registerInjectionPoint(Element element, AnnotationMirror inject, AnnotationMirror at) {
        if (this.mixin.isInterface()) {
            this.ap.printMessage(Diagnostic.Kind.ERROR, "Injector in interface is unsupported", element);
        }
        if (!AnnotatedMixins.getRemapValue(at)) {
            return 0;
        }
        String type = (String)MirrorUtils.getAnnotationValue(at, "value");
        String target = (String)MirrorUtils.getAnnotationValue(at, "target");
        int remapped = this.remapReference(type + ".<target>", target, element, inject, at) ? 1 : 0;
        return remapped;
    }

    static Map<String, String> getAtArgs(AnnotationMirror at) {
        HashMap<String, String> args = new HashMap<String, String>();
        List argv = (List)MirrorUtils.getAnnotationValue(at, "args");
        if (argv != null) {
            for (AnnotationValue av : argv) {
                String arg = (String)av.getValue();
                if (arg == null) continue;
                int eqPos = arg.indexOf(61);
                if (eqPos > -1) {
                    args.put(arg.substring(0, eqPos), arg.substring(eqPos + 1));
                    continue;
                }
                args.put(arg, "");
            }
        }
        return args;
    }
}

