/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.injection.struct.InvalidMemberDescriptorException;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.SrgMethod;
import org.spongepowered.asm.util.ConstraintParser;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import org.spongepowered.tools.MirrorUtils;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.FieldHandle;
import org.spongepowered.tools.obfuscation.MethodHandle;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.TypeHandle;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;

abstract class AnnotatedMixinElementHandler {
    protected final AnnotatedMixin mixin;
    protected final String classRef;
    protected final IMixinAnnotationProcessor ap;
    protected final IObfuscationManager obf;

    AnnotatedMixinElementHandler(IMixinAnnotationProcessor ap, AnnotatedMixin mixin) {
        this.ap = ap;
        this.mixin = mixin;
        this.classRef = mixin.getClassRef();
        this.obf = ap.getObfuscationManager();
    }

    protected final boolean remapReference(String key, String target, Element element, AnnotationMirror inject, AnnotationMirror at) {
        if (target == null) {
            return false;
        }
        MemberInfo targetMember = MemberInfo.parse(target);
        if (!targetMember.isFullyQualified()) {
            String missing = "missing " + (targetMember.owner == null ? (targetMember.desc == null ? "owner and signature" : "owner") : "signature");
            this.ap.printMessage(Diagnostic.Kind.ERROR, "@At(" + key + ") is not fully qualified, " + missing, element, inject);
            return false;
        }
        try {
            targetMember.validate();
        }
        catch (InvalidMemberDescriptorException ex) {
            this.ap.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), element, inject);
        }
        if (targetMember.isField()) {
            ObfuscationData<String> obfFieldData = this.obf.getObfFieldRecursive(targetMember);
            if (obfFieldData.isEmpty()) {
                this.ap.printMessage(Diagnostic.Kind.WARNING, "Cannot find field mapping for @At(" + key + ") '" + target + "'", element, inject);
                return false;
            }
            this.obf.addFieldMapping(this.classRef, target, targetMember, obfFieldData);
        } else {
            ObfuscationData<SrgMethod> obfMethodData = this.obf.getObfMethodRecursive(targetMember);
            if (obfMethodData.isEmpty() && (targetMember.owner == null || !targetMember.owner.startsWith("java/lang/"))) {
                this.ap.printMessage(Diagnostic.Kind.WARNING, "Cannot find method mapping for @At(" + key + ") '" + target + "'", element, inject);
            }
            this.obf.addMethodMapping(this.classRef, target, targetMember, obfMethodData);
        }
        return true;
    }

    protected final void addFieldMapping(ObfuscationType type, ShadowElementName name) {
        String mapping = String.format("FD: %s %s", this.classRef + "/" + name.name(), this.classRef + "/" + name.obfuscated());
        this.mixin.addFieldMapping(type, mapping);
    }

    protected final void addMethodMapping(ObfuscationType type, ShadowElementName name, String mcpSignature, String obfSignature) {
        this.addMethodMapping(type, name.name(), name.obfuscated(), mcpSignature, obfSignature);
    }

    protected final void addMethodMapping(ObfuscationType type, String mcpName, String obfName, String mcpSignature, String obfSignature) {
        String mapping = String.format("MD: %s %s %s %s", this.classRef + "/" + mcpName, mcpSignature, this.classRef + "/" + obfName, obfSignature);
        this.mixin.addMethodMapping(type, mapping);
    }

    protected final boolean validateSingleTarget(String annotation, Element element) {
        if (this.mixin.getPrimaryTargetRef() == null || this.mixin.getTargets().size() > 1) {
            this.ap.printMessage(Diagnostic.Kind.ERROR, "Mixin with " + annotation + " members must have exactly one target.", element);
            this.ap.printMessage(Diagnostic.Kind.ERROR, "Mixin with " + annotation + " members must have exactly one target.", this.mixin.getMixin());
            return false;
        }
        return true;
    }

    protected final void checkConstraints(ExecutableElement method, AnnotationMirror annotation) {
        try {
            ConstraintParser.Constraint constraint = ConstraintParser.parse((String)MirrorUtils.getAnnotationValue(annotation, "constraints"));
            try {
                constraint.check(this.ap.getTokenProvider());
            }
            catch (ConstraintViolationException ex) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), method, annotation);
            }
        }
        catch (InvalidConstraintException ex) {
            this.ap.printMessage(Diagnostic.Kind.WARNING, ex.getMessage(), method, annotation);
        }
    }

    protected final void validateTargetMethod(ExecutableElement method, AnnotationMirror annotation, AliasedElementName name, String type) {
        String signature = MirrorUtils.getJavaSignature(method);
        for (TypeHandle target : this.mixin.getTargets()) {
            String alias;
            MethodHandle targetMethod;
            if (target.isImaginary() || (targetMethod = target.findMethod(method)) != null || !name.baseName().equals(name.elementName()) && (targetMethod = target.findMethod(name.baseName(), signature)) != null) continue;
            Iterator<String> i$ = name.getAliases().iterator();
            while (i$.hasNext() && (targetMethod = target.findMethod(alias = i$.next(), signature)) == null) {
            }
            if (targetMethod != null) continue;
            this.ap.printMessage(Diagnostic.Kind.WARNING, "Cannot find target for " + type + " method in " + target, method, annotation);
        }
    }

    protected final void validateTargetField(VariableElement field, AnnotationMirror shadow, AliasedElementName name, String type) {
        String fieldType = field.asType().toString();
        for (TypeHandle target : this.mixin.getTargets()) {
            String alias;
            FieldHandle targetField;
            if (target.isImaginary() || (targetField = target.findField(field)) != null) continue;
            List<String> aliases = name.getAliases();
            Iterator<String> i$ = aliases.iterator();
            while (i$.hasNext() && (targetField = target.findField(alias = i$.next(), fieldType)) == null) {
            }
            if (targetField != null) continue;
            this.ap.printMessage(Diagnostic.Kind.WARNING, "Cannot find target for " + type + " field in " + target, field, shadow);
        }
    }

    protected final void validateReferencedTarget(ExecutableElement method, AnnotationMirror inject, MemberInfo reference, String type) {
        String signature = reference.toDescriptor();
        for (TypeHandle target : this.mixin.getTargets()) {
            MethodHandle targetMethod;
            if (target.isImaginary() || (targetMethod = target.findMethod(reference.name, signature)) != null) continue;
            this.ap.printMessage(Diagnostic.Kind.WARNING, "Cannot find target method for " + type + " in " + target, method, inject);
        }
    }

    static class ShadowElementName
    extends AliasedElementName {
        private final boolean hasPrefix;
        private final String prefix;
        private final String baseName;
        private String obfuscated;

        ShadowElementName(Element element, AnnotationMirror shadow) {
            super(element, shadow);
            this.prefix = MirrorUtils.getAnnotationValue(shadow, "prefix", "shadow$");
            boolean hasPrefix = false;
            String name = this.originalName;
            if (name.startsWith(this.prefix)) {
                hasPrefix = true;
                name = name.substring(this.prefix.length());
            }
            this.hasPrefix = hasPrefix;
            this.obfuscated = this.baseName = name;
        }

        public String toString() {
            return this.baseName;
        }

        @Override
        public String baseName() {
            return this.baseName;
        }

        public ShadowElementName setObfuscatedName(String name) {
            this.obfuscated = name.substring(name.lastIndexOf(47) + 1);
            return this;
        }

        public String prefix() {
            return this.hasPrefix ? this.prefix : "";
        }

        public String name() {
            return this.prefix(this.baseName);
        }

        public String obfuscated() {
            return this.prefix(this.obfuscated);
        }

        public String prefix(String name) {
            return this.hasPrefix ? this.prefix + name : name;
        }
    }

    static class AliasedElementName {
        protected final String originalName;
        private final List<String> aliases;

        public AliasedElementName(Element element, AnnotationMirror annotation) {
            this.originalName = element.getSimpleName().toString();
            List aliases = (List)MirrorUtils.getAnnotationValue(annotation, "aliases");
            this.aliases = MirrorUtils.unfold(aliases);
        }

        public boolean hasAliases() {
            return this.aliases.size() > 0;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public String elementName() {
            return this.originalName;
        }

        public String baseName() {
            return this.originalName;
        }
    }
}

