/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public abstract class MirrorUtils {
    private static final int MAX_GENERIC_RECURSION_DEPTH = 5;
    private static final String OBJECT_SIG = "java.lang.Object";
    private static final String OBJECT_REF = "java/lang/Object";

    private MirrorUtils() {
    }

    public static AnnotationMirror getAnnotation(Element elem, Class<? extends Annotation> annotationClass) {
        List<? extends AnnotationMirror> annotations = elem.getAnnotationMirrors();
        if (annotations == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : annotations) {
            TypeElement annotationElement;
            Element element = annotationMirror.getAnnotationType().asElement();
            if (!(element instanceof TypeElement) || !(annotationElement = (TypeElement)element).getQualifiedName().contentEquals(annotationClass.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static <T> T getAnnotationValue(AnnotationMirror annotation, String key, T defaultValue) {
        if (annotation == null) {
            return defaultValue;
        }
        AnnotationValue value = MirrorUtils.getAnnotationValue0(annotation, key);
        return (T)(value != null ? value.getValue() : defaultValue);
    }

    public static <T> T getAnnotationValue(TypeElement elem, Class<? extends Annotation> annotationClass, String key, T defaultValue) {
        AnnotationMirror annotation = MirrorUtils.getAnnotation(elem, annotationClass);
        return MirrorUtils.getAnnotationValue(annotation, key, defaultValue);
    }

    public static <T> T getAnnotationValue(AnnotationMirror annotation) {
        return MirrorUtils.getAnnotationValue(annotation, "value", null);
    }

    public static <T> T getAnnotationValue(AnnotationMirror annotation, String key) {
        return MirrorUtils.getAnnotationValue(annotation, key, null);
    }

    public static <T> T getAnnotationValue(TypeElement elem, Class<? extends Annotation> annotationClass) {
        return MirrorUtils.getAnnotationValue(elem, annotationClass, "value");
    }

    public static <T> T getAnnotationValue(TypeElement elem, Class<? extends Annotation> annotationClass, String key) {
        AnnotationMirror annotation = MirrorUtils.getAnnotation(elem, annotationClass);
        return MirrorUtils.getAnnotationValue(annotation, key, null);
    }

    private static AnnotationValue getAnnotationValue0(AnnotationMirror annotation, String key) {
        for (ExecutableElement executableElement : annotation.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals(key)) continue;
            return annotation.getElementValues().get(executableElement);
        }
        return null;
    }

    public static <T> List<T> unfold(List<AnnotationValue> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> unfolded = new ArrayList<Object>(list.size());
        for (AnnotationValue value : list) {
            unfolded.add(value.getValue());
        }
        return unfolded;
    }

    public static PackageElement getPackage(TypeElement elem) {
        Element parent;
        for (parent = elem.getEnclosingElement(); parent != null && !(parent instanceof PackageElement); parent = parent.getEnclosingElement()) {
        }
        return (PackageElement)parent;
    }

    public static String getElementType(Element parent) {
        if (parent instanceof TypeElement) {
            return "TypeElement";
        }
        if (parent instanceof ExecutableElement) {
            return "ExecutableElement";
        }
        if (parent instanceof VariableElement) {
            return "VariableElement";
        }
        if (parent instanceof PackageElement) {
            return "PackageElement";
        }
        if (parent instanceof TypeParameterElement) {
            return "TypeParameterElement";
        }
        return parent.getClass().getSimpleName();
    }

    public static String getJavaSignature(Element element) {
        if (element instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)element;
            StringBuilder desc = new StringBuilder().append("(");
            boolean extra = false;
            for (VariableElement variableElement : method.getParameters()) {
                if (extra) {
                    desc.append(',');
                }
                desc.append(MirrorUtils.getTypeName(variableElement.asType()));
                extra = true;
            }
            desc.append(')').append(method.getReturnType().toString());
            return desc.toString();
        }
        return MirrorUtils.getTypeName(element.asType());
    }

    public static String stripGenerics(String type) {
        StringBuilder sb = new StringBuilder();
        int depth = 0;
        for (int pos = 0; pos < type.length(); ++pos) {
            char c2 = type.charAt(pos);
            if (c2 == '<') {
                ++depth;
            }
            if (depth == 0) {
                sb.append(c2);
                continue;
            }
            if (c2 != '>') continue;
            --depth;
        }
        return sb.toString();
    }

    public static String getTypeName(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                return MirrorUtils.getTypeName(((ArrayType)type).getComponentType()) + "[]";
            }
            case DECLARED: {
                return MirrorUtils.getTypeName((DeclaredType)type);
            }
            case TYPEVAR: {
                return MirrorUtils.getTypeName(MirrorUtils.getUpperBound(type));
            }
            case ERROR: {
                return OBJECT_SIG;
            }
        }
        return type.toString();
    }

    public static String getTypeName(DeclaredType type) {
        if (type == null) {
            return OBJECT_SIG;
        }
        return MirrorUtils.getTypeName((TypeElement)type.asElement());
    }

    private static String getTypeName(TypeElement elem) {
        return MirrorUtils.getInternalName(elem).replace('/', '.');
    }

    public static String generateSignature(ExecutableElement method) {
        StringBuilder signature = new StringBuilder();
        for (VariableElement variableElement : method.getParameters()) {
            signature.append(MirrorUtils.getInternalName(variableElement));
        }
        return String.format("(%s)%s", signature, MirrorUtils.getInternalName(method.getReturnType()));
    }

    public static String getInternalName(VariableElement var) {
        return MirrorUtils.getInternalName(var.asType());
    }

    public static String getInternalName(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                return "[" + MirrorUtils.getInternalName(((ArrayType)type).getComponentType());
            }
            case DECLARED: {
                return "L" + MirrorUtils.getInternalName((DeclaredType)type) + ";";
            }
            case TYPEVAR: {
                return "L" + MirrorUtils.getInternalName(MirrorUtils.getUpperBound(type)) + ";";
            }
            case BOOLEAN: {
                return "Z";
            }
            case BYTE: {
                return "B";
            }
            case CHAR: {
                return "C";
            }
            case DOUBLE: {
                return "D";
            }
            case FLOAT: {
                return "F";
            }
            case INT: {
                return "I";
            }
            case LONG: {
                return "J";
            }
            case SHORT: {
                return "S";
            }
            case VOID: {
                return "V";
            }
            case ERROR: {
                return "Ljava/lang/Object;";
            }
        }
        throw new IllegalArgumentException("Unable to parse type symbol " + type + " with " + (Object)((Object)type.getKind()) + " to equivalent bytecode type");
    }

    private static DeclaredType getUpperBound(TypeMirror type) {
        try {
            return MirrorUtils.getUpperBound0(type, 5);
        }
        catch (IllegalStateException ex) {
            throw new IllegalArgumentException("Type symbol \"" + type + "\" is too complex", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unable to compute upper bound of type symbol " + type, ex);
        }
    }

    private static DeclaredType getUpperBound0(TypeMirror type, int depth) {
        if (depth == 0) {
            throw new IllegalStateException("Generic symbol \"" + type + "\" is too complex, exceeded " + 5 + " iterations attempting to determine upper bound");
        }
        if (type instanceof DeclaredType) {
            return (DeclaredType)type;
        }
        if (type instanceof TypeVariable) {
            try {
                TypeMirror upper = ((TypeVariable)type).getUpperBound();
                return MirrorUtils.getUpperBound0(upper, --depth);
            }
            catch (IllegalStateException ex) {
                throw ex;
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to compute upper bound of type symbol " + type);
            }
        }
        return null;
    }

    public static String getInternalName(DeclaredType type) {
        if (type == null) {
            return OBJECT_REF;
        }
        return MirrorUtils.getInternalName((TypeElement)type.asElement());
    }

    public static String getInternalName(TypeElement elem) {
        StringBuilder reference = new StringBuilder();
        reference.append(elem.getSimpleName());
        for (Element parent = elem.getEnclosingElement(); parent != null; parent = parent.getEnclosingElement()) {
            if (parent instanceof TypeElement) {
                reference.insert(0, "$").insert(0, parent.getSimpleName());
                continue;
            }
            if (!(parent instanceof PackageElement)) continue;
            reference.insert(0, "/").insert(0, ((PackageElement)parent).getQualifiedName().toString().replace('.', '/'));
        }
        return reference.toString();
    }

    public static boolean isAssignable(ProcessingEnvironment processingEnv, TypeMirror targetType, TypeMirror superClass) {
        boolean assignable = processingEnv.getTypeUtils().isAssignable(targetType, superClass);
        if (!assignable && targetType instanceof DeclaredType && superClass instanceof DeclaredType) {
            TypeMirror rawTargetType = MirrorUtils.toRawType(processingEnv, (DeclaredType)targetType);
            TypeMirror rawSuperType = MirrorUtils.toRawType(processingEnv, (DeclaredType)superClass);
            return processingEnv.getTypeUtils().isAssignable(rawTargetType, rawSuperType);
        }
        return assignable;
    }

    private static TypeMirror toRawType(ProcessingEnvironment processingEnv, DeclaredType targetType) {
        return processingEnv.getElementUtils().getTypeElement(((TypeElement)targetType.asElement()).getQualifiedName()).asType();
    }
}

