/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorInterface;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorStandard;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.util.ASMHelper;

class TargetClassContext {
    private final String sessionId;
    private final String className;
    private final ClassNode classNode;
    private final ClassInfo classInfo;
    private final SortedSet<MixinInfo> mixins;
    private final Map<String, Counter> injectorMethodIndices = new HashMap<String, Counter>();
    private final Map<String, Target> targetMethods = new HashMap<String, Target>();
    private final boolean disableHandlerRemap;
    private boolean applied;
    private boolean forceExport;

    TargetClassContext(String sessionId, String name, ClassNode classNode, SortedSet<MixinInfo> mixins) {
        this.sessionId = sessionId;
        this.className = name;
        this.classNode = classNode;
        this.classInfo = ClassInfo.fromClassNode(classNode);
        this.mixins = mixins;
        this.disableHandlerRemap = MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_DISABLE_HANDLER_REMAP);
    }

    public boolean isApplied() {
        return this.applied;
    }

    public boolean isExportForced() {
        return this.forceExport;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.classNode.name;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public SortedSet<MixinInfo> getMixins() {
        return this.mixins;
    }

    public Target getTargetMethod(MethodNode method) {
        if (!this.classNode.methods.contains(method)) {
            throw new IllegalArgumentException("Invalid target method supplied to getTargetMethod()");
        }
        String targetName = method.name + method.desc;
        Target target = this.targetMethods.get(targetName);
        if (target == null) {
            target = new Target(this.classNode, method);
            this.targetMethods.put(targetName, target);
        }
        return target;
    }

    public String getHandlerName(AnnotationNode annotation, MethodNode method, boolean surrogate) {
        if (this.disableHandlerRemap) {
            return method.name;
        }
        String descriptor = String.format("%s%s", method.name, method.desc);
        Counter id = this.injectorMethodIndices.get(descriptor);
        if (id == null) {
            id = new Counter();
            this.injectorMethodIndices.put(descriptor, id);
        } else if (!surrogate) {
            ++id.value;
        }
        return String.format("%s$%s$%d", InjectionInfo.getInjectorPrefix(annotation), method.name, id.value);
    }

    public void applyMixins() {
        if (this.applied) {
            throw new IllegalStateException("Mixins already applied to target class " + this.className);
        }
        this.applied = true;
        MixinApplicatorStandard applicator = this.createApplicator();
        applicator.apply(this.mixins);
    }

    private MixinApplicatorStandard createApplicator() {
        if (this.classInfo.isInterface()) {
            return new MixinApplicatorInterface(this);
        }
        return new MixinApplicatorStandard(this);
    }

    public void processDebugTasks() {
        if (!MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            return;
        }
        AnnotationNode classDebugAnnotation = ASMHelper.getVisibleAnnotation(this.classNode, Debug.class);
        if (classDebugAnnotation != null) {
            this.forceExport = Boolean.TRUE.equals(ASMHelper.getAnnotationValue(classDebugAnnotation, "export"));
            if (Boolean.TRUE.equals(ASMHelper.getAnnotationValue(classDebugAnnotation, "print"))) {
                ASMHelper.textify(this.classNode, (OutputStream)System.err);
            }
        }
        for (MethodNode method : this.classNode.methods) {
            AnnotationNode methodDebugAnnotation = ASMHelper.getVisibleAnnotation(method, Debug.class);
            if (methodDebugAnnotation == null || !Boolean.TRUE.equals(ASMHelper.getAnnotationValue(methodDebugAnnotation, "print"))) continue;
            ASMHelper.textify(method, (OutputStream)System.err);
        }
    }

    static class Counter {
        public int value;

        Counter() {
        }
    }
}

