/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util.debug;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public final class DebugMessage {
    private static final Map<Position, List<DebugMessage>> messages = new EnumMap<Position, List<DebugMessage>>(Position.class);
    private final Position position;
    private String message;
    private boolean visible = true;

    private DebugMessage(Position position, String message) {
        this.position = position;
        this.message = message;
    }

    public DebugMessage setMessage(String message) {
        this.message = message;
        return this;
    }

    public DebugMessage setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return this.message != null ? this.message : "";
    }

    public void remove() {
        List<DebugMessage> messages = DebugMessage.messages.get((Object)this.position);
        if (messages != null) {
            messages.remove(this);
            if (messages.size() == 0) {
                DebugMessage.messages.put(this.position, null);
            }
        }
    }

    public static DebugMessage create(Position position, String message) {
        if (position == null) {
            throw new NullPointerException("Null position specified");
        }
        DebugMessage debugMessage = new DebugMessage(position, message);
        if (messages.get((Object)position) == null) {
            messages.put(position, new ArrayList());
        }
        messages.get((Object)position).add(debugMessage);
        return debugMessage;
    }

    public static List<String> getMessages(Position position) {
        List<DebugMessage> debugMessages = messages.get((Object)position);
        if (debugMessages == null) {
            return null;
        }
        ImmutableList.Builder messages = ImmutableList.builder();
        for (DebugMessage debugMessage : debugMessages) {
            if (!debugMessage.isVisible()) continue;
            messages.add((Object)debugMessage.toString());
        }
        return messages.build();
    }

    public static enum Position {
        LEFT_TOP,
        LEFT_AFTER_INFO,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

