/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.access;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.ByteCodeUtilities;
import com.mumfrey.liteloader.transformers.ClassTransformer;
import com.mumfrey.liteloader.transformers.ObfProvider;
import com.mumfrey.liteloader.transformers.access.Accessor;
import com.mumfrey.liteloader.transformers.access.Invoker;
import com.mumfrey.liteloader.transformers.access.ObfTableClass;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class AccessorTransformer
extends ClassTransformer {
    static final String EXCEPTION = "com/mumfrey/liteloader/transformers/access/AccessorException";
    static final Pattern ordinalRefPattern = Pattern.compile("^#([0-9]{1,5})$");
    private final List<AccessorInjection> accessors = new ArrayList<AccessorInjection>();

    public AccessorTransformer() {
        this.addAccessors();
    }

    public void addAccessor(String interfaceName) {
        this.addAccessor(interfaceName, null);
    }

    public void addAccessor(String interfaceName, ObfProvider obfProvider) {
        try {
            this.accessors.add(new AccessorInjection(interfaceName, obfProvider));
        }
        catch (Exception ex) {
            LiteLoaderLogger.debug(ex);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode classNode = null;
        if ((classNode = this.apply(name, transformedName, basicClass, classNode)) != null) {
            this.postTransform(name, transformedName, classNode);
            return this.writeClass(classNode);
        }
        return basicClass;
    }

    public ClassNode apply(String name, String transformedName, byte[] basicClass, ClassNode classNode) {
        Iterator<AccessorInjection> iter = this.accessors.iterator();
        while (iter.hasNext()) {
            AccessorInjection accessor = iter.next();
            Obf target = accessor.getTarget();
            if (!target.obf.equals(transformedName) && !target.name.equals(transformedName)) continue;
            LiteLoaderLogger.debug("[AccessorTransformer] Processing access injections in %s", transformedName);
            if (classNode == null) {
                classNode = this.readClass(basicClass, true);
            }
            accessor.apply(classNode);
            iter.remove();
        }
        return classNode;
    }

    protected void addAccessors() {
    }

    protected void postTransform(String name, String transformedName, ClassNode classNode) {
    }

    protected static class Mapping
    extends Obf {
        protected Mapping(String seargeName, String obfName, String mcpName) {
            super(seargeName, obfName, mcpName);
        }
    }

    class AccessorInjection {
        private final String iface;
        private final Class<? extends Obf> table;
        private final ObfProvider obfProvider;
        private final Obf target;

        protected AccessorInjection(String iface) throws IOException {
            this(iface, null);
        }

        protected AccessorInjection(String iface, ObfProvider obfProvider) throws IOException {
            ClassNode ifaceNode = ByteCodeUtilities.loadClass(iface, false);
            if (ifaceNode.interfaces.size() > 0) {
                String interfaceList = ifaceNode.interfaces.toString().replace('/', '.');
                throw new RuntimeException("Accessor interface must not extend other interfaces. Found " + interfaceList + " in " + iface);
            }
            this.iface = iface;
            this.obfProvider = obfProvider;
            this.table = this.setupTable(ifaceNode);
            this.target = this.setupTarget(ifaceNode);
        }

        private Obf getObf(List<String> names) {
            Obf obf;
            String name = names.get(0);
            Matcher ordinalPattern = ordinalRefPattern.matcher(name);
            if (ordinalPattern.matches()) {
                int ordinal = Integer.parseInt(ordinalPattern.group(1));
                return new Obf.Ord(ordinal);
            }
            if (this.obfProvider != null && (obf = this.obfProvider.getByName(name)) != null) {
                return obf;
            }
            obf = Obf.getByName(this.table, name);
            if (obf != null) {
                return obf;
            }
            if (names.size() > 0 && names.size() < 4) {
                String name2 = names.size() > 1 ? names.get(1) : name;
                String name3 = names.size() > 2 ? names.get(2) : name;
                return new Mapping(name, name2, name3);
            }
            throw new RuntimeException("Invalid obfuscation table entry specified: '" + names + "'");
        }

        protected Obf getTarget() {
            return this.target;
        }

        private Class<? extends Obf> setupTable(ClassNode ifaceNode) {
            AnnotationNode annotation = ByteCodeUtilities.getInvisibleAnnotation(ifaceNode, ObfTableClass.class);
            if (annotation != null) {
                try {
                    Type obfTableType = (Type)ByteCodeUtilities.getAnnotationValue(annotation);
                    return Class.forName(obfTableType.getClassName(), true, (ClassLoader)Launch.classLoader);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            return Obf.class;
        }

        private Obf setupTarget(ClassNode ifaceNode) {
            AnnotationNode annotation = ByteCodeUtilities.getInvisibleAnnotation(ifaceNode, Accessor.class);
            if (annotation == null) {
                throw new RuntimeException("Accessor interfaces must be annotated with an @Accessor annotation specifying the target class");
            }
            List targetClass = (List)ByteCodeUtilities.getAnnotationValue(annotation);
            if (targetClass == null || targetClass.isEmpty()) {
                throw new RuntimeException("Invalid @Accessor annotation, the annotation must specify a target class");
            }
            return this.getObf(targetClass);
        }

        protected void apply(ClassNode classNode) {
            String ifaceRef = this.iface.replace('.', '/');
            if (classNode.interfaces.contains(ifaceRef)) {
                LiteLoaderLogger.debug("[AccessorTransformer] Skipping %s because %s was already applied", classNode.name, this.iface);
                return;
            }
            classNode.interfaces.add(ifaceRef);
            try {
                LiteLoaderLogger.debug("[AccessorTransformer] Loading %s", this.iface);
                ClassNode ifaceNode = ByteCodeUtilities.loadClass(this.iface, AccessorTransformer.this);
                for (MethodNode method : ifaceNode.methods) {
                    this.addMethod(classNode, method);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void addMethod(ClassNode classNode, MethodNode method) {
            if (!this.addMethodToClass(classNode, method)) {
                LiteLoaderLogger.debug("[AccessorTransformer] Method %s already exists in %s", method.name, classNode.name);
                return;
            }
            LiteLoaderLogger.debug("[AccessorTransformer] Attempting to add %s to %s", method.name, classNode.name);
            List targetId = null;
            AnnotationNode accessor = ByteCodeUtilities.getInvisibleAnnotation(method, Accessor.class);
            AnnotationNode invoker = ByteCodeUtilities.getInvisibleAnnotation(method, Invoker.class);
            if (accessor != null) {
                targetId = (List)ByteCodeUtilities.getAnnotationValue(accessor);
                Obf target = this.getObf(targetId);
                if (this.injectAccessor(classNode, method, target)) {
                    return;
                }
            } else if (invoker != null) {
                targetId = (List)ByteCodeUtilities.getAnnotationValue(invoker);
                Obf target = this.getObf(targetId);
                if (this.injectInvoker(classNode, method, target)) {
                    return;
                }
            } else {
                LiteLoaderLogger.severe("[AccessorTransformer] Method %s for %s has no @Accessor or @Invoker annotation, the method will be ABSTRACT!", method.name, this.iface);
                this.injectException(classNode, method, AccessorTransformer.EXCEPTION, "No @Accessor or @Invoker annotation on method");
                return;
            }
            LiteLoaderLogger.severe("[AccessorTransformer] Method %s for %s could not locate target member, the method will be ABSTRACT!", method.name, this.iface);
            this.injectException(classNode, method, AccessorTransformer.EXCEPTION, "Accessor could not locate target class member '" + targetId + "'");
        }

        private boolean injectAccessor(ClassNode classNode, MethodNode method, Obf target) {
            FieldNode targetField = ByteCodeUtilities.findField(classNode, target);
            if (targetField != null) {
                LiteLoaderLogger.debug("[AccessorTransformer] Found field %s for %s", targetField.name, method.name);
                if (Type.getReturnType((String)method.desc) != Type.VOID_TYPE) {
                    this.populateGetter(classNode, method, targetField);
                } else {
                    this.populateSetter(classNode, method, targetField);
                }
                return true;
            }
            return false;
        }

        private boolean injectInvoker(ClassNode classNode, MethodNode method, Obf target) {
            MethodNode targetMethod = ByteCodeUtilities.findMethod(classNode, target, method.desc);
            if (targetMethod != null) {
                LiteLoaderLogger.debug("[AccessorTransformer] Found method %s for %s", targetMethod.name, method.name);
                this.populateInvoker(classNode, method, targetMethod);
                return true;
            }
            return false;
        }

        private void populateGetter(ClassNode classNode, MethodNode method, FieldNode field) {
            Type fieldType;
            Type returnType = Type.getReturnType((String)method.desc);
            if (!returnType.equals((Object)(fieldType = Type.getType((String)field.desc)))) {
                throw new RuntimeException("Incompatible types! Field type: " + fieldType + " Method type: " + returnType);
            }
            boolean isStatic = (field.access & 8) != 0;
            method.instructions.clear();
            method.maxLocals = ByteCodeUtilities.getFirstNonArgLocalIndex(method);
            method.maxStack = fieldType.getSize();
            if (isStatic) {
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, field.name, field.desc));
            } else {
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, field.name, field.desc));
            }
            method.instructions.add((AbstractInsnNode)new InsnNode(returnType.getOpcode(172)));
        }

        private void populateSetter(ClassNode classNode, MethodNode method, FieldNode field) {
            Type[] argTypes = Type.getArgumentTypes((String)method.desc);
            if (argTypes.length != 1) {
                throw new RuntimeException("Invalid setter! " + method.name + " must take exactly one argument");
            }
            Type argType = argTypes[0];
            Type fieldType = Type.getType((String)field.desc);
            if (!argType.equals((Object)fieldType)) {
                throw new RuntimeException("Incompatible types! Field type: " + fieldType + " Method type: " + argType);
            }
            boolean isStatic = (field.access & 8) != 0;
            method.instructions.clear();
            method.maxLocals = ByteCodeUtilities.getFirstNonArgLocalIndex(method);
            method.maxStack = fieldType.getSize();
            if (isStatic) {
                method.instructions.add((AbstractInsnNode)new VarInsnNode(argType.getOpcode(21), 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(179, classNode.name, field.name, field.desc));
            } else {
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(argType.getOpcode(21), 1));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, field.name, field.desc));
            }
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
        }

        private void populateInvoker(ClassNode classNode, MethodNode method, MethodNode targetMethod) {
            Type[] args = Type.getArgumentTypes((String)targetMethod.desc);
            Type returnType = Type.getReturnType((String)targetMethod.desc);
            boolean isStatic = (targetMethod.access & 8) != 0;
            method.instructions.clear();
            method.maxLocals = ByteCodeUtilities.getFirstNonArgLocalIndex(method);
            method.maxStack = method.maxLocals + 1;
            if (isStatic) {
                ByteCodeUtilities.loadArgs(args, method.instructions, 0);
                method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, classNode.name, targetMethod.name, targetMethod.desc, false));
            } else {
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                ByteCodeUtilities.loadArgs(args, method.instructions, 1);
                method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.name, targetMethod.name, targetMethod.desc, false));
            }
            method.instructions.add((AbstractInsnNode)new InsnNode(returnType.getOpcode(172)));
        }

        private void injectException(ClassNode classNode, MethodNode method, String exceptionType, String message) {
            InsnList insns = method.instructions;
            method.maxStack = 2;
            insns.clear();
            insns.add((AbstractInsnNode)new TypeInsnNode(187, exceptionType));
            insns.add((AbstractInsnNode)new InsnNode(89));
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)message));
            insns.add((AbstractInsnNode)new MethodInsnNode(183, exceptionType, "<init>", "(Ljava/lang/String;)V", false));
            insns.add((AbstractInsnNode)new InsnNode(191));
        }

        private boolean addMethodToClass(ClassNode classNode, MethodNode method) {
            MethodNode existingMethod = ByteCodeUtilities.findTargetMethod(classNode, method);
            if (existingMethod != null) {
                return false;
            }
            classNode.methods.add(method);
            method.access &= 0xFFFFFBFF;
            return true;
        }
    }
}

