/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers;

import com.mumfrey.liteloader.transformers.AppendInsns;
import com.mumfrey.liteloader.transformers.ByteCodeUtilities;
import com.mumfrey.liteloader.transformers.ClassTransformer;
import com.mumfrey.liteloader.transformers.InvalidOverlayException;
import com.mumfrey.liteloader.transformers.Obfuscated;
import com.mumfrey.liteloader.transformers.Stub;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Deprecated
public abstract class ClassOverlayTransformer
extends ClassTransformer {
    private static final Map<String, String> overlayMap = new HashMap<String, String>();
    private static SimpleRemapper referenceRemapper;
    private boolean remappingAgent = false;
    private final String overlayClassName;
    private final String overlayClassRef;
    private final String targetClassName;
    private final Map<String, String> renamedFields = new HashMap<String, String>();
    private final Map<String, String> renamedMethods = new HashMap<String, String>();
    protected boolean setSourceFile = true;

    protected ClassOverlayTransformer(String overlayClassName) {
        this.overlayClassName = overlayClassName;
        this.overlayClassRef = overlayClassName.replace('.', '/');
        String targetClassName = null;
        ClassNode overlayClass = this.loadOverlayClass("<none>", true);
        for (FieldNode field : overlayClass.fields) {
            if (!"__TARGET".equals(field.name) || (field.access & 8) != 8) continue;
            targetClassName = Type.getType((String)field.desc).getClassName();
        }
        if (targetClassName == null) {
            throw new RuntimeException(String.format("Overlay class %s is missing a __TARGET field, unable to identify target class", this.overlayClassName));
        }
        this.targetClassName = targetClassName;
        overlayMap.put(this.overlayClassRef, this.targetClassName.replace('.', '/'));
        if (referenceRemapper == null) {
            referenceRemapper = new SimpleRemapper(overlayMap);
            this.remappingAgent = true;
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (this.targetClassName != null && this.targetClassName.equals(transformedName)) {
            try {
                return this.applyOverlay(transformedName, basicClass);
            }
            catch (InvalidOverlayException th) {
                LiteLoaderLogger.severe(th, "Class overlay failed: %s %s", th.getClass().getName(), th.getMessage());
                th.printStackTrace();
            }
        } else {
            if (this.overlayClassName.equals(transformedName)) {
                throw new RuntimeException(String.format("%s is an overlay class and cannot be referenced directly", this.overlayClassName));
            }
            if (this.remappingAgent && basicClass != null) {
                return this.remapClass(transformedName, basicClass);
            }
        }
        return basicClass;
    }

    private byte[] remapClass(String transformedName, byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassWriter classWriter = new ClassWriter(classReader, 0);
        RemappingClassAdapter remappingAdapter = new RemappingClassAdapter((ClassVisitor)classWriter, (Remapper)referenceRemapper);
        classReader.accept((ClassVisitor)remappingAdapter, 8);
        return classWriter.toByteArray();
    }

    protected byte[] applyOverlay(String transformedName, byte[] classBytes) {
        ClassNode overlayClass = this.loadOverlayClass(transformedName, true);
        ClassNode targetClass = this.readClass(classBytes, true);
        LiteLoaderLogger.info("Applying overlay %s to %s", this.overlayClassName, transformedName);
        try {
            this.verifyClasses(targetClass, overlayClass);
            this.overlayInterfaces(targetClass, overlayClass);
            this.overlayAttributes(targetClass, overlayClass);
            this.overlayFields(targetClass, overlayClass);
            this.findRenamedMethods(targetClass, overlayClass);
            this.overlayMethods(targetClass, overlayClass);
        }
        catch (Exception ex) {
            throw new InvalidOverlayException("Unexpecteded error whilst applying the overlay class", ex);
        }
        this.postOverlayTransform(transformedName, targetClass, overlayClass);
        return this.writeClass(targetClass);
    }

    protected void postOverlayTransform(String transformedName, ClassNode targetClass, ClassNode overlayClass) {
    }

    protected void verifyClasses(ClassNode targetClass, ClassNode overlayClass) {
        if (targetClass.superName == null || overlayClass.superName == null || !targetClass.superName.equals(overlayClass.superName)) {
            throw new InvalidOverlayException("Overlay classes must have the same superclass as their target class");
        }
    }

    private void overlayInterfaces(ClassNode targetClass, ClassNode overlayClass) {
        for (String interfaceName : overlayClass.interfaces) {
            if (targetClass.interfaces.contains(interfaceName)) continue;
            targetClass.interfaces.add(interfaceName);
        }
    }

    private void overlayAttributes(ClassNode targetClass, ClassNode overlayClass) {
        if (this.setSourceFile) {
            targetClass.sourceFile = overlayClass.sourceFile;
        }
    }

    private void overlayFields(ClassNode targetClass, ClassNode overlayClass) {
        for (FieldNode field : overlayClass.fields) {
            if ((field.access & 8) == 8 && (field.access & 2) != 2) {
                throw new InvalidOverlayException(String.format("Overlay classes cannot contain non-private static methods or fields, found %s", field.name));
            }
            FieldNode target = ByteCodeUtilities.findTargetField(targetClass, field);
            if (target == null) {
                targetClass.fields.add(field);
                continue;
            }
            if (!target.desc.equals(field.desc)) {
                throw new InvalidOverlayException(String.format("The field %s in the target class has a conflicting signature", field.name));
            }
            if (target.name.equals(field.name)) continue;
            this.renamedFields.put(field.name, target.name);
        }
    }

    private void findRenamedMethods(ClassNode targetClass, ClassNode overlayClass) {
        for (MethodNode overlayMethod : overlayClass.methods) {
            if (ByteCodeUtilities.getVisibleAnnotation(overlayMethod, Stub.class) == null && (ByteCodeUtilities.getVisibleAnnotation(overlayMethod, AppendInsns.class) != null || overlayMethod.name.startsWith("<"))) continue;
            this.checkRenameMethod(targetClass, overlayMethod);
        }
    }

    private void overlayMethods(ClassNode targetClass, ClassNode overlayClass) {
        for (MethodNode overlayMethod : overlayClass.methods) {
            MethodNode target;
            this.transformMethod(overlayMethod, overlayClass.name, targetClass.name);
            AnnotationNode appendAnnotation = ByteCodeUtilities.getVisibleAnnotation(overlayMethod, AppendInsns.class);
            AnnotationNode stubAnnotation = ByteCodeUtilities.getVisibleAnnotation(overlayMethod, Stub.class);
            if (stubAnnotation != null) {
                target = ByteCodeUtilities.findTargetMethod(targetClass, overlayMethod);
                if (target != null) continue;
                throw new InvalidOverlayException(String.format("Stub method %s was not located in the target class", overlayMethod.name));
            }
            if (appendAnnotation != null) {
                String targetMethodName = (String)ByteCodeUtilities.getAnnotationValue(appendAnnotation);
                this.appendInsns(targetClass, targetMethodName, overlayMethod);
                continue;
            }
            if (!overlayMethod.name.startsWith("<")) {
                if ((overlayMethod.access & 8) == 8 && (overlayMethod.access & 2) != 2) continue;
                target = ByteCodeUtilities.findTargetMethod(targetClass, overlayMethod);
                if (target != null) {
                    targetClass.methods.remove(target);
                }
                targetClass.methods.add(overlayMethod);
                continue;
            }
            if (!"<clinit>".equals(overlayMethod.name)) continue;
            this.appendInsns(targetClass, overlayMethod.name, overlayMethod);
        }
    }

    private void transformMethod(MethodNode method, String fromClass, String toClass) {
        for (AbstractInsnNode insn : method.instructions) {
            String newName;
            if (insn instanceof MethodInsnNode) {
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (methodInsn.owner.equals(fromClass)) {
                    methodInsn.owner = toClass;
                    String methodDescriptor = methodInsn.name + methodInsn.desc;
                    if (this.renamedMethods.containsKey(methodDescriptor)) {
                        methodInsn.name = this.renamedMethods.get(methodDescriptor);
                    }
                }
            }
            if (!(insn instanceof FieldInsnNode)) continue;
            FieldInsnNode fieldInsn = (FieldInsnNode)insn;
            if (fieldInsn.owner.equals(fromClass)) {
                fieldInsn.owner = toClass;
            }
            if (!this.renamedFields.containsKey(fieldInsn.name)) continue;
            fieldInsn.name = newName = this.renamedFields.get(fieldInsn.name);
        }
    }

    private void appendInsns(ClassNode targetClass, String targetMethodName, MethodNode sourceMethod) {
        if (Type.getReturnType((String)sourceMethod.desc) != Type.VOID_TYPE) {
            throw new IllegalArgumentException("Attempted to merge insns into a method which does not return void");
        }
        if (targetMethodName == null || targetMethodName.length() == 0) {
            targetMethodName = sourceMethod.name;
        }
        HashSet obfuscatedNames = new HashSet();
        AnnotationNode obfuscatedAnnotation = ByteCodeUtilities.getVisibleAnnotation(sourceMethod, Obfuscated.class);
        if (obfuscatedAnnotation != null) {
            obfuscatedNames.addAll((Collection)ByteCodeUtilities.getAnnotationValue(obfuscatedAnnotation));
        }
        for (MethodNode method : targetClass.methods) {
            if (!targetMethodName.equals(method.name) && !obfuscatedNames.contains(method.name) || !sourceMethod.desc.equals(method.desc)) continue;
            AbstractInsnNode returnNode = null;
            for (AbstractInsnNode insn : method.instructions) {
                if (insn.getOpcode() != 177) continue;
                returnNode = insn;
                break;
            }
            for (AbstractInsnNode insn : sourceMethod.instructions) {
                if (insn instanceof LineNumberNode || insn.getOpcode() == 177) continue;
                method.instructions.insertBefore(returnNode, insn);
            }
        }
    }

    private void checkRenameMethod(ClassNode targetClass, MethodNode searchFor) {
        MethodNode target = ByteCodeUtilities.findTargetMethod(targetClass, searchFor);
        if (target != null && !target.name.equals(searchFor.name)) {
            String methodDescriptor = searchFor.name + searchFor.desc;
            this.renamedMethods.put(methodDescriptor, target.name);
            searchFor.name = target.name;
        }
    }

    private ClassNode loadOverlayClass(String transformedName, boolean runTransformers) {
        byte[] overlayBytes = null;
        try {
            overlayBytes = Launch.classLoader.getClassBytes(this.overlayClassName);
            if (overlayBytes == null) {
                throw new InvalidOverlayException(String.format("The specified overlay '%s' was not found", this.overlayClassName));
            }
            if (runTransformers) {
                overlayBytes = ByteCodeUtilities.applyTransformers(this.overlayClassName, overlayBytes, this);
            }
        }
        catch (IOException ex) {
            LiteLoaderLogger.severe("Failed to load overlay %s for %s, no overlay was applied", this.overlayClassName, transformedName);
            throw new InvalidOverlayException("An error was encountered whilst loading the overlay class", ex);
        }
        return this.readClass(overlayBytes, false);
    }
}

