/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.modconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.mumfrey.liteloader.modconfig.AdvancedExposable;
import com.mumfrey.liteloader.modconfig.ConfigStrategy;
import com.mumfrey.liteloader.modconfig.Exposable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public final class ExposableConfigWriter
implements InstanceCreator<Exposable> {
    private static final long ANTI_HAMMER_DELAY = 1000L;
    private final Exposable exposable;
    private final File configFile;
    private final boolean versioned;
    private final boolean aggressive;
    private final Gson gson;
    private volatile boolean dirty = false;
    private volatile long lastWrite = 0L;
    private Object readWriteLock = new Object();

    private ExposableConfigWriter(Exposable exposable, File configFile, boolean versioned, boolean aggressive) {
        this.exposable = exposable;
        this.configFile = configFile;
        this.versioned = versioned;
        this.aggressive = aggressive;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.serializeNulls();
        gsonBuilder.excludeFieldsWithoutExposeAnnotation();
        gsonBuilder.registerTypeAdapter(exposable.getClass(), (Object)this);
        if (this.exposable instanceof AdvancedExposable) {
            ((AdvancedExposable)this.exposable).setupGsonSerialiser(gsonBuilder);
        }
        this.gson = gsonBuilder.create();
    }

    File getConfigFile() {
        return this.configFile;
    }

    boolean isVersioned() {
        return this.versioned;
    }

    public boolean isAggressive() {
        return this.aggressive;
    }

    boolean isDirty() {
        return this.dirty;
    }

    public Exposable createInstance(Type type) {
        return this.exposable;
    }

    void init() {
        this.read();
        if (!this.configFile.exists()) {
            this.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read() {
        Object object = this.readWriteLock;
        synchronized (object) {
            if (this.configFile.exists()) {
                FileReader reader = null;
                try {
                    reader = new FileReader(this.configFile);
                    this.gson.fromJson((Reader)reader, this.exposable.getClass());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() {
        Object object = this.readWriteLock;
        synchronized (object) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(this.configFile);
                this.gson.toJson((Object)this.exposable, (Appendable)writer);
                this.dirty = false;
                this.lastWrite = System.currentTimeMillis();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    void invalidate() {
        long sinceLastWrite;
        if (!this.aggressive && (sinceLastWrite = System.currentTimeMillis() - this.lastWrite) < 1000L) {
            this.dirty = true;
            return;
        }
        this.write();
    }

    void onTick() {
        long sinceLastWrite;
        if (!this.aggressive && this.dirty && (sinceLastWrite = System.currentTimeMillis() - this.lastWrite) >= 1000L) {
            this.write();
        }
    }

    void sync() {
        if (this.dirty || this.aggressive) {
            this.write();
        }
    }

    static ExposableConfigWriter create(Exposable exposable, ConfigStrategy strategy, String fileName, boolean aggressive) {
        File customConfigFile;
        if (!fileName.toLowerCase().endsWith(".json")) {
            fileName = fileName + ".json";
        }
        File configFile = strategy.getFileForStrategy(fileName);
        if (exposable instanceof AdvancedExposable && (customConfigFile = ((AdvancedExposable)exposable).getConfigFile(configFile, configFile.getParentFile(), fileName)) != null) {
            configFile = customConfigFile;
        }
        ExposableConfigWriter writer = new ExposableConfigWriter(exposable, configFile, strategy == ConfigStrategy.Versioned, aggressive);
        return writer;
    }
}

