/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.messaging;

import com.google.common.collect.ImmutableMap;
import com.mumfrey.liteloader.messaging.Messenger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Message {
    private static final Pattern channelPattern = Pattern.compile("^[a-z0-9]([a-z0-9_\\-]*[a-z0-9])?:[a-z0-9]([a-z0-9_\\-]*[a-z0-9])?$", 2);
    private final String channel;
    private final String replyChannel;
    private final Messenger sender;
    private final Map<String, ?> payload;

    Message(String channel, Object value, Messenger sender) {
        this(channel, value, sender, null);
    }

    Message(String channel, Object value, Messenger sender, String replyChannel) {
        Message.validateChannel(channel);
        this.channel = channel;
        this.payload = ImmutableMap.of((Object)"value", (Object)value);
        this.sender = sender;
        this.replyChannel = replyChannel;
    }

    Message(String channel, Map<String, ?> payload, Messenger sender) {
        this(channel, payload, sender, null);
    }

    Message(String channel, Map<String, ?> payload, Messenger sender, String replyChannel) {
        Message.validateChannel(channel);
        this.channel = channel;
        this.payload = payload != null ? ImmutableMap.copyOf(payload) : ImmutableMap.of();
        this.sender = sender;
        this.replyChannel = replyChannel;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getCategory() {
        return this.channel.substring(0, this.channel.indexOf(58));
    }

    public String getReplyChannel() {
        return this.replyChannel;
    }

    public Messenger getSender() {
        return this.sender;
    }

    public Map<String, ?> getPayload() {
        return this.payload;
    }

    public boolean isChannel(String channel) {
        return this.channel.equals(channel);
    }

    public boolean isCategory(String category) {
        return this.getCategory().equals(category);
    }

    public <T> T get(String key) {
        return (T)this.payload.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.payload.get(key);
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    public <T> T getValue() {
        return this.get("value");
    }

    public static void validateChannel(String channel) throws IllegalArgumentException {
        if (channel == null) {
            throw new IllegalArgumentException("Channel name cannot be null");
        }
        if (!Message.isValidChannel(channel)) {
            throw new IllegalArgumentException("'" + channel + "' is not a valid channel name");
        }
    }

    public static boolean isValidChannel(String channel) {
        return channelPattern.matcher(channel).matches();
    }

    public static Map<String, ?> buildMap(Object ... args) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        for (int i = 0; i < args.length - 1; i += 2) {
            if (!(args[i] instanceof String)) continue;
            payload.put((String)args[i], args[i + 1]);
        }
        return payload;
    }
}

