/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.interfaces;

import com.google.common.collect.ImmutableSet;
import com.mumfrey.liteloader.interfaces.Injectable;
import com.mumfrey.liteloader.interfaces.Loadable;
import com.mumfrey.liteloader.launch.InjectionStrategy;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;

public interface LoadableMod<L>
extends Loadable<L>,
Injectable {
    public static final String METADATA_FILENAME = "litemod.json";
    public static final LoadableMod<File> NONE = new EmptyModContainer();

    public Set<String> getModSystems();

    public String getModName();

    public String getTargetVersion();

    public float getRevision();

    public boolean hasValidMetaData();

    public boolean hasDependencies();

    public Set<String> getDependencies();

    public void registerMissingDependency(String var1);

    public Set<String> getMissingDependencies();

    public Set<String> getRequiredAPIs();

    public void registerMissingAPI(String var1);

    public Set<String> getMissingAPIs();

    public String getMetaValue(String var1, String var2);

    public Set<String> getMetaDataKeys();

    public boolean hasResources();

    public List<String> getContainedClassNames();

    public void addContainedMod(String var1);

    public static class EmptyModContainer
    implements LoadableMod<File> {
        private static final ImmutableSet<String> EMPTY_SET = ImmutableSet.of();

        EmptyModContainer() {
        }

        @Override
        public File getTarget() {
            return null;
        }

        @Override
        public Set<String> getModSystems() {
            return EMPTY_SET;
        }

        @Override
        public String getName() {
            return "Unknown";
        }

        @Override
        public String getDisplayName() {
            return "Unknown";
        }

        @Override
        public String getLocation() {
            return ".";
        }

        @Override
        public String getIdentifier() {
            return "Unknown";
        }

        @Override
        public String getVersion() {
            return "Unknown";
        }

        @Override
        public String getAuthor() {
            return "Unknown";
        }

        @Override
        public String getDescription(String key) {
            return "";
        }

        @Override
        public boolean isExternalJar() {
            return false;
        }

        @Override
        public boolean isToggleable() {
            return false;
        }

        @Override
        public boolean isEnabled(LoaderEnvironment environment) {
            return true;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public File toFile() {
            return null;
        }

        @Override
        public int compareTo(File other) {
            return 0;
        }

        @Override
        public URL getURL() throws MalformedURLException {
            throw new MalformedURLException("Attempted to get the URL of an empty mod");
        }

        @Override
        public boolean isInjected() {
            return false;
        }

        @Override
        public boolean injectIntoClassPath(LaunchClassLoader classLoader, boolean injectIntoParent) throws MalformedURLException {
            return false;
        }

        @Override
        public InjectionStrategy getInjectionStrategy() {
            return null;
        }

        @Override
        public String getModName() {
            return "Unknown";
        }

        @Override
        public String getTargetVersion() {
            return "";
        }

        @Override
        public float getRevision() {
            return 0.0f;
        }

        @Override
        public boolean hasValidMetaData() {
            return false;
        }

        @Override
        public String getMetaValue(String metaKey, String defaultValue) {
            return defaultValue;
        }

        @Override
        public Set<String> getMetaDataKeys() {
            return Collections.emptySet();
        }

        @Override
        public boolean hasResources() {
            return false;
        }

        @Override
        public boolean hasDependencies() {
            return false;
        }

        @Override
        public Set<String> getDependencies() {
            return Collections.emptySet();
        }

        @Override
        public void registerMissingDependency(String dependency) {
        }

        @Override
        public Set<String> getMissingDependencies() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getRequiredAPIs() {
            return Collections.emptySet();
        }

        @Override
        public void registerMissingAPI(String identifier) {
        }

        @Override
        public Set<String> getMissingAPIs() {
            return Collections.emptySet();
        }

        @Override
        public List<String> getContainedClassNames() {
            return Collections.emptyList();
        }

        @Override
        public void addContainedMod(String modName) {
        }

        @Override
        public boolean requiresPreInitInjection() {
            return false;
        }
    }
}

