/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.mumfrey.liteloader.api.ContainerRegistry;
import com.mumfrey.liteloader.api.EnumeratorPlugin;
import com.mumfrey.liteloader.api.ModClassValidator;
import com.mumfrey.liteloader.api.manager.APIProvider;
import com.mumfrey.liteloader.core.exceptions.OutdatedLoaderException;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultEnumeratorPlugin
implements EnumeratorPlugin {
    private LoaderEnvironment environment;

    @Override
    public void init(LoaderEnvironment environment, LoaderProperties properties) {
        this.environment = environment;
    }

    @Override
    public boolean checkEnabled(ContainerRegistry containers, LoadableMod<?> container) {
        return container.isEnabled(this.environment);
    }

    @Override
    public boolean checkAPIRequirements(ContainerRegistry containers, LoadableMod<?> container) {
        boolean result = true;
        APIProvider apiProvider = this.environment.getAPIProvider();
        for (String identifier : container.getRequiredAPIs()) {
            if (apiProvider.isAPIAvailable(identifier)) continue;
            container.registerMissingAPI(identifier);
            result = false;
        }
        return result;
    }

    @Override
    public boolean checkDependencies(ContainerRegistry containers, LoadableMod<?> base) {
        if (base == null || !base.hasDependencies()) {
            return true;
        }
        HashSet<String> circularDependencySet = new HashSet<String>();
        circularDependencySet.add(base.getIdentifier());
        boolean result = this.checkDependencies(containers, base, base, circularDependencySet);
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Dependency check for %s %s", base.getIdentifier(), result ? "passed" : "failed");
        return result;
    }

    private boolean checkDependencies(ContainerRegistry containers, LoadableMod<?> base, LoadableMod<?> container, Set<String> circularDependencySet) {
        if (container.getDependencies().size() == 0) {
            return true;
        }
        boolean result = true;
        for (String dependency : container.getDependencies()) {
            if (circularDependencySet.contains(dependency)) continue;
            circularDependencySet.add(dependency);
            LoadableMod<?> dependencyContainer = containers.getEnabledContainer(dependency);
            if (dependencyContainer != LoadableMod.NONE) {
                String identifier = dependency;
                if (this.environment.getEnabledModsList().isEnabled(this.environment.getProfile(), identifier)) {
                    result &= this.checkDependencies(containers, base, dependencyContainer, circularDependencySet);
                    continue;
                }
                base.registerMissingDependency(dependency);
                result = false;
                continue;
            }
            base.registerMissingDependency(dependency);
            result = false;
        }
        return result;
    }

    @Override
    public <T> List<Class<? extends T>> getClasses(LoadableMod<?> container, ClassLoader classloader, ModClassValidator validator) {
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        if (container != null) {
            try {
                for (String fullClassName : container.getContainedClassNames()) {
                    Class<T> clazz;
                    boolean isDefaultPackage = fullClassName.lastIndexOf(46) == -1;
                    String className = isDefaultPackage ? fullClassName : fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
                    if (!validator.validateName(className) || (clazz = DefaultEnumeratorPlugin.checkClass(classloader, validator, fullClassName)) == null || classes.contains(clazz)) continue;
                    classes.add(clazz);
                }
            }
            catch (OutdatedLoaderException ex) {
                classes.clear();
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Error searching in '%s', missing API component '%s', your loader is probably out of date", container, ex.getMessage());
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Enumeration error", new Object[0]);
            }
        }
        return classes;
    }

    private static <T> Class<? extends T> checkClass(ClassLoader classLoader, ModClassValidator validator, String className) throws OutdatedLoaderException {
        if (className.indexOf(36) > -1) {
            return null;
        }
        try {
            Class<?> candidateClass = classLoader.loadClass(className);
            if (validator.validateClass(classLoader, candidateClass)) {
                return candidateClass;
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            if (th.getCause() != null) {
                String missingClassName = th.getCause().getMessage();
                if (th.getCause() instanceof NoClassDefFoundError && missingClassName != null && missingClassName.startsWith("com/mumfrey/liteloader/")) {
                    throw new OutdatedLoaderException(missingClassName.substring(missingClassName.lastIndexOf(47) + 1));
                }
            }
            LiteLoaderLogger.warning(th, "checkAndAddClass error while checking '%s'", className);
        }
        return null;
    }
}

