/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.LiteLoaderInterfaceManager;
import com.mumfrey.liteloader.interfaces.InterfaceRegistry;
import java.util.ArrayList;
import java.util.List;

public class InterfaceRegistrationDelegate {
    private final InterfaceRegistry registry;
    private final InterfaceProvider provider;
    private final List<LiteLoaderInterfaceManager.InterfaceHandler> handlers = new ArrayList<LiteLoaderInterfaceManager.InterfaceHandler>();

    InterfaceRegistrationDelegate(InterfaceRegistry registry, InterfaceProvider provider) {
        this.registry = registry;
        this.provider = provider;
    }

    void addHandler(LiteLoaderInterfaceManager.InterfaceHandler handler) {
        this.handlers.add(handler);
    }

    List<LiteLoaderInterfaceManager.InterfaceHandler> getHandlers() {
        return this.handlers;
    }

    void registerInterfaces() {
        this.provider.registerInterfaces(this);
    }

    public void registerInterface(Class<? extends Listener> interfaceType) {
        this.registry.registerInterface(this.provider, interfaceType);
    }

    public void registerInterface(Class<? extends Listener> interfaceType, int priority) {
        this.registry.registerInterface(this.provider, interfaceType, priority);
    }

    public void registerInterface(Class<? extends Listener> interfaceType, int priority, boolean exclusive) {
        this.registry.registerInterface(this.provider, interfaceType, priority, exclusive);
    }
}

