/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.client.gui.GuiSimpleScrollBar;
import com.mumfrey.liteloader.client.gui.ScrollPanelContent;
import com.mumfrey.liteloader.gl.GL;
import com.mumfrey.liteloader.gl.GLClippingPlanes;

class GuiScrollPanel
extends GuiPanel {
    private ScrollPanelContent content;
    private GuiSimpleScrollBar scrollBar = new GuiSimpleScrollBar();
    private int left;
    private int top;
    private int contentHeight;

    public GuiScrollPanel(bcd minecraft, ScrollPanelContent content, int left, int top, int width, int height) {
        super(minecraft);
        this.setContent(content);
    }

    public void setContent(ScrollPanelContent content) {
        if (content == null) {
            throw new IllegalArgumentException("Scroll pane content can not be null");
        }
        this.content = content;
    }

    @Override
    void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.updateHeight();
    }

    public void setSizeAndPosition(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.setSize(width, height);
    }

    public void updateHeight() {
        this.contentHeight = this.content.getScrollPanelContentHeight(this);
        this.scrollBar.setMaxValue(this.contentHeight - this.height);
    }

    public void scrollToBottom() {
        this.scrollBar.setValue(this.contentHeight);
    }

    public void scrollToTop() {
        this.scrollBar.setValue(0);
    }

    public void scrollBy(int amount) {
        this.scrollBar.offsetValue(amount);
    }

    public bcx addControl(bcx control) {
        this.controls.add(control);
        return control;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        int scrollPosition = this.scrollBar.getValue();
        GLClippingPlanes.glEnableClipping(this.left, this.left + this.width - 6, this.top, this.top + this.height);
        GL.glPushMatrix();
        GL.glTranslatef(this.left, this.top - scrollPosition, 0.0f);
        this.content.drawScrollPanelContent(this, mouseX, mouseY, partialTicks, scrollPosition, this.height);
        super.draw(mouseX - this.left, mouseY + scrollPosition - this.top, partialTicks);
        GLClippingPlanes.glDisableClipping();
        GL.glPopMatrix();
        this.scrollBar.drawScrollBar(mouseX, mouseY, partialTicks, this.left + this.width - 5, this.top, 5, this.height, Math.max(this.height, this.contentHeight));
    }

    @Override
    public void mouseWheelScrolled(int mouseWheelDelta) {
        this.scrollBy(-mouseWheelDelta / 8);
    }

    @Override
    public void mousePressed(int mouseX, int mouseY, int mouseButton) {
        super.mousePressed(mouseX -= this.left, mouseY += this.scrollBar.getValue() - this.top, mouseButton);
        if (mouseX > 0 && mouseX < this.width && mouseY > 0 && mouseY < this.contentHeight) {
            this.content.scrollPanelMousePressed(this, mouseX, mouseY, mouseButton);
        }
        if (mouseButton == 0 && this.scrollBar.wasMouseOver()) {
            this.scrollBar.setDragging(true);
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.scrollBar.setDragging(false);
        }
    }

    @Override
    public void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 200) {
            this.scrollBar.offsetValue(-10);
        }
        if (keyCode == 208) {
            this.scrollBar.offsetValue(10);
        }
        if (keyCode == 201) {
            this.scrollBar.offsetValue(-this.height + 10);
        }
        if (keyCode == 209) {
            this.scrollBar.offsetValue(this.height - 10);
        }
        if (keyCode == 199) {
            this.scrollBar.setValue(0);
        }
        if (keyCode == 207) {
            this.scrollBar.setValue(this.contentHeight);
        }
    }

    @Override
    void onTick() {
    }

    @Override
    void onHidden() {
    }

    @Override
    void onShown() {
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void actionPerformed(bcx control) {
        this.content.scrollPanelActionPerformed(this, control);
    }
}

