/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mojang.realmsclient.dto.RealmsServer;
import com.mumfrey.liteloader.ChatFilter;
import com.mumfrey.liteloader.ChatListener;
import com.mumfrey.liteloader.JoinGameListener;
import com.mumfrey.liteloader.PostLoginListener;
import com.mumfrey.liteloader.PreJoinGameListener;
import com.mumfrey.liteloader.client.ClientPluginChannelsClient;
import com.mumfrey.liteloader.common.ducks.IChatPacket;
import com.mumfrey.liteloader.common.transformers.PacketEventInfo;
import com.mumfrey.liteloader.core.ClientPluginChannels;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import com.mumfrey.liteloader.core.PacketEvents;
import com.mumfrey.liteloader.core.event.EventCancellationException;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.runtime.Packets;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.util.ChatUtilities;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;

public class PacketEventsClient
extends PacketEvents {
    private static RealmsServer joiningRealm;
    private FastIterableDeque<JoinGameListener> joinGameListeners = new HandlerList<JoinGameListener>(JoinGameListener.class);
    private FastIterableDeque<ChatListener> chatListeners = new HandlerList<ChatListener>(ChatListener.class);
    private FastIterableDeque<ChatFilter> chatFilters = new HandlerList<ChatFilter>(ChatFilter.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private FastIterableDeque<PreJoinGameListener> preJoinGameListeners = new HandlerList<PreJoinGameListener>(PreJoinGameListener.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private FastIterableDeque<PostLoginListener> postLoginListeners = new HandlerList<PostLoginListener>(PostLoginListener.class);

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        super.registerInterfaces(delegate);
        delegate.registerInterface(JoinGameListener.class);
        delegate.registerInterface(ChatListener.class);
        delegate.registerInterface(ChatFilter.class);
        delegate.registerInterface(PreJoinGameListener.class);
        delegate.registerInterface(PostLoginListener.class);
    }

    public void registerJoinGameListener(JoinGameListener joinGameListener) {
        this.joinGameListeners.add(joinGameListener);
    }

    public void registerChatFilter(ChatFilter chatFilter) {
        this.chatFilters.add(chatFilter);
    }

    public void registerChatListener(ChatListener chatListener) {
        if (chatListener instanceof ChatFilter) {
            LiteLoaderLogger.warning("Interface error initialising mod '%1s'. A mod implementing ChatFilter and ChatListener is not supported! Remove one of these interfaces", chatListener.getName());
        } else {
            this.chatListeners.add(chatListener);
        }
    }

    public void registerPreJoinGameListener(PreJoinGameListener joinGameListener) {
        this.preJoinGameListeners.add(joinGameListener);
    }

    public void registerPostLoginListener(PostLoginListener postLoginListener) {
        this.postLoginListeners.add(postLoginListener);
    }

    public static void onJoinRealm(RealmsServer server) {
        joiningRealm = server;
    }

    @Override
    protected qc getPacketContextListener(Packets.Context context) {
        bcd minecraft = bcd.z();
        if (context == Packets.Context.SERVER) {
            return minecraft.F();
        }
        return minecraft;
    }

    @Override
    protected void handlePacket(PacketEventInfo<fh<?>> e, er netHandler, gu packet) {
        if (this.preJoinGame(e, netHandler, packet)) {
            return;
        }
        ((fk)netHandler).a(packet);
        super.handlePacket(e, netHandler, packet);
        this.postJoinGame(e, netHandler, packet);
    }

    private boolean preJoinGame(PacketEventInfo<fh<?>> e, er netHandler, gu packet) throws EventCancellationException {
        if (!(netHandler instanceof fk)) {
            return true;
        }
        e.cancel();
        return !((PreJoinGameListener)this.preJoinGameListeners.all()).onPreJoinGame(netHandler, packet);
    }

    private void postJoinGame(PacketEventInfo<fh<?>> e, er netHandler, gu packet) {
        ((JoinGameListener)this.joinGameListeners.all()).onJoinGame(netHandler, packet, bcd.z().C(), joiningRealm);
        joiningRealm = null;
        ClientPluginChannels clientPluginChannels = LiteLoader.getClientPluginChannels();
        if (clientPluginChannels instanceof ClientPluginChannelsClient) {
            ((ClientPluginChannelsClient)clientPluginChannels).onJoinGame(netHandler, packet);
        }
    }

    @Override
    protected void handlePacket(PacketEventInfo<fh<?>> e, er netHandler, jo packet) {
        if (netHandler instanceof jn) {
            jn netHandlerLoginClient = (jn)netHandler;
            ClientPluginChannels clientPluginChannels = LiteLoader.getClientPluginChannels();
            if (clientPluginChannels instanceof ClientPluginChannelsClient) {
                ((ClientPluginChannelsClient)clientPluginChannels).onPostLogin(netHandlerLoginClient, packet);
            }
            ((PostLoginListener)this.postLoginListeners.all()).onPostLogin(netHandlerLoginClient, packet);
        }
    }

    @Override
    protected void handlePacket(PacketEventInfo<fh<?>> e, er netHandler, ga packet) {
        ew originalChat;
        if (packet.a() == null) {
            return;
        }
        ew chat = originalChat = packet.a();
        String message = chat.d();
        for (ChatFilter chatFilter : this.chatFilters) {
            LiteLoaderEventBroker.ReturnValue<ew> ret;
            if (chatFilter.onChat(chat, message, ret = new LiteLoaderEventBroker.ReturnValue<ew>())) {
                if (!ret.isSet()) continue;
                chat = ret.get();
                if (chat == null) {
                    chat = new fc("");
                }
                message = chat.d();
                continue;
            }
            e.cancel();
            return;
        }
        if (chat != originalChat) {
            try {
                chat = ChatUtilities.convertLegacyCodes(chat);
                ((IChatPacket)packet).setChatComponent(chat);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ((ChatListener)this.chatListeners.all()).onChat(chat, message);
    }
}

