/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mumfrey.liteloader.PlayerInteractionListener;
import com.mumfrey.liteloader.client.LiteLoaderEventBrokerClient;
import com.mumfrey.liteloader.client.ducks.IFramebuffer;
import com.mumfrey.liteloader.core.Proxy;
import java.io.File;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class ClientProxy
extends Proxy {
    private static LiteLoaderEventBrokerClient broker;

    private ClientProxy() {
    }

    public static void onStartupComplete() {
        Proxy.onStartupComplete();
        broker = LiteLoaderEventBrokerClient.getInstance();
        if (broker == null) {
            throw new RuntimeException("LiteLoader failed to start up properly. The game is in an unstable state and must shut down now. Check the developer log for startup errors");
        }
        broker.onStartupComplete();
    }

    public static void onTimerUpdate() {
        broker.onTimerUpdate();
    }

    public static void newTick() {
    }

    public static void onTick() {
        broker.onTick();
    }

    public static void onRender() {
        broker.onRender();
    }

    public static void preRenderGUI(float partialTicks) {
        broker.preRenderGUI(partialTicks);
    }

    public static void onSetupCameraTransform(int pass, float partialTicks, long timeSlice) {
        broker.onSetupCameraTransform(pass, partialTicks, timeSlice);
    }

    public static void postRenderEntities(int pass, float partialTicks, long timeSlice) {
        broker.postRenderEntities(partialTicks, timeSlice);
    }

    public static void postRender(float partialTicks, long timeSlice) {
        broker.postRender(partialTicks, timeSlice);
    }

    public static void onRenderHUD(float partialTicks) {
        broker.onRenderHUD(partialTicks);
    }

    public static void onRenderChat(bcy chatGui, float partialTicks) {
        broker.onRenderChat(chatGui, partialTicks);
    }

    public static void postRenderChat(bcy chatGui, float partialTicks) {
        broker.postRenderChat(chatGui, partialTicks);
    }

    public static void postRenderHUD(float partialTicks) {
        broker.postRenderHUD(partialTicks);
    }

    public static void onCreateIntegratedServer(byl server, String folderName, String worldName, ahw worldSettings) {
        broker.onStartServer((MinecraftServer)server, folderName, worldName, worldSettings);
    }

    public static void onOutboundChat(CallbackInfo e, String message) {
        broker.onSendChatMessage(e, message);
    }

    public static void onResize(bcd mc2) {
        if (broker == null) {
            return;
        }
        broker.onResize(mc2);
    }

    public static void preRenderFBO(bnq frameBufferMc) {
        if (broker == null) {
            return;
        }
        if (frameBufferMc instanceof IFramebuffer) {
            ((IFramebuffer)frameBufferMc).setDispatchRenderEvent(true);
        }
        broker.preRenderFBO(frameBufferMc);
    }

    public static void postRenderFBO(bnq frameBufferMc) {
        if (broker == null) {
            return;
        }
        broker.postRenderFBO(frameBufferMc);
    }

    public static void renderFBO(bnq frameBufferMc, int width, int height, boolean flag) {
        if (broker == null) {
            return;
        }
        broker.onRenderFBO(frameBufferMc, width, height);
    }

    public static void onRenderWorld(float partialTicks, long timeSlice) {
        broker.onRenderWorld(partialTicks, timeSlice);
    }

    public static void onRenderSky(int pass, float partialTicks, long timeSlice) {
        broker.onRenderSky(partialTicks, pass, timeSlice);
    }

    public static void onRenderClouds(bnl renderGlobalIn, float partialTicks, int pass) {
        broker.onRenderClouds(partialTicks, pass, renderGlobalIn);
    }

    public static void onRenderTerrain(int pass, float partialTicks, long timeSlice) {
        broker.onRenderTerrain(partialTicks, pass, timeSlice);
    }

    public static void onSaveScreenshot(CallbackInfoReturnable<ew> ci, File gameDir, String name, int width, int height, bnq fbo) {
        broker.onScreenshot(ci, name, width, height, fbo);
    }

    public static <T extends rr> void onRenderEntity(brj source, brk<T> render, T entity, double x, double y, double z, float yaw, float pTicks) {
        broker.onRenderEntity(source, entity, x, y, z, yaw, pTicks, render);
    }

    public static <T extends rr> void onPostRenderEntity(brj source, brk<T> render, T entity, double x, double y, double z, float yaw, float pTicks) {
        broker.onPostRenderEntity(source, entity, x, y, z, yaw, pTicks, render);
    }

    public static boolean onClickMouse(bmr player, PlayerInteractionListener.MouseButton button) {
        return broker.onClickMouse(player, button);
    }

    public static boolean onMouseHeld(bmr player, PlayerInteractionListener.MouseButton button) {
        return broker.onMouseHeld(player, button);
    }
}

