/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.samsbucketblocks;

import com.lothrazar.samsbucketblocks.BlockRegistry;
import com.lothrazar.samsbucketblocks.CommonProxy;
import com.lothrazar.samsbucketblocks.TileEntityBucketStorage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="samsbucketblocks", useMetadata=true, updateJSON="https://raw.githubusercontent.com/LothrazarMinecraftMods/BucketBlocks/master/update.json", acceptedMinecraftVersions="[1.9]")
public class ModBucketBlocks {
    public static final String MODID = "samsbucketblocks";
    public static final String TEXTURE_LOCATION = "samsbucketblocks:";
    @Mod.Instance(value="samsbucketblocks")
    public static ModBucketBlocks instance;
    public static Logger logger;
    @SidedProxy(clientSide="com.lothrazar.samsbucketblocks.ClientProxy", serverSide="com.lothrazar.samsbucketblocks.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        BlockRegistry.registerBlocks();
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        TileEntity ent = world.func_175625_s(pos);
        if (ent != null && ent instanceof TileEntityBucketStorage) {
            TileEntityBucketStorage t = (TileEntityBucketStorage)ent;
            ItemStack stack = new ItemStack(state.func_177230_c());
            ModBucketBlocks.setItemStackNBT(stack, "buckets", t.getBuckets());
            ModBucketBlocks.dropItemStackInWorld(world, pos, stack);
            t.setBuckets(0);
        }
    }

    public static void setItemStackNBT(ItemStack item, String prop, int value) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        item.func_77978_p().func_74768_a(prop, value);
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, ItemStack stack) {
        EntityItem entityItem = new EntityItem(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        if (!worldObj.field_72995_K) {
            worldObj.func_72838_d((Entity)entityItem);
        }
        return entityItem;
    }

    public static void spawnParticle(World world, EnumParticleTypes type, BlockPos pos) {
        if (pos != null) {
            ModBucketBlocks.spawnParticle(world, type, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public static void spawnParticle(World world, EnumParticleTypes type, double x, double y, double z) {
        for (int countparticles = 0; countparticles <= 10; ++countparticles) {
            world.func_175688_a(type, x + (world.field_73012_v.nextDouble() - 0.5) * 0.8, y + world.field_73012_v.nextDouble() * 1.5 - 0.1, z + (world.field_73012_v.nextDouble() - 0.5) * 0.8, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

