/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.samsbucketblocks;

import com.lothrazar.samsbucketblocks.BlockRegistry;
import com.lothrazar.samsbucketblocks.ModBucketBlocks;
import com.lothrazar.samsbucketblocks.TileEntityBucketStorage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBucketStorage
extends Block
implements ITileEntityProvider {
    private Item bucketItem;
    public static final String NBTBUCKETS = "buckets";

    public BlockBucketStorage(Item bucketIn) {
        super(Material.field_151573_f);
        this.func_149711_c(7.0f);
        this.func_149752_b(7.0f);
        this.func_149672_a(field_149777_j);
        this.setHarvestLevel("pickaxe", 1);
        this.bucketItem = bucketIn;
    }

    public static int getBucketsStored(ItemStack item) {
        if (item.func_77973_b() == Item.func_150898_a((Block)BlockRegistry.block_storeempty)) {
            return 0;
        }
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74762_e(NBTBUCKETS) + 1;
    }

    public static int getItemStackBucketNBT(ItemStack item) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74762_e(NBTBUCKETS);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            int b = BlockBucketStorage.getItemStackBucketNBT(stack);
            TileEntityBucketStorage container = (TileEntityBucketStorage)worldIn.func_175625_s(pos);
            container.setBuckets(b);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntityBucketStorage container = (TileEntityBucketStorage)world.func_175625_s(pos);
        return container.getBuckets();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBucketStorage(meta);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack held = event.entityPlayer.func_71045_bC();
        if (event.pos == null) {
            return;
        }
        IBlockState bstate = event.entityPlayer.field_70170_p.func_180495_p(event.pos);
        if (bstate == null) {
            return;
        }
        Block blockClicked = bstate.func_177230_c();
        if (blockClicked == null || blockClicked == Blocks.field_150350_a) {
            return;
        }
        if (!(blockClicked instanceof BlockBucketStorage)) {
            return;
        }
        BlockBucketStorage block = (BlockBucketStorage)blockClicked;
        TileEntityBucketStorage container = (TileEntityBucketStorage)event.world.func_175625_s(event.pos);
        if (event.entityPlayer.func_70093_af()) {
            PlayerInteractEvent.Action cfr_ignored_0 = event.action;
            if (PlayerInteractEvent.Action.LEFT_CLICK_BLOCK == event.action && this.bucketItem == null) {
                int inside = blockClicked == BlockRegistry.block_storeempty ? 0 : container.getBuckets() + 1;
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(inside + "", new Object[0]));
                return;
            }
        }
        if (event.entityPlayer.func_70093_af()) {
            return;
        }
        if (held == null) {
            PlayerInteractEvent.Action cfr_ignored_1 = event.action;
            if (PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK == event.action && block.bucketItem != null && block.bucketItem == this.bucketItem) {
                if (container.getBuckets() > 0) {
                    this.removeBucket(event.entityPlayer, event.world, container, block.bucketItem);
                } else {
                    this.removeBucket(event.entityPlayer, event.world, container, block.bucketItem);
                    event.world.func_175656_a(event.pos, BlockRegistry.block_storeempty.func_176223_P());
                }
                event.world.func_175666_e(event.pos, blockClicked);
                ModBucketBlocks.playSoundAt((Entity)event.entityPlayer, "tile.piston.out");
                this.spawnMyParticle(event.world, block.bucketItem, event.pos.func_177972_a(event.face));
            }
        }
        PlayerInteractEvent.Action cfr_ignored_2 = event.action;
        if (PlayerInteractEvent.Action.LEFT_CLICK_BLOCK == event.action) {
            if (blockClicked == BlockRegistry.block_storeempty && block.bucketItem == null && held != null) {
                IBlockState state = null;
                if (held.func_77973_b() == Items.field_151129_at) {
                    state = BlockRegistry.block_storelava.func_176223_P();
                } else if (held.func_77973_b() == Items.field_151131_as) {
                    state = BlockRegistry.block_storewater.func_176223_P();
                }
                if (held.func_77973_b() == Items.field_151117_aB) {
                    state = BlockRegistry.block_storemilk.func_176223_P();
                }
                if (state != null) {
                    event.world.func_175656_a(event.pos, state);
                    this.addBucket(event.entityPlayer, event.world, container);
                    event.world.func_175666_e(event.pos, blockClicked);
                    ModBucketBlocks.playSoundAt((Entity)event.entityPlayer, "tile.piston.in");
                    this.spawnMyParticle(event.world, held.func_77973_b(), event.pos.func_177972_a(event.face));
                }
            } else if (held != null && held.func_77973_b() == block.bucketItem) {
                this.addBucket(event.entityPlayer, event.world, container);
                event.world.func_175666_e(event.pos, blockClicked);
                ModBucketBlocks.playSoundAt((Entity)event.entityPlayer, "tile.piston.in");
                this.spawnMyParticle(event.world, block.bucketItem, event.pos.func_177972_a(event.face));
            }
        }
    }

    private void spawnMyParticle(World world, Item item, BlockPos pos) {
        if (item == Items.field_151117_aB) {
            ModBucketBlocks.spawnParticle(world, EnumParticleTypes.SNOW_SHOVEL, pos);
        } else if (item == Items.field_151129_at) {
            ModBucketBlocks.spawnParticle(world, EnumParticleTypes.LAVA, pos);
        } else if (item == Items.field_151131_as) {
            ModBucketBlocks.spawnParticle(world, EnumParticleTypes.WATER_SPLASH, pos);
        }
    }

    private void removeBucket(EntityPlayer entityPlayer, World world, TileEntityBucketStorage storage, Item bucketItem) {
        storage.removeBucket();
        ModBucketBlocks.dropItemStackInWorld(world, entityPlayer.func_180425_c(), new ItemStack(bucketItem));
    }

    public void addBucket(EntityPlayer entityPlayer, World world, TileEntityBucketStorage storage) {
        storage.addBucket();
        entityPlayer.func_71028_bD();
    }

    public void addRecipe() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)BlockRegistry.block_storeempty), (Object[])new Object[]{"i i", " o ", "i i", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('i'), Blocks.field_150339_S});
    }
}

