﻿;-  Vdrive see Vdrive.txt - (c) 2012-2013, Horst Schaeffer
; --------------------------------------------------------
#Title = "Vdrive 1.5"  ; Unicode

LaunchPath.s = ProgramParameter()
If LaunchPath : LaunchFile.s = GetFilePart(LaunchPath) : Else : LaunchFile = "nothing" : EndIf 

If OpenPreferences(GetPathPart(ProgramFilename()) + "Vdrive.ini")
  IncludeByName.s = ReadPreferenceString("IncludeByName","") ; semicolon separated drive names
EndIf 

Enumeration 1 : #drives : #set : #select : #ok : #cancel : #info : EndEnumeration
x = DesktopMouseX()-260 : y = DesktopMouseY()
If x < 25 : x = 25 : EndIf 

WinHandle = OpenWindow(0,x,y,290,95,#Title,#PB_Window_SystemMenu) 
If WinHandle = #NUL : End : EndIf 
SetGadgetFont(#PB_Default,LoadFont(0,"MS Shell DLG 2",9))
TextGadget(#drives,0,12,125,20,"",#PB_Text_Center|#SS_NOTIFY)
GadgetToolTip(#drives,"Click for refresh")
ComboBoxGadget(#select,125,8,155,22)
TextGadget(#set,0,38,125,20,"",#PB_Text_Center)
TextGadget(#info,125,38,250,20,"and launch " + LaunchFile,#SS_NOTIFY)
GadgetToolTip(#info,LaunchPath)
ButtonGadget(#ok,125,62,75,24,"Ok")
ButtonGadget(#cancel,205,62,75,24,"Cancel")

AddKeyboardShortcut(0,#PB_Shortcut_Return,#ok)
AddKeyboardShortcut(0,#PB_Shortcut_Escape,#cancel)

Procedure ListDrives()
  Shared initialSelect, IncludeByName.s
  ClearGadgetItems(#select)
  
  DriveData.s = Space(#MAX_PATH) 
  DataLength = GetLogicalDriveStrings_(#MAX_PATH,@DriveData)
  *DriveData = @DriveData : lastchar.c = 0
  
  While DataLength
    character.c = PeekC(*DriveData)
    If lastchar = 0
      Drive.s = PeekS(*DriveData,2) 
      
      DriveName.s = Space(#MAX_PATH)
      If GetVolumeInformation_(Drive +"\",DriveName,#MAX_PATH,0,0,0,0,0) 
        If GetDriveType_(Drive +"\") = #DRIVE_REMOVABLE
        Else : i = 1
          Repeat
            name$ = StringField(IncludeByName,i,";") : i +1
            If name$ = "" : DriveName = "" : Break : EndIf 
          Until name$ = DriveName
        EndIf 
        
        If DriveName
          AddGadgetItem(#select,-1,Drive + "   " + Trim(DriveName))
          DriveCount +1
        EndIf 
      EndIf 
    EndIf 
    lastchar = Character
    *DriveData + SizeOf(character) : DataLength -1
  Wend
  
  If DriveCount > 0
    SetGadgetState(#select,0) 
    infoColor = #Black : number$ = Str(DriveCount)  
  Else 
    infoColor = #Red  : number$ = "No" 
  EndIf 
  SetGadgetColor(#info,#PB_Gadget_FrontColor,infoColor) 
  If DriveCount > 1 : pl$ = "s" : EndIf 
  SetGadgetText(#drives,number$ + " removable drive" + pl$)
  initialSelect = #True 
EndProcedure

Procedure EventCallback(Window, message, wParam, lParam)
  If message = #WM_DEVICECHANGE : ListDrives() : EndIf 
ProcedureReturn #PB_ProcessPureBasicEvents 
EndProcedure

SetWindowCallback(@EventCallback())
ListDrives()
Repeat
  action = 0  
  event = WaitWindowEvent()
  If event = #PB_Event_CloseWindow : action = #cancel
  ElseIf event = #PB_Event_Menu   : action = EventMenu()
  ElseIf event = #PB_Event_Gadget : action = EventGadget() 
  EndIf 
  If action = #drives : ListDrives()
  ElseIf initialSelect Or (action = #select And EventType() = #PB_EventType_Change)
    Vdrive.s = Left(GetGadgetText(#select),2) 
    SetGadgetText(#set,"Set Vdrive = " + Vdrive)
    initialSelect = #False
  ; ----------------------------------------------
  ElseIf action = #ok 
    If LaunchPath
      SetEnvironmentVariable_("Vdrive",Vdrive)
      LaunchPath = ReplaceString(LaunchPath,"%Vdrive%",Vdrive,#PB_String_NoCase)
      resp = ShellExecute_(WinHandle,"open",LaunchPath,"",GetPathPart(LaunchPath),#SW_SHOW)
      If resp <= 32 
        SetGadgetText(#info,"+++ Launch failed +++")
        SetGadgetColor(#info,#PB_Gadget_FrontColor,#Red)
        action = #NUL ; don't exit
      EndIf 
    EndIf 
  EndIf 
  ; ----------------------------------------------
Until action = #ok Or action = #cancel

End

; IDE Options = PureBasic 5.00 (Windows - x86)
; CursorPosition = 48
; FirstLine = 75
; Folding = -
; EnableUnicode
; EnableXP
; Executable = Vdrive.exe
; CommandLine = vtest.cmd
; CompileSourceDirectory