@echo off

title CPU IvyBridge/SandyBridge Microcode

cls
set guid=17088572-377F-44EF-8F4E-B09FFF46A070
set mpdtbn=mpdt\mpdt_boot_no.bin
set mpdtby=mpdt\mpdt_boot_yes.bin
set mc_ivb=0
set mc_snb=0

if not exist IVBSNB (echo Error! Folder IVBSNB not found) && pause && exit
if not exist mpdt (echo Error! Folder MPDT not found) && pause && exit

:mn
set ec=
echo.
echo		Generate FFS files Microcode for CPU IvyBridge (LGA1155)
echo.
echo 	19 Version 19 Date 06-13-2013 - Best overclocking
echo 	1B Version 1B Date 05-29-2014
echo 	0  Skip
echo.
:mn1
set /p ec=Enter Microcode:
if not defined ec goto mn1

if /I %ec%==19 (set mci=IVBSNB\cpu000306A9_plat12_ver00000019_date#13-06-2013.bin) && goto mn_snb
if /I %ec%==1B (set mci=IVBSNB\cpu000306A9_plat12_ver0000001B_date#29-05-2014.bin) && goto mn_snb
if /I %ec%==0 (set mc_ivb=1) && goto mn_snb
goto mn1

:mn_snb
set ec=
echo.
echo		Generate FFS files Microcode for CPU SandyBridge (LGA1155)
echo.
echo 	28 Version 28 Date 04-24-2012 - Best overclocking
echo 	29 Version 29 Date 06-12-2013
echo 	0  Skip
:mn2
set /p ec=Enter Microcode:
if not defined ec goto mn2
if /I %ec%==28 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000028_date#24-04-2012.bin) && goto start
if /I %ec%==29 (set mcs=IVBSNB\cpu000206A7_plat12_ver00000029_date#12-06-2013.bin) && goto start
if /I %ec%==0 (set mc_snb=1) && goto start
goto mn2

:start
if %mc_ivb%==0 if %mc_snb%==0 GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mci% -i %mcs% -o ..\..\..\temp\LGA1155.ffs
if %mc_ivb%==0 if %mc_snb%==1 GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mci% -o ..\..\..\temp\LGA1155.ffs
if %mc_ivb%==1 if %mc_snb%==0 GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mcs% -o ..\..\..\temp\LGA1155.ffs

exit