@echo off

title CPU Haswell Microcode

cls
set guid=17088572-377F-44EF-8F4E-B09FFF46A070
set mpdtbn=mpdt\mpdt_boot_no.bin
set mpdtby=mpdt\mpdt_boot_yes.bin

if not exist hsw (echo Error! Folder HSW not found) && pause && exit
if not exist mpdt (echo Error! Folder MPDT not found) && pause && exit

:mn
set ec=
echo.
echo		Generate FFS files Microcode for CPU Haswell-E (LGA2011v3)
echo.
echo 	19 Version  19 Date 03-07-2014
echo 	1D Version  1D Date 04-15-2014
echo 	1E Version  1E Date 05-07-2014
echo 	1F Version  1F Date 06-03-2014
echo 	23 Version  23 Date 07-11-2014
echo 	25 Version  25 Date 07-25-2014
echo 	27 Version  27 Date 08-08-2014
echo 	29 Version  29 Date 09-03-2014
echo 	2A Version  2A Date 09-11-2014
echo 	2B Version  2B Date 10-06-2014
echo 	2D Version  2D Date 11-21-2014
echo 	2E Version  2E Date 02-23-2015
echo 	31 Version  31 Date 04-16-2015
echo 	0  Exit
echo.
:mn1
set /p ec=Enter Microcode:
if not defined ec goto mn1
if /I %ec%==19 (set mc=hswe\cpu000306F2_plat6F_ver00000019_date#07-03-2014.bin) && goto start
if /I %ec%==1D (set mc=hswe\cpu000306F2_plat6F_ver0000001D_date#15-04-2014.bin) && goto start
if /I %ec%==1E (set mc=hswe\cpu000306F2_plat6F_ver0000001E_date#07-05-2014.bin) && goto start
if /I %ec%==1F (set mc=hswe\cpu000306F2_plat6F_ver0000001F_date#03-06-2014.bin) && goto start
if /I %ec%==23 (set mc=hswe\cpu000306F2_plat6F_ver00000023_date#11-07-2014.bin) && goto start
if /I %ec%==25 (set mc=hswe\cpu000306F2_plat6F_ver00000025_date#25-07-2014.bin) && goto start
if /I %ec%==27 (set mc=hswe\cpu000306F2_plat6F_ver00000027_date#08-08-2014.bin) && goto start
if /I %ec%==29 (set mc=hswe\cpu000306F2_plat6F_ver00000029_date#03-09-2014.bin) && goto start
if /I %ec%==2A (set mc=hswe\cpu000306F2_plat6F_ver0000002A_date#11-09-2014.bin) && goto start
if /I %ec%==2B (set mc=hswe\cpu000306F2_plat6F_ver0000002B_date#06-10-2014.bin) && goto start
if /I %ec%==2D (set mc=hswe\cpu000306F2_plat6F_ver0000002D_date#21-11-2014.bin) && goto start
if /I %ec%==2E (set mc=hswe\cpu000306F2_plat6F_ver0000002E_date#23-02-2015.bin) && goto start
if /I %ec%==31 (set mc=hswe\cpu000306F2_plat6F_ver00000031_date#16-04-2015.bin) && goto start
if /I %ec%==0 exit

goto mn1                        
:start
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -o ..\..\..\temp\LGA2011v3.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtbn% -o ..\..\..\temp\LGA2011v3_BOOT_NO.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtby% -o ..\..\..\temp\LGA2011v3_BOOT_YES.ffs

exit