@echo off

title CPU Haswell Microcode

cls
set guid=17088572-377F-44EF-8F4E-B09FFF46A070
set mpdtbn=mpdt\mpdt_boot_no.bin
set mpdtby=mpdt\mpdt_boot_yes.bin

if not exist hsw (echo Error! Folder HSW not found) && pause && exit
if not exist mpdt (echo Error! Folder MPDT not found) && pause && exit

:mn
set ec=
echo.
echo		Generate FFS files Microcode for CPU Haswell (LGA1150)
echo.
echo 	1  Version  1 Date 10-30-2012
echo 	2  Version  2 Date 11-30-2012
echo 	6  Version  6 Date 01-16-2013
echo 	7  Version  7 Date 01-21-2013
echo 	8  Version  8 Date 02-12-2013 - Disable overclocking non-"K" CPU
echo 	9  Version  9 Date 04-04-2013
echo 	10 Version 10 Date 20-06-2013
echo 	12 Version 12 Date 07-02-2013
echo 	16 Version 16 Date 08-07-2013
echo 	17 Version 17 Date 08-16-2013
echo 	19 Version 19 Date 02-26-2014 - Best overclocking
echo 	1A Version 1A Date 05-23-2014 - Disable TSX
echo 	1C Version 1C Date 07-03-2014
echo 	1D Version 1D Date 12-10-2014
echo 	0  Exit

echo.
:mn1
set /p ec=Enter Microcode:
if not defined ec goto mn1

if /I %ec%==1 (set mc=hsw\cpu000306C3_plat32_ver00000001_date#30-10-2012.bin) && goto start
if /I %ec%==2 (set mc=hsw\cpu000306C3_plat32_ver00000002_date#30-11-2012.bin) && goto start
if /I %ec%==6 (set mc=hsw\cpu000306C3_plat32_ver00000006_date#16-01-2013.bin) && goto start
if /I %ec%==7 (set mc=hsw\cpu000306C3_plat32_ver00000007_date#21-01-2013.bin) && goto start
if /I %ec%==8 (set mc=hsw\cpu000306C3_plat32_ver00000008_date#12-02-2013.bin) && goto start
if /I %ec%==9 (set mc=hsw\cpu000306C3_plat32_ver00000009_date#04-04-2013.bin) && goto start
if /I %ec%==10 (set mc=hsw\cpu000306C3_plat32_ver00000010_date#20-06-2013.bin) && goto start
if /I %ec%==12 (set mc=hsw\cpu000306C3_plat32_ver00000012_date#02-07-2013.bin) && goto start
if /I %ec%==16 (set mc=hsw\cpu000306C3_plat32_ver00000016_date#07-08-2013.bin) && goto start
if /I %ec%==17 (set mc=hsw\cpu000306c3_plat32_ver00000017_date#16-08-2013.bin) && goto start
if /I %ec%==19 (set mc=hsw\cpu000306C3_plat32_ver00000019_date#26-02-2014.bin) && goto start
if /I %ec%==1A (set mc=hsw\cpu000306c3_plat32_ver0000001a_date#23-05-2014.bin) && goto start
if /I %ec%==1C (set mc=hsw\cpu000306C3_plat32_ver0000001C_date#03-07-2014.bin) && goto start
if /I %ec%==1D (set mc=hsw\cpu000306C3_plat32_ver0000001D_date#10-12-2014.bin) && goto start
if /I %ec%==0 exit

goto mn1

:start
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -o ..\..\..\temp\LGA1150.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtbn% -o ..\..\..\temp\LGA1150_BOOT_NO.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtby% -o ..\..\..\temp\LGA1150_BOOT_YES.ffs

exit