
module BGSketchup_Tube_cutting_optimization
	class BGSketchup_Optimisation_Decoupe
		Sketchup::require 'BGSketchup_Tube_cutting_optimisation/Tube_Localization'
		extend BGSketchup_Tube_cutting_optimization
		
		@composant_selectionne=nil
		@vecteur_selectionne=nil
		@optimisation_CSV=[]
		@BOM_CSV=[]
		
		def self.show_hide_window
			#On affiche la fenêtre
				if @my_dialog==nil 
					# On créé la boîte de dialogue    
						@my_dialog = UI::WebDialog.new("Tube cutting optimization "+BGSketchup_Tube_cutting_optimisation_extension.version, false, nil , 300, 320, 200, 200, true)
					# On affiche la boîte de dialogue
						html_path = File.join(File.dirname(__FILE__), "Html", "Tube_Main.php")
						@my_dialog.set_file(html_path)
						@my_dialog.show()
						@my_dialog.set_background_color(@my_dialog.get_default_dialog_color)
						@my_dialog.set_on_close{ @my_dialog=nil }

					# Gestion des actions générées par la boîte de dialogue
						@my_dialog.add_action_callback("get_data") do |web_dialog,action_name|
							action_name.gsub!("#","'")  if action_name!=nil
							action_name.gsub!("|",'"') if action_name!=nil
							if action_name.index("(")!=nil then
								action=action_name[0..action_name.index("(")-1]
								parameter=action_name[action.length+1..action_name.length-2].split(";")
								action_name=action
							end
							case action_name
								when "start" then self.start
								when "select_component" then self.select_component
								when "select_vector" then self.select_vector
								when "bom" then self.MAJ_BOM(parameter[0])
								when "optimisation" then self.optimisation(parameter)
								when "exportBOMCSV" then self.exportBOMCSV
								when "exportOptiCSV" then self.exportOptiCSV
								when "About" then self.about
								when "swap_option" then self.swap_option(parameter)
								when "prompt_update_check" then self.prompt_update_check(parameter)
								when "change_language" then self.change_language(parameter)
								when "tube_length_focus" then self.tube_length_focus
							end
						end
				end
		end
		
		def self.about()
			UI.messagebox "Tube cutting optimization."+13.chr+13.chr+"Created by BGSketchup on August 2014. "+13.chr+"Version "+BGSketchup_Tube_cutting_optimisation_extension.version
		end
		
		def self.somme_des_chutes(optimisation, longueur_des_barres)
			chute=0
			for o in optimisation
				lgr=0
				for b in o
					lgr+=b
				end
				chute+=longueur_des_barres-lgr
			end
			return chute
		end
		
		def self.start	#Executer au chargement de la page HTML
			self.load_options
			
			puts @option_language
			initialise_localization
			self.load_options_in_html
			self.stats_incrementer_compteur
			self.translations_HTML
			self.check_for_updates("check") #doit être après self.translations_HTML
			self.verifie_vecteur_defini_html #doit être après self.translations_HTML
			@option_usage+=1
			self.save_options
			bgSketchup_execute_script(@my_dialog,"plugin_version='"+BGSketchup_Tube_cutting_optimisation_extension.version.to_s+"';")
		end
		
		# HTML
		def self.add_bom_in_html(bom)
			self.clear_table_bom_in_html
			return nil if bom==nil
			js="";j=0; somme=0; somme2=0; @BOM_CSV=[]
			for i in bom
				j+=1
				js+="var nouvelleLigne = document.getElementById('table2').insertRow(-1);"
				if j%2!=0 then
					js+="nouvelleLigne.style.background='lightgrey';"
				end
				somme+=i[1] #Nombre de tubes
				somme2+=i[1]*i[0] #Longueur des tubes utilisés
				js+="var colonne1 = nouvelleLigne.insertCell(0);colonne1.innerHTML += '"+i[1].to_s+"';"
				js+="var colonne2 = nouvelleLigne.insertCell(1);colonne2.innerHTML += '"+bgSketchup_to_java(Sketchup.format_length(sprintf('%.5f',i[0]).to_f))+"';"
				@BOM_CSV.push i[1].to_s+";"+Sketchup.format_length(sprintf('%.5f',i[0]).to_f).to_s
			end
			js+="nouvelleLigne.style.borderBottom='double';"
			js+="var nouvelleLigne = document.getElementById('table2').insertRow(-1);"
			js+="var colonne1 = nouvelleLigne.insertCell(0);colonne1.innerHTML += '<B>"+bgSketchup_to_java(somme.to_s)+"</B>';"
			js+="var colonne2 = nouvelleLigne.insertCell(1);colonne2.innerHTML += '<B>"+bgSketchup_to_java(Sketchup.format_length(sprintf('%.5f',somme2).to_f))+"</B><img onclick="+34.chr+"exportBOMCSV();"+34.chr+" src="+34.chr+"csv.png"+34.chr+" class="+34.chr+"csv_icon"+34.chr+" title="+34.chr+bgSketchup_to_java(@translation_export_csv)+34.chr+"/>';"
			js+="nouvelleLigne.style.background='darkgrey';"
			@my_dialog.execute_script(js)
		end
		def self.clear_table_optimisation_in_html
			@my_dialog.execute_script("clear_table_optimisation_in_html();")
		end
		def self.clear_table_bom_in_html
			@my_dialog.execute_script("clear_table_bom_in_html();")
		end
		def self.hide_flap_2_3
			js="hide_flap_2_3();"
			@my_dialog.execute_script(js)
		end
		def self.add_optimisation_in_html(optimisation, chute, longueur_des_barres,largeur_decoupe,pls_longueur)
			self.clear_table_optimisation_in_html
			@optimisation_CSV=[] ; js="" ; j=0 ; somme_chute=0
			for i in optimisation
				j+=1
				js+="var nouvelleLigne = document.getElementById('table3').insertRow(-1);"
				js+="nouvelleLigne.style.background='lightgrey';" if j%2!=0 #Met en gris une ligne sur 2
				js+="var colonne1 = nouvelleLigne.insertCell(0);colonne1.innerHTML += '"+j.to_s+"';"
				
				#On ajoute les barres
				text=""; somme=0
				text+="Tube of "+Sketchup.format_length(sprintf('%.5f',(longueur_des_barres[j])).to_f)+" divided in :<BR>" if pls_longueur==true
				for b in i
					text+=Sketchup.format_length(sprintf('%.5f',b).to_f)+"; "
					somme+=b+largeur_decoupe
				end
				text.chop!.chop! #On supprime le dernier point-virgule
				js+="var colonne2 = nouvelleLigne.insertCell(1);colonne2.innerHTML += '"+bgSketchup_to_java(text)+"';"
				
				#On ajoute la chute
				if pls_longueur==false then
					if somme>=longueur_des_barres then #Doit-on faire la dernière découpe ?
						chuteb=Sketchup.format_length(sprintf('%.5f',0).to_f)
						somme_chute+=0
					else
						chuteb=Sketchup.format_length(sprintf('%.5f',(longueur_des_barres-somme)).to_f)
						somme_chute+=sprintf('%.5f',(longueur_des_barres-somme)).to_f
					end
				else
					if somme>=longueur_des_barres[j] then #Doit-on faire la dernière découpe ?
						chuteb=Sketchup.format_length(sprintf('%.5f',0).to_f)
						somme_chute+=0
					else
						chuteb=Sketchup.format_length(sprintf('%.5f',(longueur_des_barres[j]-somme)).to_f)
						somme_chute+=sprintf('%.5f',(longueur_des_barres[j]-somme)).to_f
					end
				end
				js+="var colonne3 = nouvelleLigne.insertCell(2);colonne3.innerHTML += '"+bgSketchup_to_java(chuteb)+"';"
				
				js+="colonne1.style.width='10%';"
				js+="colonne2.style.width='60%';"
				js+="colonne3.style.width='30%';"
				@optimisation_CSV.push j.to_s+";"+text.gsub(";",",")+";"+bgSketchup_to_java(chuteb)
			end
			#Add summary
			js+="var nouvelleLigne = document.getElementById('table3').insertRow(-1);"
			js+="var colonne1 = nouvelleLigne.insertCell(0);colonne1.innerHTML += '<B>"+bgSketchup_to_java(@translation_quantity)+" "+j.to_s+", "+bgSketchup_to_java(@translation_loss)+" "+bgSketchup_to_java(Sketchup.format_length(sprintf('%.5f',somme_chute).to_f))+"</B><img onclick="+34.chr+"exportOptiCSV();"+34.chr+" src="+34.chr+"csv.png"+34.chr+" class="+34.chr+"csv_icon"+34.chr+" title="+34.chr+bgSketchup_to_java(@translation_export_csv)+34.chr+"/>';colonne1.colSpan = 3;"
			@my_dialog.execute_script(js)
		end
		def self.verifie_vecteur_defini_html
			if @vecteur_selectionne!=nil then
				js="document.getElementById('vector').innerHTML='"+bgSketchup_to_java(@translation_vector_defined)
				js+="';document.getElementById('vector').style.backgroundColor=document.body.style.backgroundColor;"
			else
				js="document.getElementById('vector').innerHTML='"+bgSketchup_to_java(@translation_vector_not_defined)
				js+="';document.getElementById('vector').style.backgroundColor='#FE9A2E';"
			end
			if @composant_selectionne!=nil then
				js+="document.getElementById('component').innerHTML='"+bgSketchup_to_java(@translation_component_selected)+" : "+bgSketchup_to_java(@composant_selectionne.definition.name.to_s)
				if @ratio!=nil && @vecteur_selectionne!=nil then
					js+="<BR>"+bgSketchup_to_java(@translation_unscaled_length)+" :&nbsp"+bgSketchup_to_java((@ratio*@vecteur_selectionne.length).to_l.to_s)
				end
				js+="';document.getElementById('component').style.backgroundColor=document.body.style.backgroundColor;"
			else
				js+="document.getElementById('component').innerHTML='"+bgSketchup_to_java(@translation_component_not_selected)
				js+="';document.getElementById('component').style.backgroundColor='#FE9A2E';"
			end
			if @composant_selectionne!=nil && @vecteur_selectionne!=nil then
				js+="document.getElementById('tlt0').style.display='none';show_flap_2_3();"
			else
				js+="document.getElementById('tlt0').style.display='inline';hide_flap_2_3();"
			end
			@my_dialog.execute_script(js)
		end
		def self.tube_length_focus
			js="document.getElementById('barre_etat').innerHTML='"+bgSketchup_to_java(@translation_different_length)+"';"
			@my_dialog.execute_script(js)
		end
		
		#On créé un tableau avec toutes les longueurs de barres
		def self.creer_tableau_des_barres(tableau_besoin)
			#dans tableau_besoin : [[longueur, quantité],...]
			return nil if tableau_besoin==nil
			barres=[]
			for besoin in tableau_besoin
				for i in 1..besoin[1]
					barres.push besoin[0]
				end
			end
			return barres
		end
		def self.creer_bom(barres) # Liste le nombre de barres (dans 'barres') par ordre de taille
			return nil if barres.length==0
			resultat=[]
			barres2=barres.sort
			i=0
			while barres2.length>0
				barre=barres2[i]
				#On compte le nb de barre identique
					count=0
					for b in barres2
						count+=1 if b==barre
					end
				#On ajoute au résultat
					resultat.push [barre, count]
				#On supprime la barre traitée
					barres2.delete(barre)
			end
			return resultat
		end
		
		#Algorithme optimisation découpe
		def self.optimisation(parametres)
			self.clear_table_optimisation_in_html
			return nil if parametres[0]==nil
			pls_longueur=false
			@never_stop=false
			
			#Longueur des barres
				if parametres[0].index("/")!=nil then #Si on a plusieurs longueurs
					pls_longueur=true
					longueur_des_barres=[]
					barres=parametres[0].split("/")
					for barre in barres
						begin
							longueur_des_barres.push barre.to_l
						rescue
							longueur_des_barres.push barre.gsub(".",",").to_l
						end
					end
					if @option_use_smallest_tubes==true then #On trie les barres non découpées aussi
						longueur_des_barres.sort!
					else
						longueur_des_barres.sort!.reverse!
					end
				else
					begin
						longueur_des_barres=parametres[0].to_l
					rescue
						longueur_des_barres=parametres[0].gsub(".",",").to_l
					end
				end
			
			#chute
				begin
					chute_admissible=parametres[1].to_l
				rescue
					if parametres[1]==nil then
						chute_admissible=0
					else
						chute_admissible=parametres[1].gsub(".",",").to_l
					end
				end
			
			#Découpe
				begin
					largeur_decoupe=parametres[2].to_l
				rescue
					if parametres[2]==nil then
						largeur_decoupe=0
					else
						largeur_decoupe=parametres[2].gsub(".",",").to_l
					end
				end
				
			#On liste toutes les longueurs des instances
				tableau_besoin=self.liste_instances(parametres[3])
			
			#On vérifie qu'aucune barre n'est plus longue que la longueur nominale
				if pls_longueur==false then #Si une longueur
					barres=creer_tableau_des_barres(tableau_besoin)
					for barre in barres
						if barre>longueur_des_barres then
							UI.messagebox @translation_error_tube_length
							return nil
						end
					end
				end
			#On lance l'optimisation
				if pls_longueur==false then #Si une longueur
					optimisation=self.debut_decoupe(tableau_besoin, largeur_decoupe, longueur_des_barres, chute_admissible)
				else #Si plusieurs longueurs
					optimisation=self.debut_decoupe2(tableau_besoin, largeur_decoupe, longueur_des_barres, chute_admissible)
				end
			#On affiche le résultat
			self.add_optimisation_in_html(optimisation, 0, longueur_des_barres,largeur_decoupe,pls_longueur) if optimisation!=nil
		end

		def self.debut_decoupe(tableau_besoin, largeur_decoupe, longueur_des_barres, chute_admissible)
			#On créé un tableau avec toutes les longueurs de barres
				barres=creer_tableau_des_barres(tableau_besoin)
			
			#On trie le tableau par ordre décroissant
				barres.sort!.reverse!
				
			#On lance le top
				@start_timer=Time.now
			
			#On calcul les découpes
			decoupes=[]
			nb_barres=barres.length
			begin
				# On prend la barre et on regarde les autres barres qu'on peut mettre dessus
					longueur_depart=barres[0]
					barres2=barres.clone ; barres2.delete_at(0)
					resultat=self.barre_suivante(barres2, longueur_depart, largeur_decoupe, longueur_des_barres, chute_admissible,0)

				# On vérifie
					if resultat==nil then #Pas de résultat : la barre sera seule
						resultat=[barres[0]]
					else
						resultat=[barres[0]].concat(resultat[1])
					end
					decoupes.push resultat
					barres=self.supprime_barres(barres, resultat) #On enlève les barres du résultat au tableau (elles sont déjà découpées)
				
				#On passe à la barre suivante, si elle existe
					Sketchup.set_status_text "Tube pending to be cut : "+barres.length.to_s 
					Sketchup.active_model.active_view.invalidate
					
			end while barres[0]!=nil
			Sketchup.set_status_text ""
			return decoupes
		end
		def self.barre_suivante(barres, longueur_depart, largeur_decoupe, longueur_des_barres, chute_admissible,niveau) #Retourne un tableau de barres optimisant la découpe, sinon nil
			chute_mini=nil
			config_mini=[]
			barres_deja_essayees=[]
			return nil if barres.length==0
			
			if (Time.now-@start_timer).to_i>=30 && @never_stop==false then 
				reponse=UI.messagebox(@translation_calculation_too_long, MB_YESNOCANCEL)
				exit if reponse==IDYES
				@start_timer=Time.now
				@never_stop=true if reponse==IDCANCEL
			end
			
			for barre in 0..barres.length-1
				barre_decoupee=barres[barre]
				#puts  niveau.to_s+" nb barres="+barres.length.to_s+" barre = "+barre.to_s+" longueur = "+barre_decoupee.to_s
				#Sketchup.active_model.active_view.refresh #if barres.length==1

				
				if barres_deja_essayees.index(sprintf('%.5f',barre_decoupee))==nil then #Si on a pas déjà étudié le cas de cette longueur de barre
					barres_deja_essayees.push sprintf('%.5f',barre_decoupee)
					
					longueur=longueur_depart+barre_decoupee
					chute=longueur_des_barres-longueur-largeur_decoupe
					#puts "23, barre="+barre.to_s if niveau==23
					#puts "chute ="+chute.to_s+" longueur = "+longueur.to_s+" barre_decoupee="+barre_decoupee.to_s if niveau==24
					#puts "barres_deja_essayees="+barres_deja_essayees.to_s if niveau==24
					
					if longueur<=longueur_des_barres then #On ne dépasse pas la longueur maxi
						if barres.length==1 then #Plus d'autre barre : on peut mettre donc toutes les barres
							chute_mini=chute
							config_mini=[barres[barre]]
							#puts "longueur=1"
							return [chute_mini, config_mini, true]
						end
						
						if chute<=chute_admissible then
							#La chute est admissible, on peut retourner directement le résultat
							chute_mini=chute
							config_mini=[barres[barre]]
							break
						else
							#La chute n'est pas admissible
							#On créé un tableau intermédiaire sans la barre
								barres2=barres.clone ; barres2.delete_at(barre)
								
							if barres2.length==0 then
								#On a mis toutes les barres, ont peux s'arrêter là
								chute_mini=chute
								config_mini=[barres[barre]]
								#puts "ICIIIIIIII"
								return [chute_mini, config_mini, true]
							else
								 #puts barres2.length.to_s
								#On n'a pas mis toutes les barres
								#On regarde si on ne peut pas ajouter de barre
								resultat=self.barre_suivante(barres2, longueur+largeur_decoupe, largeur_decoupe, longueur_des_barres, chute_admissible,niveau+1)
								#abort if resultat==nil
								#puts "niveau = "+niveau.to_s+"; resultat= "+resultat.to_s if niveau>20
								if resultat==nil then #On ne peut pas ajouter d'autre barre : on a la chute mini									
									if chute_mini==nil then
										chute_mini=chute
										config_mini=[barre_decoupee]
									else
										if chute<chute_mini then
											chute_mini=chute
											config_mini=[barre_decoupee]
										else
											#La chute n'est pas la plus petite !
										end
									end
								else #On a le meilleur résultat
									if resultat[2]==true then #Il n'y avait pas d'autres barres à rajouter
										chute_mini=resultat[0]										
										resultat[1].unshift(barre_decoupee)
										config_mini=resultat[1]
										#puts "config mini ="+config_mini.to_s
										return [chute_mini, config_mini, true]
									end
									
									#A-t-on une chute admissible ?
									if resultat[0]<chute_admissible then
										#La chute est admissible, on peut retourner directement le résultat
										chute_mini=resultat[0]										
										resultat[1].unshift(barre_decoupee)
										config_mini=resultat[1]
										break
									else #Sinon, on a un résultat mais on regarde pour ajouter d'autres barres
										if chute_mini==nil then #Pas de chute mini pour l'instant
											chute_mini=resultat[0]
											resultat[1].unshift(barre_decoupee)
											config_mini=resultat[1]
										else
											if resultat[0]<chute_mini then #La chute est la plus petite pour l'instant!
												chute_mini=resultat[0]
												resultat[1].unshift(barre_decoupee)
												config_mini=resultat[1]
											else
												#La chute n'est pas la plus petite !
											end
										end
										#puts "chute mini"+chute_mini.to_s if chute_mini!=nil
									end
								end
							end
						end
					else 
						#La barre est trop grande : on passe à la barre suivante
					end
				end
				
			end
			if chute_mini==nil then #On ne peut ajouter aucune barre : on retourne nil
				return nil		
			else #Il y a une solution : on retourne [chute_mini, configuration]
				return [chute_mini, config_mini, false]
			end
		end	
		
		def self.debut_decoupe2(tableau_besoin, largeur_decoupe, longueur_des_barres, chute_admissible)
			#On créé un tableau avec toutes les longueurs de barres
				barres=creer_tableau_des_barres(tableau_besoin)
			
			#On trie le tableau par ordre décroissant
				barres.sort!.reverse!
				
			#On lance le top
				@start_timer=Time.now
			
			#On calcul les découpes
			decoupes=[]
			nb_barres=barres.length
			barre_non_decoupee=0
			begin
				# On prend la barre et on regarde les autres barres qu'on peut mettre dessus
					longueur_depart=barres[0]
					barres2=barres.clone ; barres2.delete_at(0)
					resultat=self.barre_suivante2(barres2, longueur_depart, largeur_decoupe, longueur_des_barres[barre_non_decoupee], chute_admissible)
				# On vérifie
					if resultat==nil then #Pas de résultat : la barre sera seule
						resultat=[barres[0]]
					else
						resultat=[barres[0]].concat(resultat[1])
					end
					decoupes.push resultat
					barres=self.supprime_barres(barres, resultat) #On enlève les barres du résultat au tableau (elles sont déjà découpées)
				
				#On passe à la barre suivante, si elle existe
					Sketchup.set_status_text "Tube pending to be cut : "+barres.length.to_s 
					Sketchup.active_model.active_view.invalidate
					
					barre_non_decoupee+=1
					if barre_non_decoupee>=longueur_des_barres.length then 
						UI.messagebox @translation_tube_missing
						return nil
					end
					
			end while barres[0]!=nil
			
			Sketchup.set_status_text ""
			return decoupes
		end
		#2500/2400/2300/2200/2100/2000/1900/1800/1700/1600/1700/1800/1900/2500/2500/1800/1800
		def self.barre_suivante2(barres, longueur_depart, largeur_decoupe, longueur_des_barres, chute_admissible) #Retourne un tableau de barres optimisant la découpe, sinon nil
			chute_mini=nil
			config_mini=[]
			barres_deja_essayees=[]
			return nil if barres.length==0
			
			if (Time.now-@start_timer).to_i>=30 && @never_stop==false then 
				reponse=UI.messagebox(@translation_calculation_too_long, MB_YESNOCANCEL)
				exit if reponse==IDYES
				@start_timer=Time.now
				@never_stop=true if reponse==IDCANCEL
			end
			
			for barre in 0..barres.length-1
				barre_decoupee=barres[barre]
				
				if barres_deja_essayees.index(barre_decoupee)==nil then
					barres_deja_essayees.push barre_decoupee
					longueur=longueur_depart+barre_decoupee
					chute=longueur_des_barres-longueur-largeur_decoupe
										
					if longueur<=longueur_des_barres then #On ne dépasse pas la longueur maxi
						if chute<=chute_admissible then
							#La chute est admissible, on peut retourner directement le résultat
							chute_mini=chute
							config_mini=[barres[barre]]
							break
						else
							#La chute n'est pas admissible
							#On créé un tableau intermédiaire sans la barre
								barres2=barres.clone ; barres2.delete_at(barre)
							#On regarde si on ne peut pas ajouter de barre
								resultat=self.barre_suivante2(barres2, longueur+largeur_decoupe, largeur_decoupe, longueur_des_barres, chute_admissible)
								if resultat==nil then 
									#On ne peut pas ajouter d'autre barre : on a la chute mini
									if chute_mini==nil then
										chute_mini=chute
										config_mini=[barre_decoupee]
									else
										if chute<chute_mini then
											chute_mini=chute
											config_mini=[barre_decoupee]
										else
											#La chute n'est pas la plus petite !
										end
									end
								else
									#A-t-on une chute admissible ?
										if resultat[0]<chute_admissible then
											#La chute est admissible, on peut retourner directement le résultat
											chute_mini=resultat[0]										
											resultat[1].unshift(barre_decoupee)
											config_mini=resultat[1]
											break
										end
									#Sinon, on peut ajouter d'autres barres
									if chute_mini==nil then
										chute_mini=resultat[0]
										resultat[1].unshift(barre_decoupee)
										config_mini=resultat[1]
									else
										if resultat[0]<chute_mini then
											#La chute est la plus petite !
											chute_mini=resultat[0]
											resultat[1].unshift(barre_decoupee)
											config_mini=resultat[1]
										else
											#La chute n'est pas la plus petite !
										end
									end
								end
						end
					else 
						#La barre est trop grande : on passe à la barre suivante
					end
				end
				
			end
			
			if chute_mini==nil then #On ne peut ajouter aucune barre : on retourne nil
				return nil		
			else #Il y a une solution : on retourne [chute_mini, configuration]
				return [chute_mini, config_mini]
			end
		end	

		def self.longueur_instance(instance)
			#On prend un vecteur
				axec=@vecteur_selectionne.clone
			#On lui applique la même transformation que l'instance
				axec.transform! instance.transformation
			#Sa nouvelle longueur nous donne l'agrandissement
				r=@ratio*(axec.length/@vecteur_selectionne.length)
				return sprintf('%.5f',r*@vecteur_selectionne.length).to_f
		end
		def self.supprime_barres(barres, barres_a_supprimer)
			for barre in barres_a_supprimer
				for i in 0..barres.length-1
					if barres[i]==barre then
						barres.delete_at(i)
						break #On change de "barre"
					end
				end
			end
			return barres
		end

		#EXPORT FUNCTIONS
		def self.exportOptiCSV
			path=Sketchup.active_model.path
			if path!="" then
				file_name = UI.savepanel("Export in CSV", path, "Optimization.csv")
			else
				file_name = UI.savepanel("Export in CSV", "c:\\", "Optimization.csv")
			end
			if file_name!=nil then
				File.delete(file_name) if File.exists?(file_name)
				file=File.new(file_name, "w")
				file.puts("Number;Lengths;Loss") 
				for ligne in @optimisation_CSV
					file.puts(ligne) 
				end				
				file.close
			end
		end
		def self.exportBOMCSV
			path=Sketchup.active_model.path
			if path!="" then
				file_name = UI.savepanel("Export in CSV", path, "Part_list.csv")
			else
				file_name = UI.savepanel("Export in CSV", "c:\\", "Part_list.csv")
			end
			if file_name!=nil then
				File.delete(file_name) if File.exists?(file_name)
				file=File.new(file_name, "w")
				file.puts("Quantity;Length") 
				for ligne in @BOM_CSV
					file.puts(ligne) 
				end				
				file.close
			end
		end
		
		#COMPONENT MODEL LIST
		def self.liste_instances(parametres) #Liste toutes les instances du composant
			if parametres=="model" then
				region=Sketchup.active_model.entities
			else
				region = Sketchup.active_model.selection
				return nil if Sketchup.active_model.selection.length==0
			end
			resultat=self.sous_instance(region,@composant_selectionne.definition.name)
			resultat=self.creer_bom(resultat)
			return resultat
		end
		def self.sous_instance(entity, definition_name)
			resultat=[]
			for e in entity
				if e.is_a? Sketchup::ComponentInstance and !(e.deleted?) then
					if e.definition.name==@composant_selectionne.definition.name then
						resultat.push self.longueur_instance(e)
					else
						#On regarde en dessous aussi, si ce n'est pas le composant voulu
						resultat=resultat.concat(self.sous_instance(e.definition.entities, definition_name))
					end
				elsif e.is_a? Sketchup::Group then #Un groupe ? On regarde en dessous
					resultat=resultat.concat(self.sous_instance(e.entities, definition_name))
				end
			end
			return resultat
		end
		
		def self.MAJ_BOM(parametres)
			resultat=self.liste_instances(parametres)
			self.add_bom_in_html(resultat)
		end
		
		#OPTIONS
		def self.save_options
			file_name=File.join(bgSketchup_getTempFolder,"BGSketchup_Tube_cutting_optimization.ini")
			File.delete(file_name) if File.exists?(file_name)
			file=File.new(file_name, "w")
			file.puts("option_use_smallest_tubes") 
			file.puts(@option_use_smallest_tubes)
			file.puts("option_check_for_updates")
			file.puts(@option_check_for_updates)
			file.puts("option_change_language")
			file.puts(@option_change_language)
			file.puts("option_language")
			file.puts(@option_language)
			file.puts("option_prompt_my_language_added")
			file.puts(@option_prompt_my_language_added)
			file.puts("option_usage")
			file.puts(@option_usage)
			file.close
		end
		def self.load_options
			#Load default option in case one option is missing
			self.load_default_options
			file_name=File.join(bgSketchup_getTempFolder,"BGSketchup_Tube_cutting_optimization.ini")
			if File.exists?(file_name)==true then 	#File exist
				file = File.open(file_name, "r")
				while !file.eof?
					option_name=file.readline.gsub(10.chr,"").gsub(13.chr,"")
					option_value=file.readline.gsub(10.chr,"").gsub(13.chr,"")

					@option_use_smallest_tubes=(option_value=="true") ? true : false if option_name=="option_use_smallest_tubes"
					@option_check_for_updates=(option_value=="true") ? true : false if option_name=="option_check_for_updates"
					@option_change_language=(option_value=="true") ? true : false if option_name=="option_change_language"
					@option_language=option_value if option_name=="option_language"
					@option_prompt_my_language_added=(option_value=="true") ? true : false if option_name=="option_prompt_my_language_added"
					@option_usage=option_value.to_i if option_name=="option_usage"
				end
				file.close
			else												#File doesn't exist
				#Save Default options
				save_options
			end
		end
		def self.load_default_options	#Default options
			@option_use_smallest_tubes=true
			@option_check_for_updates=true
			@option_change_language=false
			@option_language=Sketchup.os_language
			@option_prompt_my_language_added=false
			@option_usage=0
		end
		def self.load_options_in_html
			# On met les cases à cocher
				js= "document.getElementById('cb1').checked="+((@option_use_smallest_tubes==true) ? "true" : "false")+";"
				js+="document.getElementById('cb2').checked="+((@option_check_for_updates==true) ? "true" : "false")+";"
				js+="document.getElementById('cb3').checked="+((@option_change_language==true) ? "true" : "false")+";"
			#On ajoute les langues possibles en traductions
				js+= "liste=document.getElementById('languages');"
				js+= "liste.length=0;"
				for i in 0..@availableLanguages.length-1
					js+= "liste.options[liste.length] = new Option('"+@availableLanguagesName[i].to_s+"', '"+@availableLanguages[i].to_s+"');"+13.chr
				end
				js+="liste.value='"+@option_language+"';" if @availableLanguages.index(@option_language)!=nil
				js+="document.getElementById('languages').disabled="+((@option_change_language!=true) ? "true" : "false")+";"
			#On éxécute la requête
				@my_dialog.execute_script(js)
		end
		def self.swap_option(option)
			@option_use_smallest_tubes=!(@option_use_smallest_tubes) if option[0].to_s=="1"
			@option_check_for_updates=!(@option_check_for_updates) if option[0].to_s=="2"
			@option_change_language=!(@option_change_language) if option[0].to_s=="3"
			js="document.getElementById('languages').disabled="+((@option_change_language!=true) ? "true" : "false")+";"
			@my_dialog.execute_script(js)
			self.save_options
		end
		def self.translations_HTML
			js=""
			#Pour les textes
				for i in 0..@translated_texts.length-1
					js+="document.getElementById('txt"+i.to_s+"').innerHTML='"+bgSketchup_to_java(@translated_texts[i])+"';"+13.chr
				end
				
			#Pour les aides contextuelles
				for i in 0..@translated_titles.length-1
					js+="document.getElementById('tlt"+i.to_s+"').title='"+bgSketchup_to_java(@translated_titles[i])+"';"+13.chr
				end
			@my_dialog.execute_script(js)
		end
		def self.change_language(language)
			if @option_change_language==true then
				@option_language=language[0]
				self.save_options
				@my_dialog.execute_script("window.location.reload()")
			end
		end
		
		#UPDATES
		def self.check_for_updates(kind_of_control) #kind_of_control='prompt' or 'check'
			if @option_check_for_updates==true then#Check for update and display a message if required
				@my_dialog.execute_script("check_version('"+BGSketchup_Tube_cutting_optimisation_extension.version+"','"+kind_of_control+"');")
			else
				@my_dialog.execute_script("document.getElementById('Update').style.display='none';")
			end
		end
		
		#STATISTIQUES
		def self.stats_incrementer_compteur
			#On envoie les données
				bgSketchup_add_stats(@my_dialog, BGSketchup_Tube_cutting_optimisation_extension, [bgSketchup_Temp_folder_is_plugin_folder?,@option_usage.to_s ])
		end
		
		####################################################################################
		
		# OUTIL DE SELECTION DU COMPOSANT
			class Selection_composant 							# L'outil de sélection
				def initialize
					@obj=[]
					@ip = Sketchup::InputPoint.new
					@ip1 = Sketchup::InputPoint.new
					@obj.clear
					reset
					Sketchup.active_model.selection.clear
				end
				def reset
					@obj.clear
					@ip1.clear
					@drawn = false
				end                   
				def quitter
					BGSketchup_Tube_cutting_optimization::BGSketchup_Optimisation_Decoupe.set_statusbar("")
					Sketchup.active_model.select_tool nil
				end
				def activate; self.reset; end                    
				def deactivate(view); view.invalidate; end

				def onLButtonDown(flags, x, y, view)
					@ip.pick view,x,y;
					ph = view.pick_helper; ph.do_pick x,y; best=ph.best_picked

					if best!=nil then
						if best.is_a? Sketchup::ComponentInstance then
							Sketchup.active_model.selection.add best
							BGSketchup_Tube_cutting_optimization::BGSketchup_Optimisation_Decoupe.definir_le_composant(best)
							self.quitter
						else
							BGSketchup_Tube_cutting_optimization::BGSketchup_Optimisation_Decoupe.set_statusbar(@translation_not_component)
						end
					end                               
					view.refresh
				end
				def onKeyDown(key, rpt, flags, view)
					self.quitter if key==13
					self.quitter if key==27
				end
				def onCancel(flag, view); view.invalidate; self.quitter;end               
				def draw(view)
				  @drawn = false 
				end
			end # class Selection_composant
			def self.select_component 							# Active l'outil de sélection du composant (activé par la page HTML)
				outil=Selection_composant.new
				BGSketchup_Tube_cutting_optimization::BGSketchup_Optimisation_Decoupe.set_statusbar(@translation_selec_in_model)
				Sketchup.active_model.select_tool(outil)		
			end
			def self.definir_le_composant(composantInstance) 	# Définit le nouveau composant en référence (activé par l'outil)
				@composant_selectionne=composantInstance
				@vecteur_selectionne=nil
				
				#Try to define components axis vector.
				axe=[]
				axe[0]=Geom::Vector3d.new(1,0,0)
				axe[1]=Geom::Vector3d.new(0,1,0)
				axe[2]=Geom::Vector3d.new(0,0,1)
				
				for i in 0..2
					axe[i].transform! @composant_selectionne.transformation
				end
				
				if axe[0].length!=1 then
					@vecteur_selectionne=Geom::Vector3d.new(1,0,0)
					v=@vecteur_selectionne.clone
					v.length=@composant_selectionne.definition.bounds.width
					v.transform! @composant_selectionne.transformation
					@ratio=(v.length)/axe[0].length
				elsif axe[1].length!=1 then
					@vecteur_selectionne=Geom::Vector3d.new(0,1,0)
					v=@vecteur_selectionne.clone
					v.length=@composant_selectionne.definition.bounds.height
					v.transform! @composant_selectionne.transformation
					@ratio=(v.length)/axe[1].length
				elsif axe[2].length!=1 then
					@vecteur_selectionne=Geom::Vector3d.new(0,0,1)
					v=@vecteur_selectionne.clone
					v.length=@composant_selectionne.definition.bounds.depth
					v.transform! @composant_selectionne.transformation
					@ratio=(v.length)/axe[2].length
				else
					#No axe increased (instance=definition in terms of scale)
					#Vector is biggest dimension of original bounds
					bbox=@composant_selectionne.definition.bounds				
					
					axeXrouge=bbox.width
					axeYvert=bbox.height
					axeZbleu=bbox.depth
					vecteur=Geom::Vector3d.new(0,0,0)
					if (bbox.width>bbox.height && bbox.width>bbox.depth) then
						@vecteur_selectionne=Geom::Vector3d.new(1,0,0)
						@ratio=(bbox.width)/1
					elsif (bbox.height>bbox.width && bbox.height>bbox.depth) then
						@vecteur_selectionne=Geom::Vector3d.new(0,1,0) 
						@ratio=(bbox.height)/1
					elsif (bbox.depth>bbox.width && bbox.depth>bbox.height) then
						@vecteur_selectionne=Geom::Vector3d.new(0,0,1)
						@ratio=(bbox.depth)/1
					else #it's a cube !
						@ratio=nil
					end
				end
				self.verifie_vecteur_defini_html
				self.clear_table_bom_in_html
				self.clear_table_optimisation_in_html
			end
			
		# OUTIL DE DEFINITION DU VECTEUR
			class Selection_vecteur 							# L'outil de sélection des points du vecteur
				def initialize		
					@ip = Sketchup::InputPoint.new
					@ip1 = Sketchup::InputPoint.new
					@ip2 = Sketchup::InputPoint.new
					reset
				end
				def reset
					@pts = []
					@state = 0
					@ip1.clear
					@ip2.clear
					@drawn = false
				end
				def activate; self.reset; end                    
				def deactivate(view); view.invalidate if @drawn; end
				def set_current_point(x, y, view)      
					return false if( !@ip.pick(view, x, y, @ip1) )
					need_draw = @ip.display? || @drawn
					view.invalidate if need_draw
					if( @state == 1 )
						# just draw a line from the start to the end point
						view.set_color_from_line(@ip1, @ip)
						inference_locked = view.inference_locked?
						view.line_width = 3 if inference_locked
						view.draw(GL_LINE_STRIP, @pts[0], @pts[1])
						view.line_width = 1 if inference_locked
						@drawn = true
					end
				end
				def onMouseMove(flags, x, y, view)
					self.set_current_point(x, y, view)
				end
				def quitter
					BGSketchup::BGSketchup_Optimisation_Decoupe.set_statusbar("")
					Sketchup.active_model.select_tool nil
				end
				def increment_state
					@state += 1
					case @state
						when 1
							@ip1.copy! @ip
						when 2
							@ip2.copy! @ip
							BGSketchup::BGSketchup_Optimisation_Decoupe.definir_vecteur(@ip2.position-@ip1.position)
							self.quitter
					end
				end
				def onLButtonDown(flags, x, y, view)
					self.set_current_point(x, y, view)
					view.lock_inference
					self.increment_state
				end
				def onKeyDown(key, rpt, flags, view)
					self.quitter if key==27
				end
				def onCancel(flag, view); view.invalidate; self.quitter; end
				def draw(view)
				  @drawn = false      
				  # Show the current input point
					if( @ip.valid? && @ip.display? )
						@ip.draw(view)
						@drawn = true
					end
				end
			end # class Selection_vecteur
			def self.select_vector 								# Active l'outil de sélection du vecteur (activé par la page HTML)
				outil=Selection_vecteur.new
				self.set_statusbar(@translation_selecion_vecteur)
				Sketchup.active_model.select_tool(outil)		
			end
			def self.definir_vecteur(vecteur)					# Définit le nouveau vecteur (activé par l'outil)
				@vecteur_selectionne=vecteur.clone
				@vecteur_selectionne.transform! @composant_selectionne.transformation.inverse
				@vecteur_selectionne.normalize!
				#Si on change le vecteur, il faut recalculer le ratio pour la taille
				#Le composant sélectionné à peut-être déjà subi une transformation
				#On utilise le vecteur, on lui applique la transformation
					#On prend un vecteur
						axec=@vecteur_selectionne.clone
					#On lui applique la même transformation que l'instance
						axec.transform! @composant_selectionne.transformation
					#Sa nouvelle longueur nous donne l'agrandissement
						@ratio=vecteur.length/axec.length
				
				self.verifie_vecteur_defini_html
				self.clear_table_bom_in_html
				self.clear_table_optimisation_in_html
			end
		
		#MENU ET GESTION AFFICHAGE
			def self.set_statusbar(text)
				js="document.getElementById('barre_etat').innerHTML='"+bgSketchup_to_java(text)+"';"
				@my_dialog.execute_script(js)		
			end
			def self.creation_menus			#Add Plugins menu and toolbar
				#Add menu
					menu=BGSketchup_Ajouter_Submenu("BGSketchup")
					menu.add_item(@translated_texts[8]) { self.show_hide_window }
				#Add toolbar
					bgSketchup_creer_toolbar(@translated_texts[8],"BGSketchup_Tube_cutting_optimization::BGSketchup_Optimisation_Decoupe.show_hide_window","BGSketchup_Tube_cutting_optimisation/Html/Icon3.png","BGSketchup_Tube_cutting_optimisation/Html/Icon3.png",@translated_texts[8],@translated_texts[8],@translated_texts[8])
			end

		unless file_loaded?( __FILE__ )
			initialise_localization(false)
			if !File.exists?(File.join(File.dirname(__FILE__), "..", 'BGSketchup_Library.rb')) then
				reponse=UI.messagebox(@translation_library_no_found+@translation_open_link,MB_YESNO)
				if reponse==IDYES then
					status = UI.openURL("http://sketchucation.com/pluginstore?pln=BGSketchup_Library")
				end
			else
				Sketchup::require 'BGSketchup_Library'
				extend BGSketchup_Library
				if bgSketchup_version_library>=Required_library_version then
					self.load_options
					initialise_localization(false)
					self.creation_menus
					if File.exists?(File.join(bgSketchup_getTempFolder,"Debug.bg"))
						Sketchup.send_action(CMD_RUBY_CONSOLE) 
						#self.show_hide_window
					end
				else
					self.load_options
					initialise_localization(false)
					txt=@translation_library_not_good_version+10.chr
					txt+="(Required : "+bgSketchup_version_library_string(Required_library_version)+", current : "+bgSketchup_version_library_string(nil)+")"+10.chr
					txt+=@translation_open_link
					reponse=UI.messagebox(txt,MB_YESNO)
					if reponse==IDYES then
						status = UI.openURL("http://sketchucation.com/pluginstore?pln=BGSketchup_Library")
					end
				end
			end
		end
	end #class BGSketchup_Optimisation_Decoupe
	BGSketchup_Optimisation_Decoupe.new
	
end #module BGSketchup