# Localization file for BGSketchup_Tube_cutting_optimization plugin

module BGSketchup_Tube_cutting_optimization
	def initialise_localization(prompt=true)
		@availableLanguages=["en","fr"]#,"pt","es","ru"]
		@availableLanguagesName=["English","Français"]#,"Português","Español","Russian"]
		@option_language="en" if @availableLanguages.index(@option_language)==nil	
		
		#Ask to change translation if system language has been added
		if ((prompt) && (!@option_prompt_my_language_added) && (@option_language!=Sketchup.os_language) && (@availableLanguages.index(@option_language)!=nil)) then
			reponse=UI.messagebox("Your system language translation exists for this plugin, do you want to use it ?", MB_YESNO)
			if reponse== IDYES then
				@option_language=Sketchup.os_language
				self.load_options_in_html
			end
			@option_prompt_my_language_added=true
		end
		
		# Load default text in English in case a translation is missing
		
		#ENGLISH
			@translated_texts=[
				"Parameters",
				"Look into",
				"all model",
				"selected entities",
				"Part list",
				"Calculate / Refresh",
				"Quantity",
				"Length",
				"Cut optimization",
				"Tube length :",
				"Waste allowed :",
				"Cut width :",
				"Number",
				"Lengths",
				"Loss",
				"Options",
				"Choose shortest tubes first for optimization",
				"Check for updates on startup",
				"Change language to ",
				"A newer version of the plugin is avalaible !",
				"Click here to go to sketchUcation"
			]
			@translated_titles=[
				"Not all parameters defined",
				"Select component directly in model",
				"Change profile's axe",
				"Calculate / Refresh",
				"About...",
				"Open help file"
			]
			
			@translation_vector_defined="Vector defined."
			@translation_vector_not_defined="Vector not defined ! Click on button to define."
			@translation_component_selected="Component selected"
			@translation_component_not_selected="Component not selected ! Click on button to define."
			@translation_unscaled_length="Unscaled length"
			@translation_export_csv="Export in a CSV file"
			@translation_quantity="Quantity ="
			@translation_loss="Loss ="
			@translation_error_tube_length="Error : one of the tube is longer than authorized length"
			@translation_calculation_too_long="Looks like calculation takes long time... Do you want to abort ?"+13.chr+10.chr+"Click Cancel if you want to continue without this message appearing again in 30 seconds."
			@translation_tube_missing="Error in optimization of cut : not enought uncut tubes !"
			@translation_selec_in_model="Select the component directly in the model"
			@translation_not_component="This is not a component !"
			@translation_selecion_vecteur="Select 2 points at extremity of the component (Escape=cancel)"
			@translation_different_length="To use different size, split them with '/' symbol"
			@translation_library_no_found="Error, BGSketchup_Library extension not found. Please download it from store."
			@translation_library_not_good_version="The extension BGSketchup Library version is too old, please download the latest version on sketchUcation.com"
			@translation_open_link="Do you want to open link to download it ?"

		
		#FRENCH
			if @option_language=="fr" then
				@translated_texts=[
					"Paramètres",
					"Regarder dans",
					"tout le dessin",
					"objets sélectionnés",
					"Nomenclature",
					"Calculer / Rafraîchir",
					"Quantité",
					"Longueur",
					"Optimisation de découpe",
					"Longueur intiale :",
					"Chute admissible :",
					"Perte à la coupe :",
					"Numéro",
					"Longueurs",
					"Chute",
					"Options",
					"Choisir d'abord les longueurs les plus petites pour l'optimisation",
					"Vérifier les mises à jour au démarrage",
					"Changer la langue vers : ",
					"Une version plus récente du plugin est disponible !",
					"Cliquer ici pour aller sur le site de sketchUcation"
				]
				@translated_titles=[
					"Tous les paramètres ne sont pas définis",
					"Sélectionne le composant directement dans le dessin",
					"Change l'axe du composant",
					"Calculer / Rafraîchir",
					"A propos...",
					"Ouvrir le fichier d'aide"
				]
			
				@translation_vector_defined="Vecteur défini."
				@translation_vector_not_defined="Vecteur non défini ! Cliquer sur le bouton pour le définir."
				@translation_component_selected="Composant sélectionné"
				@translation_component_not_selected="Composant non sélectionné : cliquer le bouton pour le définir."
				@translation_unscaled_length="Longeur intiale"
				@translation_export_csv="Exporter dans un fichier CSV"
				@translation_quantity="Quantité ="
				@translation_loss="Chute ="
				@translation_error_tube_length="Erreur : une des longueurs est plus  grande que les longueurs non découpées"
				@translation_calculation_too_long="Il semblerai que le calcul dure longtemps... Voulez-vous annuler ?"+13.chr+10.chr+"Appuyer sur annuler si vous ne voulez continuer sans que ce message n'apparraisse dans 30 secondes."
				@translation_tube_missing="Erreur dans l'optimisation : il n'y a pas assez de longueurs non découpées !"
				@translation_selec_in_model="Selectionner le composant dans le dessin"
				@translation_not_component="Ce n'est pas un composant !"
				@translation_selecion_vecteur="Selectionner 2 points à l'extrémité du composant (Esc=annuler)"
				@translation_different_length="Séparez les différentes longueurs avec un '/'"
				@translation_library_no_found="Erreur, l'extension BGSketchup_Library non trouvée. Merci de la télécharger."
				@translation_library_not_good_version="La version de l'extension BGSketchup Library version est trop ancienne, merci de télécharger la dernière sur sketchUcation.com"
				@translation_open_link="Voulez-vous ouvrir le lien pour la télécharger ?"

			end
	end
end