<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html>
	<head>
		<META content="IE=11.0000" http-equiv="X-UA-Compatible"> <!-- MUST BE FIRST LINE OF THE <head> !!!!  -->   
		<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<script type="text/javascript" src="http://bgsketchup.esy.es/Versions.js"></script>
		
		<script> <!-- Javascript error management -->
			window.onerror = function(message, url, linenumber) {
				message=message.split(";").join("coma point");
				message=message.split("'").join("");
				callRuby("bgSketchup_erreur_script("+message+";"+linenumber+";"+url+";"+plugin_version+")");
			}
		</script>
		<link rel="stylesheet" href="Tube_Main.css" />
	</head>
	<script>
		function callRuby(actionName) {
			query = 'skp:get_data@' + actionName;
			window.location.href = query;
		}
		
		//Swap functions
		function swap_flap(flap) {
			if (document.getElementById('flap'+flap).style.display=='none') {
				document.getElementById('flap'+flap).style.display='inline';
				document.getElementById('triangleup'+flap).style.display='inline';
				document.getElementById('triangledo'+flap).style.display='none';
			} else {
				document.getElementById('flap'+flap).style.display='none';
				document.getElementById('triangleup'+flap).style.display='none';
				document.getElementById('triangledo'+flap).style.display='inline';
			}
		}
		function hide_flap_2_3() {
			for (flap=2; flap<5; flap++) {
				document.getElementById('flap'+flap).style.display='none';
				document.getElementById('triangleup'+flap).style.display='none';
				document.getElementById('triangledo'+flap).style.display='inline';
			}
		};
		function show_flap_2_3() {
			for (flap=2; flap<4; flap++) {
				document.getElementById('flap'+flap).style.display='inline';
				document.getElementById('triangleup'+flap).style.display='inline';
				document.getElementById('triangledo'+flap).style.display='none';
			}
		};
		function swap_rd(rd) {
			if (rd==1) {
				document.getElementById('rd2').checked= !(document.getElementById('rd1').checked);
			} else {
				document.getElementById('rd1').checked= !(document.getElementById('rd2').checked);
			}
			clear_table_bom_in_html();
			clear_table_optimisation_in_html();
		}
		function clear_table_optimisation_in_html() {
			table=document.getElementById('table3'); while(table.rows.length>3) { table.deleteRow(-1); };
		}
		function clear_table_bom_in_html() {
			table=document.getElementById('table2'); while(table.rows.length>2) { table.deleteRow(-1); };
		}
		function optimisation() {
			var lgr=longueur.value.replace("'","#").replace('"',"|");
			var chu=chute.value.replace("'","#").replace('"',"|");
			var cut=cut_width.value.replace("'","#").replace('"',"|");
			if (document.getElementById('rd1').checked==true) {
				var region="model"
			} else {
				var region="selection"
			};
			callRuby('optimisation('+lgr+';'+chu+';'+cut+';'+region+')');
		}
		function maj_BOM() {
			if (document.getElementById('rd1').checked==true) {
				var region="model"
			} else {
				var region="selection"
			};
			callRuby('bom('+region+')');
		}
		
		//Export buttons
		function exportBOMCSV() { callRuby('exportBOMCSV'); }
		function exportOptiCSV() { callRuby('exportOptiCSV'); }		
		
		//Status bar
		function tube_length_blur() {
			document.getElementById('barre_etat').innerHTML=""
		}
		
		//Updates
		function check_version(current_plugin_version,kind_of_control){
			try {
				var v=bgsketchup_plugins_version("Cut_optimization");  //Javascript function to get version
				var version_web=v[0].substr(1).split(".");
				var version_skp=current_plugin_version.substr(1).split(".");
				version_web= 10000*parseInt(version_web[0])+100*parseInt(version_web[1])+parseInt(version_web[2])
				version_skp= 10000*parseInt(version_skp[0])+100*parseInt(version_skp[1])+parseInt(version_skp[2])
				
				if (kind_of_control=="prompt") {
					if (version_web==version_skp) { callRuby("prompt_update_check(equal;NA)"); }
					if (version_web>version_skp) { callRuby("prompt_update_check(different;"+v[1]+")"); }
				} else {
					if (version_web>version_skp) { 
						document.getElementById('Update').style.display='block';
					} else {
						document.getElementById('Update').style.display='none';
					}
				}
			}
			catch(err) { //If not connect to the Web
				if (kind_of_control=="prompt") { callRuby("prompt_update_check(NA; NA)"); }
			}
		}
		
		//Options
		function change_language(){
			callRuby('change_language('+document.getElementById('languages').value+')')
		}
		
	</script>
	<body>
		<div id="flap_system" width=100%>
			<button onclick="swap_flap('1');" class="titre">
				<span id="txt0">Parameters</span>
				<img id="triangleup1" src="triangle_up.png" class="triangle"/>
				<img id="triangledo1" src="triangle_down.png" class="triangle" style="display:none;"/>
				<img src="Warning.png" id="tlt0" class="warning_icon" style="display:inline;" title="Not all parameters defined"/>
			</button>
			<span id="flap1">
				<table id="table1" width=100%>
					<TR>
						<!-- Select component button -->
						<TD width=60px><button class="btn" onclick="callRuby('select_component');" id="tlt1"><img id="img_profile" class="img_btn" src="Icon2.png"/></button></TD>
						<!-- Component's name area -->
						<TD><span id="component"></span></TD>
					</TR>
					<TR>
						<!-- Select vector button -->	
						<TD width=60px><button class="btn" onclick="callRuby('select_vector');" id="tlt2"><img id="img_vector" class="img_btn" src="Vector.png"/></button></TD>
						<!-- Vector definition -->
						<TD><span id="vector"></span></TD>
					</TR>
					<TR>
						<TD colspan=2><span id="txt1">Look into </span> :<input class="rd" id="rd1" type="radio" checked="true" onclick="swap_rd(1);">&nbsp<span id="txt2">all model</span></input><input class="rd" id="rd2" type="radio" onclick="swap_rd(2);">&nbsp<span id="txt3">selected entities</span></input></TD>
					</TR>
				</table>
			</span>
			&nbsp <BR>
			
			<button onclick="swap_flap('2');" class="titre"><span id="txt4">Part list</span><img id="triangleup2" src="triangle_up.png" class="triangle"/><img id="triangledo2" src="triangle_down.png" class="triangle" style="display:none;"/></button>
			<span id="flap2">
				<table id="table2" class="bom" width=100%>
					<TR>
						<TD colspan=2><button onclick="maj_BOM();"><span id="txt5">Calculate / Refresh</span></button></TD>
					</TR>
					<TR>
						<TD width=20%><B><span id="txt6">Quantity</span></B></TD><TD width=80%><B><span id="txt7">Length</span></B></TD>
					</TR>
				</table>
			</span>
			&nbsp <BR>
			
			<button onclick="swap_flap('3');" class="titre"><span id="txt8">Cut optimization</span><img id="triangleup3" src="triangle_up.png" class="triangle"/><img id="triangledo3" src="triangle_down.png" class="triangle" style="display:none;"/></button>
			<span id="flap3">
				<table id="table3" class="bom" width=100%>		
					<TR>
						<TD colspan=3 >
							<span id="txt9">Tube length :</span>&nbsp <input name="longueur" style="width:200px" onfocus="callRuby('tube_length_focus');" onblur="tube_length_blur();"/>
						</TD>
					</TR>
					<TR>
						<TD colspan=2 style="text-align:right">
							<span id="txt10">Waste allowed :</span>&nbsp <input name="chute" style="width:90px"/><BR>
							<span id="txt11">Cut width :</span>&nbsp <input name="cut_width" style="width:90px"/>
						</TD>
						<TD colspan=1>
							<button onclick="optimisation();" style="font-size:10pt" id="tlt3"><img src="Refresh.png"/></button> 
						</TD>
					</TR>
					<TR>
						<TD width=10%><B><span id="txt12">Number</span></B></TD>
						<TD width=60%><B><span id="txt13">Lengths</span></B></TD>
						<TD width=30%><B><span id="txt14">Loss</span></B></TD>
					</TR>
				</table>
			</span>
			&nbsp <BR>
			
			<button onclick="swap_flap('4');" class="titre"><span id="txt15">Options</span><img id="triangleup4" src="triangle_up.png" class="triangle"/><img id="triangledo4" src="triangle_down.png" class="triangle" style="display:none;"/></button>
			<span id="flap4" width=100%>
				<input id="cb1" type="checkbox" onclick="callRuby('swap_option(1)');"/><span id="txt16">Choose shortest tubes first for optimization</span><BR>
				<input id="cb2" type="checkbox" onclick="callRuby('swap_option(2)');"/><span id="txt17">Check for updates on startup</span><BR>
				<input id="cb3" type="checkbox" onclick="callRuby('swap_option(3)');"/><span id="txt18">Change language to</span><select id="languages" class="langue" onchange="change_language();"></select>
			</span>
			<BR>
		</div>
		
		<div class="barre_etat">
			<span id="barre_etat"></span>
			<img onclick="callRuby('About');" id="tlt4" src="About.png" class="triangle"/>
			<a id="tlt5" href="../Help/Tube_cutting_optimization.pdf" target=_blank><img  src="Help.png" class="triangle"/></a>
		</div>
		
		<div id="Update" style="display:block;">
			<center>
				<B><span id="update_text"><span id="txt19">A newer version of the plugin is avalaible !</span></span></B><BR><BR>
				<a href="http://sketchucation.com/plugin/1072-tube_cutting_optimisation" target="_blank"><span id="txt20">Click here to go to sketchUcation</span></a><BR><BR>
				<button onclick="document.getElementById('Update').style.display='none';">Ok</button>
			</center>
		</div>
		<script>
			/* Launch Sketchup scripts */
				callRuby('start');
		</script>
	</body>
</html>