# Plugin "Tube cutting optimization" created by BGSketchup
#
# Permission to use, copy, modify, and distribute this software for any purpose, and currently without fee, is hereby granted, 
# provided that this text and the above copyright (c) notice appear in all copies.
# This software is provided "as is" and without any express or implied warranties, including, without limitation, the implied 
# warranties of merchantability and fitness for a particular purpose.

module BGSketchup_Tube_cutting_optimization
	#Required libraries
		require "sketchup.rb"
		require "extensions.rb"
		
	#Extension data
		BGSketchup_Tube_cutting_optimisation_extension = SketchupExtension.new 'BGSketchup_Tube_cutting_optimisation', 'BGSketchup_Tube_cutting_optimisation/Tube_Main'
		BGSketchup_Tube_cutting_optimisation_extension.version = 'v1.7.2'
		BGSketchup_Tube_cutting_optimisation_extension.copyright = 'BGSketchup, November 2014'
		BGSketchup_Tube_cutting_optimisation_extension.creator = 'BGSketchup'
		BGSketchup_Tube_cutting_optimisation_extension.description = 'Optimize tube cutting'
		Required_library_version=2*10000+5*100+6
		Sketchup.register_extension BGSketchup_Tube_cutting_optimisation_extension, true
end

=begin

Version history:
	1.7.2	Corrected : BGSketchup Library not found if not in standard plugin folder
			REQUIRE BGSketchup_Library 2.5.6
	
	1.7.1	OPTIMIZED :	Optimized for new BGSketchup Library : link to download it if missing
			This version require BGSketchup_Library 2.0.5
			
	1.7.0	ADDED :		Group toolbar with other BGSketchup_plugins
			ADDED :		ini folder now added as statistics.
			This version require BGSketchup_Library 1.4.0
			
	1.6.3	CORRECTED :	Fix issue for stopping the calculation
	
	1.6.2	OPTIMIZED :	Simplify some codes (HTML and ruby)
			OPTIMZED :	Update link is now the PluginStore
			
	1.6.1	CORRECTED :	Prevent error when calculation is on selected entities
			CORRECTED :	Design issue on update splash screen
			CORRECTED :	Little issue in stats system
	
	1.6.0	ADDED :		Translation in French. Other translation can be proposed by used in translating file BGSketchup/Tube_cutting_optimisation/Rb/Localization.rb
			ADDED :		Link to help file in status bar
			ADDED :		Help file directly into the plugin rbz file
			CORRECTED :	"Check for update option" didn't work, now solve
			OPTIMIZED :	Optimized scripts for statistics
	
	1.5.0	ADDED :		Allows to list components only in entities selected in model
			ADDED :		Unscaled length of component information added as per JClement request.
			ADDED :		Ask to stop calculation if too long (30sec)
			ADDED :		Check for updates on startup (with option to disable this function)
			ADDED :		Statistics following : IP as user indentifier, date, language, SU version, plugin version, sketchup licence, computer platform. Database can be seen on http://bgsketchup.esy.es/index_tube_cutting_optimization.php
			OPTIMIZED :	Export of part list and optimisation list are now proposed to be saved in model's folder.
			CORRECTED :	Part list and optimization list now fit window width
			CORRECTED :	Some webdialog design optimizations
			CORRECTED :	Prevent from error when not selecting a component in the model
	
	1.4.0	ADDED :		Allow possibility to have mutli-size of tube for cut optimization
			ADDED :		For multi tube cutting : plugin ask if priority is to cut the smallest non-cut tubes
			ADDED :		Options management (For multi tube cutting)
			ADDED :		Very little help adding in status bar when entering tube length
			CORRECTED :	Fix a bug when uncut tube are longer than all tubes to be cut
			CORRECTED :	Unit error in part list CSV export
			OPTIMIZED :	Change interface icons & colors
	
	1.3.0	ADDED :		Cut width taken into account
			CORRECTED :	Errors with inches unit in optimisation. Now user can enter " or ' in tubes' length or loss or cut
			CORRECTED :	Scan also groups and other components entities
			CORRECTED :	Javascript errors make a bugsplat screen appear
			CORRECTED :	Avoid bug with components names

	1.2.1	CORRECTED :	Avoid issue with model with inches unit
	
	1.2.0	ADDED :		Try to find automatically the vector for the component
			CORRECTED : Avoid to auto-open the window at SU launch
			CORRECTED : Prevent having same tube length in list by rounding length before building summary.
			CORRECTED : Prevent bug when introduce length with point separator instaed of comma
			
	1.1.1 :	CORRECTED :	Bug with tube sizes.
			OPTIMIZED :	Now use model unit to show size

	1.1.0 :	ADDED :		Export in CSV format
			OPTIMIZED :	Changed round function to psrintf to maximize compatibility with SU 8

	1.0.0: Initial release
	
=end