﻿--[[

	文件名:
		scripts/config/editor/default_keymap.lua
	说明:
		编辑器默认快捷键生成文件

--]]

local default_keymap = [[
--[[

	文件名:
		scripts/config/editor/keymap.lua
	说明:
		编辑器快捷键映射配置文件
		此文件为测试功能，接口可能在将来的版本做较大修整
		
		
	可以使用的自定义全局函数列表:
	
		函数 msgbox(text)
			弹出一个显示有 (@参数 text - 文本型) 提示窗
			
		函数 writePasteboard(text)
			将 (@参数 text - 文本型) 写入系统剪贴板
			
		函数 readPasteboard()
			读取系统剪贴板内容
			@返回值: 文本型|nil - 当系统剪贴板中有文本之时，返回文本，否则返回 nil
			
		函数 inputBox([default, title])
			弹出一个输入提示窗，阻塞并返回
			@参数 default : 文本型 - 为文本框中默认存在的文本
			@参数 title : 文本型 - 为弹出窗口的标题
			@返回值: 文本型 - 最终的文本框中的文本内容
			
		函数 actionSheet([list])
			弹出一个选择表，阻塞并返回
			@参数 list : 表型 - 为一个顺序表，表中值类型为文本
			@返回值: 数值型 - 返回被用户选择的那个项的顺序编号

		函数 setSelectionStart(pos)
			设置框选开始的位置
			@参数 pos : 数值型 - 位置
	
	
		函数 setSelectionEnd(pos)
			设置框选结束的位置
			@参数 pos : 数值型 - 位置
	
	
		函数 setEmptySelection()
			清空框选
	
	
		函数 selectAll()
			文档全选
	
	
		函数 clearAll()
			文档内容清空
	
	
		函数 lineFromPosition(pos)
			获取位置所在行
			@参数 pos : 数值型 - 位置
			@返回值: 数值型 - 位置所在行（文档第一行为 0）
	
	
		函数 positionFromLine(line)
		函数 getLineStartPosition(line)
			获取某行开始的位置
			@参数 line : 数值型 - 行号
			@返回值: 数值型 - 行开始的位置
	
	
		函数 getLineEndPosition(line)
			获取某行末尾的位置
			@参数 line : 数值型 - 行号
			@返回值: 数值型 - 行开始的位置
	
	
		函数 getLineLength(line)
			获取某行的长度
			@参数 line : 数值型 - 行号
			@返回值: 数值型 - 行的字节数
	
	
		函数 getSelectionStart()
			获取框选开始的位置
			@返回值: 数值型 - 框选开始的位置
	
	
		函数 getSelectionStart()
			获取框选结束的位置
			@返回值: 数值型 - 框选结束的位置
	
	
		函数 getCurrentPos()
			获取当前光标所在位置
			@返回值: 数值型 - 当前光标所在位置
	
	
		函数 getTextInRange(sel_start, sel_end)
			获取范围中的文本
			@参数 sel_start : 数值型 - 开始的位置
			@参数 sel_end : 数值型 - 终止的位置
			@返回值: 文本型 - 位置 sel_start 到 sel_end 之间所有的文本
	
	
		函数 getSelectedText()
			获取框选的所有文本
			@返回值: 文本型 - 框选的开始和结束之间所有的文本
	
	
		函数 replaceSelText(str_rpl)
			替换框选的所有的文本
			@参数 str_rpl : 文本型 - 替换的文本
	
	
		函数 gotoPosition(pos)
			跳转到位置，会清除当前的框选以及影响滚动条
			@参数 pos : 数值型 - 需要跳转到的位置
	
	
		函数 codeFoldToggle()
			代码折叠开关
	
	
		函数 codeFoldContract()
			代码折叠
	
	
		函数 codeFoldExpand()
			代码折叠
	
	
		函数 getFuncList()
			获取词法分析出的当前文件的函数列表
			@返回值: 表型 | nil - 格式如下：
				{
					{位置1, 位置2, 位置3, ...},
					{函数名1, 函数名2, 函数名3, ...},
				}
				 | 假如词法分析尚未完成则返回 nil
	
	
		函数 dialogPickArgs(tab)
			弹出一个参数定义框
			@参数 tab : 表型 - 格式如下:
				{
					title = 窗口标题,
					caption = {表头键名, 表头值名},
					args = {
						{参数1名, 参数1默认值},
						{参数2名, 参数2默认值},
						{参数3名, 参数3默认值},
						{参数4名, 参数4默认值},
						...
					},
				}
			@返回值: 表型 - 格式如下:
				{
					参数1值,
					参数2值,
					参数3值,
					参数4值,
					...
				}
		
	
		函数 actionSheet(sheet[, align, title])
			弹出一个选择表
			@参数 sheet : 表型 - 格式如下:
				{
					第 1 项,
					第 2 项,
					第 3 项,
					第 4 项,
					...
				}
			@参数 align : 数值型 - 文本对齐方式 0为左对齐 1为右对齐 2为文本居中
			@参数 title : 文本型 - 窗口标题
			@返回值: 数值型 - 选择的项编号，从 1 开始，0 为未选择
			
--]].."]]"..[[

require("scripts.config.editor.things")

local VK = require("scripts.config.virtual_keycodes")

-- 直接按键
local SK_PRESS_ = {
}


-- Shift + 按键
local SK_SHIFT_ = {

}


-- Ctrl + 按键
local SK_CTRL_ = {

}


-- Alt + 按键
local SK_ALT_ = {
	[ VK["{D}"] ] = function()
		codeFoldToggle()
	end,
	[ VK["{F}"] ] = function()
		funcListPopup()
	end,
}


-- Ctrl + Shift + 按键
local SK_CTRL_SHIFT_ = {
	
}


-- Ctrl + Alt + 按键
local SK_CTRL_ALT_ = {
	
}


-- Alt + Shift + 按键
local SK_ALT_SHIFT_ = {
	
}


-- Ctrl + Alt + Shift + 按键
local SK_CTRL_ALT_SHIFT_ = {
	
}


------------------------------------------------------------------------------
return {
	SK_PRESS_,
	SHIFT = SK_SHIFT_,
	CTRL = SK_CTRL_,
	ALT = SK_ALT_,
	CTRL_SHIFT = SK_CTRL_SHIFT_,
	CTRL_ALT = SK_CTRL_ALT_,
	ALT_SHIFT = SK_ALT_SHIFT_,
	CTRL_ALT_SHIFT = SK_CTRL_ALT_SHIFT_,
}
]]

return require("scripts.lua.tscpbase").loadSettings(
	default_keymap,
	"scripts.config.editor.keymap",
	"keymap",
	"table"
)
