﻿
--[[

格式说明：

{
	下拉选项标题,
	{
		singlePosFormatRule = 单点取色生成格式函数,
		multiPosFormatRule = 多点取色生成格式函数,
		currentPosInfo = 鼠标所指当前点的格式生成函数（面板上那个随着鼠标移动时刻在变化的内容）,
		makeScriptRule = { -- 自定义脚本规则
			生成第 1 个文本框内容的函数,
			生成第 2 个文本框内容的函数,
			生成第 3 个文本框内容的函数,
		},
	},
}


singlePosFormatRule、multiPosFormatRule 参数说明：
	p：		当前点信息，包括 x、y、c、r、g、b、num
	a：		坐标缓冲位 A 的信息，包括 x、y
	s：		坐标缓冲位 S 的信息，包括 x、y
	x：		坐标缓冲位 X 的信息，包括 x、y
	c：		坐标缓冲位 C 的信息，包括 x、y
	set:	扩展设置列表


makeScriptRule 参数说明：
	poslist: {
		p,
		p,
		p,
		...
		a = {x, y},
		s = {x, y},
		x = {x, y},
		c = {x, y},
	}

	set: 扩展设置列表

如需自定义格式，可以复制当前文件的考备份重命名然后做修改
修改完成后，可以在文件 scripts\config\colorpicker\cf_enabled.lua 应用添加自定义格式
--]]

return 
{"简易点阵(快捷键 ~ )",
-- 用 Shift + 鼠标左键 框选区域
-- 使用 ~ 取这个区域中的所有的颜色，与 鼠标所指位置 的颜色进行对比
-- 相似度大于 90 则设置为 1，否则设置为 0
-- 输出到 输出窗口 和 剪贴板
	{
		settingsRule = {
			title = "自定义格式 [简易点阵(快捷键 ~ )] 的参数设置",
			caption = {"参数名", "参数值"},
			args = {
				{"格式1前缀", 		"{#LF#"},
				{"格式1中缀", 		"#T#{ #X#, #Y#, #C#},#LF#"},
				{"格式1分隔符", 	""},
				{"格式1后缀", 		"}"},
			},
		},
		singlePosFormatRule = (function(p, a, s, x, c, set)
			local matrix = capMatrix(a, s, p.c, 90)
			print(matrix)
			return matrix
		end),
		multiPosFormatRule = (function(p, a, s, x, c, set)
			return string.format(" %4d, %4d, 0x%06x \n", p.x, p.y, p.c)
		end),
		currentPosInfo = make_currentPosInfo(" %4d, %4d, 0x%06x "),
		makeScriptRule		= {
			(function(poslist, set)
				return make_old_makeScriptRule(
					set["格式1前缀"],
					set["格式1中缀"],
					set["格式1分隔符"],
					set["格式1后缀"]
				)(poslist)
			end),
			(function(poslist, set)
				-- 取所有颜色与第一点色做对比
				-- 相似度 为 X 缓冲区 的第 1 个值
				-- 横坐标步长为 C 缓冲区的 第 1 个值
				-- 纵坐标步长为 C 缓冲区的 第 2 个值
				if poslist.x.x==0 then
					poslist.x.x = 90
				end
				local matrix = capMatrix(poslist.a, poslist.s, poslist[1].c, poslist.x.x, poslist.c.x, poslist.c.y)
				return matrix
			end),
			make_findMultiColorInRegionFuzzy,
		},
	},
}
