﻿--[[

	文件名:
		scripts/config/colorpicker/customformats.lua
	说明:
		自定义格式主文件
		如果需要自己定义属于自己的格式，这个文件仅作为参考，修改无效
		建议参考 scripts/config/colorpicker/customformats/ 目录下的几个独立自定义格式文件，建立独立的自定义格式

--]]


-- make_FMC 用于生成 findMultiColorInRegionFuzzy 的第 1、2 个参数字符串
function make_FMC(poslist)
	local ret = ""
	local firstPos
	for i,currentPos in ipairs(poslist) do
		if i==1 then
			firstPos = currentPos
			ret = ret..string.format("0x%06x, \"", firstPos.c)
		else
			ret = ret..string.format("%d|%d|0x%06x", currentPos.x - firstPos.x, currentPos.y - firstPos.y, currentPos.c)
			if i~=#poslist then
				ret = ret..","
			end
		end
	end
	return ret..'"'
end

-- make_findMultiColorInRegionFuzzy 用于生成一个完整的 findMultiColorInRegionFuzzy 调用
function make_findMultiColorInRegionFuzzy(poslist)
	return string.format("x,y = findMultiColorInRegionFuzzy( %s, 90, %d, %d, %d, %d)",
															make_FMC(poslist),
															poslist.a.x,
															poslist.a.y,
															poslist.s.x,
															poslist.s.y)
end

-- make_currentPosInfo 用于生成一个 显示当前点信息的通用函数 的函数
function make_currentPosInfo(fmt)
	return function(p, a, s, x, c)
		return string.format("坐标: (%4d, %4d)\r\n颜色值: 0x%06x\r\nRGB值: (%3d, %3d, %3d)\r\n"..fmt, p.x, p.y, p.c, p.r, p.g, p.b, p.x, p.y, p.c)
	end
end

function z_cmpColor(clr1,clr2)
	local abs = math.abs
    local rd = (0xFF-abs((clr1/0x10000)-(clr2/0x10000)))/0xFF
    local gd = (0xFF-abs(((clr1%0x10000)/0x100)-((clr2%0x10000)/0x100)))/0xFF
    local bd = (0xFF-abs((clr1%0x100)-(clr2%0x100)))/0xFF
    return math.ceil(rd*gd*bd*100)
end

function isColor(x,y,c,s)
	local fl,abs = math.floor,math.abs
	s = fl(0xff*(100-s)*0.01)
	local r,g,b = fl(c/0x10000),fl(c%0x10000/0x100),fl(c%0x100)
	local rr,gg,bb = getColorRGB(x,y)
	if abs(r-rr)<s and abs(g-gg)<s and abs(b-bb)<s then
		return true
	end
end

function capMatrix(tl, br, color, csim, xstep, ystep, dot0, dot1)
	dot0 = dot0 or "0"
	dot1 = dot1 or "1"
	xstep = xstep or 1
	if xstep<=0 then
		xstep = 1
	end
	ystep = ystep or 1
	if ystep<=0 then
		ystep = 1
	end
	local ret = ""
	for cy = tl.y, br.y, ystep do
		for cx = tl.x, br.x, xstep do
			if (z_cmpColor(getColor(cx, cy), color)>csim) then
				ret = ret..dot1
			else
				ret = ret..dot0
			end
		end
		ret = ret.."\n"
	end
	return ret
end


--[[
-------------------------------------------------------------------
	旧版兼容格式函数
--]]

function to_old_commonFormat(fmtString, a, s)
	local tos = tostring
	local fmt = string.format
	local ret = fmtString
	ret = ret:gsub( "#SX#", 	fmt("%4d", a.x))
	ret = ret:gsub( "#SY#", 	fmt("%4d", a.y))
	ret = ret:gsub( "#EX#", 	fmt("%4d", s.x))
	ret = ret:gsub( "#EY#", 	fmt("%4d", s.y))
	ret = ret:gsub("#0SX#", 	fmt( "%d", a.x))
	ret = ret:gsub("#0SY#", 	fmt( "%d", a.y))
	ret = ret:gsub("#0EX#", 	fmt( "%d", s.x))
	ret = ret:gsub("#0EY#", 	fmt( "%d", s.y))
	ret = ret:gsub( "#CR#", 	"\r")
	ret = ret:gsub( "#LF#", 	"\n")
	ret = ret:gsub( "#SP#", 	" ")
	ret = ret:gsub(  "#T#", 	"\t")
	return ret
end

function to_old_posFormat(fmtString, p)
	local tos = tostring
	local fmt = string.format
	local ret = fmtString
	ret = ret:gsub(  "#X#", 	fmt("%4d", p.x))
	ret = ret:gsub(  "#Y#", 	fmt("%4d", p.y))
	ret = ret:gsub(  "#R#", 	fmt("%3d", p.r))
	ret = ret:gsub(  "#G#", 	fmt("%3d", p.g))
	ret = ret:gsub(  "#B#", 	fmt("%3d", p.b))
	ret = ret:gsub( "#0X#", 	fmt( "%d", p.x))
	ret = ret:gsub( "#0Y#", 	fmt( "%d", p.y))
	ret = ret:gsub( "#0R#", 	fmt( "%d", p.r))
	ret = ret:gsub( "#0G#", 	fmt( "%d", p.g))
	ret = ret:gsub( "#0B#", 	fmt( "%d", p.b))
	ret = ret:gsub( "#HR#", 	fmt("%02x", p.r))
	ret = ret:gsub( "#HG#", 	fmt("%02x", p.g))
	ret = ret:gsub( "#HB#", 	fmt("%02x", p.b))
	ret = ret:gsub(  "#C#", 	fmt("0x%06x", p.c))
	return ret
end

function make_old_singlePosFormatRule(fmtString)
	return (function(p, a, s, x, c)
		return to_old_posFormat(
			to_old_commonFormat(fmtString, a, s),
			p)
	end)
end

make_old_multiPosFormatRule	= make_old_singlePosFormatRule
make_old_currentPosInfo		= make_old_singlePosFormatRule

function make_old_makeScriptRule(fmtPre, fmtPos, fmtSep, fmtFix)
	return (function(poslist)
		local fmc = make_FMC(poslist)
		local ret = to_old_commonFormat(fmtPre, poslist.a, poslist.s):gsub("#FMC#", fmc)
		local sep = to_old_commonFormat(fmtSep, poslist.a, poslist.s):gsub("#FMC#", fmc)
		local fix = to_old_commonFormat(fmtFix, poslist.a, poslist.s):gsub("#FMC#", fmc)
		for i,currentPos in ipairs(poslist) do
			ret = ret..to_old_posFormat(to_old_commonFormat(fmtPos, poslist.a, poslist.s), currentPos)
			if i~=#poslist then
				ret = ret..sep
			end
		end
		return ret..fix
	end)
end

--[[
	旧版兼容格式函数
-------------------------------------------------------------------
--]]

function eitherOr(set, ret1, ret2)
	local fmt
	if math.abs(tonumber(set) or 0)>0 then
		fmt = ret1
	else
		fmt = ret2
	end
	return fmt
end

function toboolean(set)
	if type(set)=="boolean" then
		return set
	end
	if math.abs(tonumber(set) or 0)>0 then
		return true
	end
	return false
end

local config = {
	remoteDelay = 600,
	{"X, Y, Color",
		{
			settingsRule = {
				title = "自定义格式 [X, Y, Color] 的参数设置",
				caption = {"参数名", "参数值"},
				args = {
					{"格式2相似度", "85"},
					{"格式2函数名", "isColor"},
					{"空格补齐", "1"},
					{"换行格式", "1"},
				},
			},
			singlePosFormatRule = (function(p, a, s, x, c, set)
				local fmt = string.format(" %4d, %4d, 0x%06x ", p.x, p.y, p.c)
				if not toboolean(set["空格补齐"]) then
					fmt = fmt:gsub(" ", "")
				end
				return fmt
			end),
			multiPosFormatRule = (function(p, a, s, x, c, set)
				local fmt = string.format(" %4d, %4d, 0x%06x \n", p.x, p.y, p.c)
				if not toboolean(set["换行格式"]) then
					fmt = fmt:gsub("\n", ""):gsub("\t", "")
				end
				if not toboolean(set["空格补齐"]) then
					fmt = fmt:gsub(" ", "")
				end
				return fmt
			end),
			currentPosInfo = make_currentPosInfo(" %4d, %4d, 0x%06x "),
			makeScriptRule = {
				(function(poslist, set)
					local fmt = "\t{ %4d, %4d, 0x%06x},\n"
					local ret = "{\n"
					for _,currentPos in ipairs(poslist) do
						ret = ret..string.format("\t{ %4d, %4d, 0x%06x},\n", currentPos.x, currentPos.y, currentPos.c)
					end
					ret = ret.."}"
					if not toboolean(set["换行格式"]) then
						ret = ret:gsub("\n", ""):gsub("\t", "")
					end
					if not toboolean(set["空格补齐"]) then
						ret = ret:gsub(" ", "")
					end
					return ret
				end),
				(function(poslist, set)
					local ret = "if ("
					for i,currentPos in ipairs(poslist) do
						ret = ret..string.format(set["格式2函数名"].."(%4d, %4d, 0x%06x, "..set["格式2相似度"]..")", currentPos.x, currentPos.y, currentPos.c)
						if i~=#poslist then
							ret = ret.." and \n"
						end
					end
					ret = ret..") then"
					if not toboolean(set["换行格式"]) then
						ret = ret:gsub("\n", ""):gsub("\t", "")
					end
					if not toboolean(set["空格补齐"]) then
						ret = ret:gsub(" ", "")
					end
					return ret
				end),
				(function(poslist, set)
					local ret = make_findMultiColorInRegionFuzzy(poslist)
					if not toboolean(set["空格补齐"]) then
						ret = ret:gsub(" ", "")
					end
					return ret
				end),
			},
		},
	},
	{"{X, Y, Color},",
		{
			settingsRule = {
				title = "自定义格式 [{X, Y, Color},] 的参数设置",
				caption = {"参数名", "参数值"},
				args = {
					{"格式2相似度", "85"},
					{"格式2函数名", "isColor"},
					{"空格补齐", "1"},
					{"换行格式", "1"},
				},
			},
			singlePosFormatRule = (function(p, a, s, x, c, set)
				local fmt = string.format("{ %4d, %4d, 0x%06x }", p.x, p.y, p.c)
				if not toboolean(set["空格补齐"]) then
					fmt = fmt:gsub(" ", "")
				end
				return fmt
			end),
			multiPosFormatRule = (function(p, a, s, x, c, set)
				local fmt = string.format("{ %4d, %4d, 0x%06x },\n", p.x, p.y, p.c)
				if not toboolean(set["换行格式"]) then
					fmt = fmt:gsub("\n", ""):gsub("\t", "")
				end
				if not toboolean(set["空格补齐"]) then
					fmt = fmt:gsub(" ", "")
				end
				return fmt
			end),
			currentPosInfo = make_currentPosInfo("{ %4d, %4d, 0x%06x }"),
			makeScriptRule = {
				(function(poslist, set)
					local ret = "{\n"
					for _,currentPos in ipairs(poslist) do
						ret = ret..string.format("\t{ %4d, %4d, 0x%06x},\n", currentPos.x, currentPos.y, currentPos.c)
					end
					ret = ret.."}"
					if not toboolean(set["换行格式"]) then
						ret = ret:gsub("\n", ""):gsub("\t", "")
					end
					if not toboolean(set["空格补齐"]) then
						ret = ret:gsub(" ", "")
					end
					return ret
				end),
				(function(poslist, set)
					local ret = "if ("
					for i,currentPos in ipairs(poslist) do
						ret = ret..string.format(set["格式2函数名"].."(%4d, %4d, 0x%06x, "..set["格式2相似度"]..")", currentPos.x, currentPos.y, currentPos.c)
						if i~=#poslist then
							ret = ret.." and "
						end
					end
					ret = ret..") then"
					if not toboolean(set["换行格式"]) then
						ret = ret:gsub("\n", ""):gsub("\t", "")
					end
					if not toboolean(set["空格补齐"]) then
						ret = ret:gsub(" ", "")
					end
					return ret
				end),
				(function(poslist, set)
					local ret = make_findMultiColorInRegionFuzzy(poslist)
					if not toboolean(set["空格补齐"]) then
						ret = ret:gsub(" ", "")
					end
					return ret
				end),
			},
		},
	},
	{"pos.new(X, Y, Color),",
		{
			settingsRule = {
				title = "自定义格式 [pos.new(X, Y, Color),] 的参数设置",
				caption = {"参数名", "参数值"},
				args = {
					{"相似度", 			"90"},
					{"格式2延迟", 		"100"},
					{"格式2点按深度", 	"100"},
					{"格式2默认标签", 	""},
				},
			},
			singlePosFormatRule = (function(p, a, s, x, c, set)
				return string.format("pos.new( %4d, %4d, 0x%06x)", p.x, p.y, p.c)
			end),
			multiPosFormatRule = (function(p, a, s, x, c, set)
				return string.format("pos.new( %4d, %4d, 0x%06x ),\n", p.x, p.y, p.c)
			end),
			currentPosInfo = make_currentPosInfo("pos.new( %4d, %4d, 0x%06x)"),
			makeScriptRule = {
				(function(poslist, set)
					local ret = "{\n\tcsim = "..set["相似度"]..",\n"
					ret = ret..string.format("\ttl = pos.new(%d, %d),\n", poslist.a.x, poslist.a.y)
					ret = ret..string.format("\tbr = pos.new(%d, %d),\n", poslist.s.x, poslist.s.y)
					for _,currentPos in ipairs(poslist) do
						ret = ret..string.format("\tpos.new( %4d, %4d, 0x%06x),\n", currentPos.x, currentPos.y, currentPos.c)
					end
					return ret.."}"
				end),
				(function(poslist, set)
					local ret = "{\n\tcsim = "..set["相似度"]..",\n\tdelay = "..set["格式2延迟"]..",\n\tclkdeep = "..set["格式2点按深度"]..",\n\tlabel = \""..set["格式2默认标签"].."\",\n"
					for _,currentPos in ipairs(poslist) do
						ret = ret..string.format("\tpos.new( %4d, %4d, 0x%06x),\n", currentPos.x, currentPos.y, currentPos.c)
					end
					return ret.."}"
				end),
				make_findMultiColorInRegionFuzzy,
			},
		},
	},
}


-- 创建默认配置文件
local default_enabled = [[
--[[

	文件名:
		scripts/config/colorpicker/cf_enabled.lua
	说明:
		自定义格式启用列表配置文件

--]].."]]"..[[
return {
-- 当前文件表示激活的自定义格式列表
-- 文件名请用英文，此处不要写扩展名
-- 当前文件中的内容的顺序是有意义的
-- 格式文件放在这个目录中 scripts/config/colorpicker/customformats/
	"taotao_rgb",
	"taotao_hex",
	"simple_matrix",
	"old_ver",
}
]]

-- 加载自定义配置
local moreCustomFormats

moreCustomFormats = require("scripts.lua.tscpbase").loadSettings(
	default_enabled,
	"scripts.config.colorpicker.cf_enabled",
	"cf_enabled",
	"table"
)

moreCustomFormats = moreCustomFormats or {
	"taotao_rgb",
	"taotao_hex",
	"simple_matrix",
	"old_ver",
}

for _,v in ipairs(moreCustomFormats) do
	local r, m = pcall(require, "scripts.config.colorpicker.customformats."..v)
	if r then
		table.insert(config, m)
	else
		-- print('自定义格式模块 ['..v..'] '..'装载失败: '..m)
		print(m)
	end
end

return config
