﻿/**
 * Parameters for hangar
 * 车库设置
 */
{
  "hangar": {
    "xwnInCompany": true,			//使用XWN代替XEFF
    "enableGoldLocker": false,                  //锁定金币
    "enableFreeXpLocker": false,                //锁定全局经验
    "defaultBoughtForCredits": true,            //默认使用银币购买给养

    "hidePricesInTechTree": false,		//科技树隐藏售价
    "masteryMarkInTechTree": true,		//科技树显示M
    "allowExchangeXPInTechTree": true,
    "enableCrewAutoReturn": true,              //自动使用旧乘员
    "crewReturnByDefault": false,
    "barracksShowFlags": true,
    "barracksShowSkills": true,
    "enableEquipAutoReturn": false,
    // 装弹少于20%禁止开始战斗
    "blockVehicleIfLowAmmo": true,
    "lowAmmoPercentage": 20,
    "widgetsEnabled": false,		// 使用车库插件
    "pingServers": {				// 服务器PING测试
      "enabled": false,
      "updateInterval": 10000,	// 更新周期, 毫秒
      "x": 170,
      "y": 35,
      "hAlign": "left",
      "vAlign": "top",
      "alpha": 80,
      "delimiter": ": ",			// 分隔符
      "maxRows": 4,					// 最大条目数
      "columnGap": 10,				// 行间距
      "leading": 0,
      "topmost": true,				//置顶
      "showTitle": true,
      "showServerName": true,
      "minimalLength": 0,
      "errorString": "--",
      "fontStyle": {				// 文本格式
        "name": "$IMELanguageBar",
        "size": 12, 				// 字体大小
        "bold": false,  			// 加粗
        "italic": false, 			// 斜体
        "color": {					// ping值颜色
          "great": "0xFFCC66", 
          "good": "0xE5E4E1", 
          "poor": "0x96948F", 
          "bad": "0xD64D4D"   
        },
        "markCurrentServer": "bold",
        "serverColor": ""
      },
      "threshold": {				// 响应质量定义
        // 小于30:极好
        "great": 35,
        // 小于60:好
        "good": 60,
        // 差
        "poor": 100
      },
      "shadow": {
        "enabled": true,
        "color": "0x000000",
        "distance": 0,
        "angle": 0,
        "alpha": 70,
        "blur": 4,
        "strength": 2
      }
    },
    "onlineServers": {
      // true - Enable display online of servers
      // true - показывать онлайн серверов
      "enabled": false,
      // Axis field coordinates
      // Положение поля по осям
      "x": -3,
      "y": 51,
      // Horizontal alignment of field at screen ("left", "center", "right").
      // Горизонтальное выравнивание поля на экране ("left", "center", "right").
      "hAlign": "right",
      // Vertical alignment of field at screen ("top", "center", "bottom").
      // Вертикальное выравнивание поля на экране ("top", "center", "bottom").
      "vAlign": "top",
      // Transparency
      // Прозрачность от 0 до 100
      "alpha": 80,
      // Server to online text delimiter
      // Разделитель сервера от онлайна
      "delimiter": ": ",
      // Maximum number of column rows
      // Максимальное количество строк одной колонки
      "maxRows": 2,
      // Gap between columns
      // Пространство между колонками
      "columnGap": 3,
      // Leading between lines.
      // Пространство между строками
      "leading": 0,
      // true - place at top of other windows, false - at bottom.
      // true - отображать поверх остальных окон, false - под.
      "topmost": true,
      // true - show title "Online"
      // true - показывать заголовок "Онлайн"
      "showTitle": true,
      // true - show server names in list
      // true - показывать названия серверов в списке
      "showServerName": true,
      // expand values to this amount of symbols. recommended to use monospace font if this option is set.
      // расширить значения до данного количества символов. рекомендуется использовать моноширинный шрифт если данная опция задана.
      "minimalLength": 0,
      "errorString": "--k",
      // Text style
      // Стиль текста
      "fontStyle": {
        // Font name
        // Название шрифта
        "name": "$FieldFont",
        "size": 12,         // Размер
        "bold": false,      // Жирный
        "italic": false,    // Курсив
        // Different colors depending on people online
        // Разные цвета в зависимости от количества игроков
        "color": {
          "great": "0x60ff00",  // Отличный
          "good":  "0xF8F400",  // Хороший
          "poor":  "0xFE7903",  // Так себе
          "bad":   "0xFE0E00"   // Плохой
        },
        // Mark current server in the list, possible options: "none" (don't mark), "normal", "bold", "italic", "underline"
        // Выделять текущий сервер в списке, доступные опции: "none" (не выделять), "normal", "bold", "italic", "underline"
        "markCurrentServer": "bold",
        // Color for server name and delimiter (for example, "0x8080FF"). Empty string "" - use same color as online value
        // Цвет для названия сервера и разделителя (например, "0x8080FF"). Пустая строка "" - использовать цвет значения онлайна
        "serverColor": ""
     },
      // Threshold values defining server online and thus shorter battle queue
      // Пороговые значения, определяющие количество человек онлайн и следовательно меньшую очередь в бой
      "threshold": {
        "great": 30000,
        "good": 10000,
        "poor": 3000
        //below this value the queue might be long
        //ниже этого значения очередь может быть долгой
      },
      // Параметры тени
      "shadow": {
        "enabled": true,
        "color": "0x000000",
        "distance": 0,
        "angle": 0,
        "alpha": 70,
        "blur": 4,
        "strength": 2
      }
    },
    // Show/hide server info or change its parameters
    // Показать/спрятать информацию о сервере, или изменить ее параметры
    "serverInfo": {
      // Show server info in hangar.
      // Показывать информацию о сервере в ангаре.
      "enabled": false,
      // Transparency in percents [0..100].
      // Прозрачность в процентах [0..100].
      "alpha": 100,
      // Rotation in degrees [0..360].
      // Угол поворота в градусах [0..360].
      "rotation": 0,
      "shiftY": 0
    },
    // Parameters for tank carousel
    // Параметры карусели танков
    "carousel": ${"carousel.xc":"carousel"},
    // Parameters for hangar clock
    // Параметры часов в ангаре
    "clock": ${"clock.xc":"clock"}
  }
}
