﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="search.aspx.cs" Inherits="SearchEasy.SiteSearch.search" %>
<%@ Import Namespace="System.Collections.Generic" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
<meta name="author" content="http://www.searcheasy.net" />
<title>站内搜索引擎</title>
<link rel="stylesheet" type="text/css" href="/images/search_v2.css"/>
<link rel="stylesheet" type="text/css" media="all" href="/images/jquery-ui.css"/>
<script type="text/javascript" src="/images/jquery.min.js"></script>
<script type="text/javascript" src="/images/jquery-ui.min.js"></script>
</head>
<body>
<div class="doc">
	<!-- 公共头部 -->
	<div class="header-search">
        <div class="inner">
            <div class="logo"><a href="/"><asp:Literal runat="server" ID="ltlListLogo" /></a></div>
            <form id="q-form" method="get"> 
            <div class="search" id="q-input">
                <div class="cat">
                <%
                    if (AllSites.Count >= 2)
                    {
                        if (this.QuerySite == "ALL")
                        {
                            Response.Write("<a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "' class='current'>全站</a>");
                        }
                        else
                        {
                            Response.Write("<a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "'>全站</a>");
                        }
                        
                        foreach (SearchEasy.SiteSearch.Core.SiteInfo site in AllSites)
                        {
                            if (site.IsShowForPc)
                            {
                                if (site.UniqueSiteName == this.QuerySite)
                                {
                                    Response.Write("<a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "&s=" + site.UniqueSiteName + "' class='current'>" + site.SiteName + "</a>");
                                }
                                else
                                {
                                    Response.Write("<a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "&s=" + site.UniqueSiteName + "'>" + site.SiteName + "</a>");
                                }
                            }
                        }
                    }
                 %>                
                </div>
                <div class="input"><span class="kw"><input class="text" type="text" name="q" size="40" title="" value="<%= QueryKw %>"  x-webkit-speech="" x-webkit-grammar="builtin:translate"/></span><input type="hidden" value="<%= QuerySite %>" name="s" /><input type="submit" class="btn-search" value=""/></div>
                                <div class="result-status">
                找到约 <span class="count"><asp:Literal runat="server" ID="ltlResultCount" /></span> 项结果（用时 <span class="time"><asp:Literal runat="server" ID="ltlResultTime" /></span> 秒) <asp:Literal runat="server" ID="ltlSyntax" /></div>
            </div>
            </form>
        </div>
    </div>
    <!-- 公共头部 结束 -->
    <div id="main" class="lo-wrap">
        <div class="filter">
            <div class="cat">
                <h2>全部结果</h2>
                <ul>
                <%
                    if (AllSites.Count >= 2)
                    {
                        if (this.QuerySite == "ALL")
                        {
                            Response.Write("<li class='current'><a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "'>全站</a></li>");
                        }
                        else
                        {
                            Response.Write("<li><a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "'>全站</a></li>");
                        }
                        
                        foreach (SearchEasy.SiteSearch.Core.SiteInfo site in AllSites)
                        {
                            if (site.UniqueSiteName == this.QuerySite)
                            {
                                Response.Write("<li class='current'><a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "'>" + site.SiteName + "</a></li>");
                            }
                            else
                            {
                                Response.Write("<li><a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "&s=" + site.UniqueSiteName + "'>" + site.SiteName + "</a></li>");
                            }
                        }
                    }
                 %> 
                </ul>
            </div>
            <div class="date">
                <ul>
                    <li><a <% if (this.DateFilter == "") { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&s=<%= QuerySite %>&sortby=<%= SortBy %>">全部时间</a></li>
                    <li><a <% if (this.DateFilter == "1") { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&datefilter=1&s=<%= QuerySite %>&sortby=<%= SortBy %>">当天 </a></li>
                    <li><a <% if (this.DateFilter == "2") { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&datefilter=2&s=<%= QuerySite %>&sortby=<%= SortBy %>">最近一周</a></li>
                    <li><a <% if (this.DateFilter == "3") { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&datefilter=3&s=<%= QuerySite %>&sortby=<%= SortBy %>">最近一个月</a></li>
                    <li><a <% if (this.DateFilter == "4") { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&datefilter=4&s=<%= QuerySite %>&sortby=<%= SortBy %>">最近一年</a></li>
                </ul>
            </div>
            <%
                if (this.CurrentSite != null)
                {
                    if (!string.IsNullOrEmpty(this.CurrentSite.Cate1))
                    {
                        List<SearchEasy.SiteSearch.SiteCateInfo> scilist = GetSiteCateList(this.CurrentSite.CateList1);        
                %>
            <div class="date">
              <ul>
               <%
                   foreach (SearchEasy.SiteSearch.SiteCateInfo sci in scilist)
                   {
                        %>
                <li><a <% if (this.Cate1 == sci.CateVal) { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&s=<%= QuerySite %>&sortby=<%= SortBy %>&c1=<%= sci.CateVal %>"><%=sci.CateName%></a></li>
                <%
                   }
                  %>
              </ul>
            </div>
            <%
                }
                if (!string.IsNullOrEmpty(this.CurrentSite.Cate2))
                {
                    List<SearchEasy.SiteSearch.SiteCateInfo> scilist = GetSiteCateList(this.CurrentSite.CateList2);  
             %>
             
             <div class="date">
              <ul>
               <%
                   foreach (SearchEasy.SiteSearch.SiteCateInfo sci in scilist)
                   {
                        %>
                <li><a <% if (this.Cate2 == sci.CateVal) { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&s=<%= QuerySite %>&sortby=<%= SortBy %>&c2=<%= sci.CateVal %>"><%=sci.CateName%></a></li>
                <%
                   }
                  %>
              </ul>
            </div>
             <%
                }
                if (!string.IsNullOrEmpty(this.CurrentSite.Cate3))
                {
                    List<SearchEasy.SiteSearch.SiteCateInfo> scilist = GetSiteCateList(this.CurrentSite.CateList3);  
                    %>
             <div class="date">
              <ul>
               <%
                   foreach (SearchEasy.SiteSearch.SiteCateInfo sci in scilist)
                   {
                        %>
                <li><a <% if (this.Cate3 == sci.CateVal) { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&s=<%= QuerySite %>&sortby=<%= SortBy %>&c3=<%= sci.CateVal %>"><%=sci.CateName%></a></li>
                <%
                   }
                  %>
              </ul>
            </div>
             <%
                }
                if (!string.IsNullOrEmpty(this.CurrentSite.Cate4))
                {
                    List<SearchEasy.SiteSearch.SiteCateInfo> scilist = GetSiteCateList(this.CurrentSite.CateList4);  
                    %>
             <div class="date">
              <ul>
               <%
                 foreach (SearchEasy.SiteSearch.SiteCateInfo sci in scilist)
                 {
                        %>
                <li><a <% if (this.Cate4 == sci.CateVal) { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&s=<%= QuerySite %>&sortby=<%= SortBy %>&c4=<%= sci.CateVal %>"><%=sci.CateName%></a></li>
                <%
                 }
                  %>
              </ul>
            </div>
              <% }
                if (!string.IsNullOrEmpty(this.CurrentSite.Cate5))
                {
                    List<SearchEasy.SiteSearch.SiteCateInfo> scilist = GetSiteCateList(this.CurrentSite.CateList5); 
                  %>
            <div class="date">
              <ul>
               <%
                  foreach (SearchEasy.SiteSearch.SiteCateInfo sci in scilist)
                  {
                        %>
                <li><a <% if (this.Cate5 == sci.CateVal) { Response.Write("class='current'"); }%> href="/search.aspx?q=<%= Server.UrlEncode(this.QueryKw) %>&s=<%= QuerySite %>&sortby=<%= SortBy %>&c5=<%= sci.CateVal %>"><%=sci.CateName%></a></li>
                <%
                  }
                  %>
              </ul>
            </div>
             <%
                  } 
             } %>
        </div>
        <div class="side-handle"><a id="toggle" href="javascript:void(0);" class="btn-close"></a></div>
        <div class="lo-main">
        	<div class="result">
                <div class="sort">
                  <% 
                      if (SortBy == string.Empty || SortBy != "date")
                      {
                          Response.Write("<span class='selected'>按相关度排序</span> | <a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "&sortby=date&s="+this.QuerySite+"'>按时间排序</a>");
                      }
                      else
                      {
                          Response.Write("<a href='/search.aspx?q=" + Server.UrlEncode(this.QueryKw) + "&sortby=related&s=" + this.QuerySite + "'>按相关度排序</a> | <span class='selected'>按时间排序</span>");
                      }
                  %>
                </div>
                <div class="list">
                 <%
                     foreach (System.Data.DataRow resultItem in this.SearchResultData.Rows)
                     {
                         if (settings.IsShowPhoto && (!String.IsNullOrEmpty(resultItem["ThumbPic"].ToString()) || !String.IsNullOrEmpty(resultItem["ThumbPicUrl"].ToString())))
                         {
                              %>
                              <div class="top-data">
                                <dl>
                                    <dt><a href="<%= resultItem["Url"] %>" target="_blank"><img width="120" height="155" src="<%= resultItem["ThumbPicUrl"].ToString() == string.Empty ? resultItem["ThumbPic"] : resultItem["ThumbPicUrl"] %>" /></a></dt>
                                    <dd class="title"><a href="<%= resultItem["Url"] %>" title="<%= resultItem["Title"] %>" target="_blank"><%= GetSiteName("[{0}]", resultItem["UniqueSiteName"].ToString())%><%= resultItem["Title"]%></a></dd>
                                    <%= resultItem["CustomContent"] == string.Empty ? "" : "<div class='i-info'>" + resultItem["CustomContent"] + "</div>"%>
                                    <dd class="info">时间：<%= resultItem["PublishDate"]%></dd>
                                    <dd class="des"><%= resultItem["Content"]%></dd>
                                    <div class="i-info"><a href="<%= resultItem["Url"] %>" class="channel" target="_blank"><%= resultItem["Url"]%></a></div>
                                </dl>
                              </div>
                              <%
                         }
                         else
                         {
                              
                 %>
                     <div class="item">
                       <div class="i-title"><a href="<%= resultItem["Url"] %>" target="_blank"><%= GetSiteName("[{0}]", resultItem["UniqueSiteName"].ToString())%><%= resultItem["Title"]%></a></div>
                       <%= resultItem["CustomContent"] == string.Empty ? "" : "<div class='i-info'>" + resultItem["CustomContent"] + "</div>"%>
                       <div class="i-des"><%= resultItem["Content"]%></div>
                       <div class="i-info"><a href="<%= resultItem["Url"] %>" class="channel" target="_blank"><%= resultItem["Url"] %></a> - <%= resultItem["PublishDate"]%></div>
                     </div>
                      <%
                          }
                     }    
                 %>

                </div>
                <!-- 相关搜索 -->
                <%
                    List<string> relateKwList = this.RelateKw;
                    if (relateKwList.Count != 0)
                    {
                %>
                <div class="related">
                <h2>相关搜索</h2>
                <ul>
                   <%foreach (string rkw in relateKwList)
                     { %>
                       <li><a href="<%= GetRewriteUrl(rkw) %>"><%=rkw%></a></li>
                    <%} %>
                </ul>
                </div>
                <%
                    } %>
                <!-- 相关搜索 结束 -->
            	<div class="pages">
            	<asp:Literal runat="server" ID="ltlPager" />
            	</div>
            </div>
            <div class="lo-side">
              <div align="right"><%= SearchAd %></div>
            </div>
	    <div class="fix"></div>
        </div>
    </div>
    <div class="footer">
        <p class="copyright_en"><asp:Literal runat="server" ID="ltlCopyRight" /></p>
        <p class="copyright_zh"><asp:Literal runat="server" ID="ltlPoweredBy" /></p>
    </div>
</div>
<asp:Literal runat="server" ID="ltlSearchSuggestionJs" />
<script language="javascript" type="text/javascript" src="/updatetask.aspx"></script>
</body>
</html>
 


