﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonDegree.aspx.cs" Inherits="SWTraining.Teacher.LessonDegree"
    Title="教师工作台-排课信息" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel">
        <label class="lab_buttom">
            <asp:Button ID="btnAddOneLessonDegree" runat="server" OnClick="btnAddOneLessonDegree_Click"
                Text="增加排课" /></label><label class="lab_buttom">
                    <asp:Button ID="btnClearLessonDegree" runat="server" OnClick="btnClearLessonDegree_Click"
                        Text="清除排课" OnClientClick="return confirm('执行此操作，将删除所有未上课的排课信息，您确定要这么做？');" />
                </label>
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="LessonDegreeID" OnRowDataBound="GridView1_RowDataBound" OnRowDeleting="GridView1_RowDeleting">
            <Columns>
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <asp:ImageButton runat="server" Enabled="false" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                            ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' CommandName="LeStateID"
                            CommandArgument='<%#Eval("LeStateID")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Subject" HeaderText="课题"></asp:BoundField>
                <asp:TemplateField HeaderText="上课日期">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                            NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonDegreeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonDegreeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        <span style="color: Red; font-size: 9px">[<%#GetWeek(Eval("StartDate"))%>]</span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="上课时段">
                    <ItemTemplate>
                        <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="类型">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                            runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>' ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Lessons" HeaderText="课时"></asp:BoundField>
                <asp:BoundField DataField="FactCount" HeaderText="出勤" ReadOnly="True"></asp:BoundField>
                <asp:BoundField DataField="TruancyCount" HeaderText="旷课" ReadOnly="True"></asp:BoundField>
                <asp:BoundField DataField="LateCount" HeaderText="迟到" ReadOnly="True"></asp:BoundField>
                <asp:BoundField DataField="AdvanceCount" HeaderText="早退" ReadOnly="True"></asp:BoundField>
                <asp:BoundField DataField="LeaveCount" HeaderText="请假" ReadOnly="True"></asp:BoundField>
                <asp:TemplateField HeaderText="讲师">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labTeacherName" Text='<%#Eval("TeacherName")%>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList runat="server" ID="ddlTeacher" SelectedValue='<%#Eval("TeacherID")%>'
                            DataSource='<%#swq.Cache.GetUsers()%>' DataTextField="TrueName" DataValueField="UserID">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="教室">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labClassroomName" Text='<%#Eval("ClassroomName")%>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList runat="server" ID="ddlClassroom" SelectedValue='<%#Eval("ClassroomID")%>'
                            DataSource='<%#swq.Cache.GetClassroom()%>' DataTextField="ClassroomName" DataValueField="ClassroomID">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="点名控制">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="hlkAttend" Text="点名控制" NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonDegreeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonDegreeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑" ShowHeader="False">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" NavigateUrl='<%#string.Format("PostLessonDegree.aspx?LessonDegreeID={0}&ClassID={1}&GetUrl={2}",Eval("LessonDegreeID"),Eval("ClassID"),swq.Web.PathAndQuery())%>'
                            ID="hlkEdit" Text="编辑" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        &nbsp;<asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
        </label>
    </div>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、点击日期进入学员考勤。<br />
        2、日期后面红色数字表示当天是星期几。<br />
        3、点击“清除排课”仅删除未上课的排课，不影响已考勤的排课。<br />
    </div>
    </form>
</body>
</html>
