﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuPayment.aspx.cs" Inherits="SWTraining.Student.StuPayment"
    Title="学员账户查看" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/Remark.ascx" TagName="Remark" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function StudentBox() {
            window.showModelessDialog('../Tools/StudentBox.aspx', window, 'dialogWidth=750px;dialogHeight=500px');
        }
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel">
        <asp:FormView ID="fvStudent" runat="server" Width="100%">
            <ItemTemplate>
                <table class="smallgridview" cellspacing="0">
                    <thead>
                    <tr>
                        <th colspan="3" style="text-align: center">
                            账户信息
                        </th>
                    </tr>
                        </thead>
                    <tr>
                        <td style="width: 100px">
                            学号：
                        </td>
                        <td style="width: 100px">
                            <%#Eval("StudentID")%>
                        </td>
                        <td rowspan="2">
                            <asp:Image ID="imgPhoto" runat="server" Height="50" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            姓名：
                        </td>
                        <td>
                            <%#Eval("StudentName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            可用余额：
                        </td>
                        <td colspan="2">
                            <span style="color: Red">
                                <%#Eval("AvailableMoney", "{0:c2}")%></span>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            消费总额：
                        </td>
                        <td colspan="2">
                            <%#Eval("ConsumedMoney","{0:c2}")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            借款金额：
                        </td>
                        <td colspan="2">
                            <%#Eval("CreditMoney", "{0:c2}")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            积分：
                        </td>
                        <td colspan="2">
                            <%#Eval("Points")%>分
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
    </div>
    <div class="divpanel">
        <table class="table" cellspacing="0">
            <tr>
                <th>
                    我要充值(支付宝/网银)
                </th>
            </tr>
            <tr>
                <td>
                    金额：<asp:TextBox ID="tbxPay" runat="server">0</asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    原因：<asp:TextBox ID="tbxBody" runat="server" Width="243px"></asp:TextBox>
                    （20字以内）
                </td>
            </tr>
            <tr>
                <td>
                    <label class="lab_buttom">
                        <asp:Button ID="btnPost" runat="server" Text="确定" OnClick="btnPost_Click" />
                    </label>
                </td>
            </tr>
            <tr>
                <td>
                    <a href="StuPaymentLog.aspx">支付宝支付记录</a>。
                </td>
            </tr>
        </table>
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="gridview"
            DataKeyNames="PaymentID" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="PaymentID" HeaderText="编号" ReadOnly="true" />
                <asp:TemplateField HeaderText="类型">
                    <ItemTemplate>
                        <asp:Label ID="labPaymentType" runat="server" Text='<%#Eval("PaymentTypeName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="金额">
                    <ItemTemplate>
                        <asp:Label ID="labPayMoney" runat="server" Text='<%# Bind("PayMoney", "{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="收款方式">
                    <ItemTemplate>
                        <asp:Label ID="labPayMethod" runat="server" Text='<%# Bind("PayMethod") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="日期">
                    <ItemTemplate>
                        <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="备注">
                    <ItemTemplate>
                        <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="借款到期">
                    <ItemTemplate>
                        <asp:Label ID="labCreditExpiration" runat="server" Text='<%# Bind("CreditExpiration") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="办理点">
                    <ItemTemplate>
                        <asp:Label ID="labPostSchoolName" runat="server" Text='<%# Bind("PostSchoolName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="收费文员">
                    <ItemTemplate>
                        <asp:Label ID="labTrueName" runat="server" Text='<%# Bind("TrueName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input id="Button1" causesvalidation="false" type="button" runat="server" onclick="back()"
                value="返回" />
        </label>
    </div>
    <div class="divpanel">
        <uc2:Remark ID="imgBig" runat="server" />
    </div>
    </form>
</body>
</html>
