﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sys_SmsTemplate.aspx.cs"
    Inherits="SWTraining.SMS.sys_SmsTemplate" Title="短信管理-短信模板" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        <table>
            <tr>
                <td>
                    模板名称：<asp:TextBox ID="tbxSmsTemplateName" runat="server" Width="168px"></asp:TextBox>
                </td>
                <td>
                    类别：
                </td>
                <td>
                    <asp:DropDownList ID="ddlUserLevel" runat="server">
                        <asp:ListItem Value="0">请选择</asp:ListItem>
                        <asp:ListItem Value="1">通知</asp:ListItem>
                        <asp:ListItem Value="2">广告</asp:ListItem>
                    </asp:DropDownList>
                </td>
                <td>
                    模板内容：
                </td>
                <td>
                    <div id="msg" style="color: #676767">
                    </div>
                    <asp:TextBox ID="tbxContent" runat="server" Width="166px" TextMode="MultiLine" Height="50px"></asp:TextBox>
                </td>
                <td>
                    <label class="lab_buttom">
<asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click"></asp:Button>
</label>
                </td>
            </tr>
        </table>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="SmsTemplateID" OnRowCancelingEdit="GridView1_RowCancelingEdit"
            OnRowCommand="GridView1_RowCommand" OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating"
            OnRowCreated="GridView1_RowCreated" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="SmsTemplateID" ReadOnly="True" HeaderText="编号" />
                <asp:BoundField DataField="SmsTemplateName" HeaderText="名称" />
                <asp:TemplateField HeaderText="类别">
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlUserLevel" runat="server" SelectedValue='<%# Eval("UserLevel") %>'>
                            <asp:ListItem Value="1">通知</asp:ListItem>
                            <asp:ListItem Value="2">广告</asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labUserLevel" runat="server" Text='<%# Rs.Items.GetUserLevel(Eval("UserLevel")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="内容">
                    <EditItemTemplate>
                        <div id="msg2" style="color: #676767">
                        </div>
                        <asp:TextBox ID="tbxContent" runat="server" Text='<%# Bind("Content") %>' Width="153px"
                            TextMode="MultiLine" Height="100px"></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labContent" runat="server" Text='<%# swq.Tools.HtmlEncode(Eval("Content").ToString()) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                        <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" Text="↑"></asp:LinkButton>
                        <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" Text="↓"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
