﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString">
  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>
  <xsl:template match="/">
    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>5.5cm</paperwidth>
          <paperheight>0</paperheight>
          <pageleft>0mm</pageleft>
          <pageright>0mm</pageright>
          <pagetop>0mm</pagetop>
          <pagebottom>0mm</pagebottom>
          <fontname>宋体</fontname>
          <fontsize>9</fontsize>
          <doctype>1</doctype>
          <resolutionkind>3</resolutionkind>
          <copies>1</copies>


        </pagesetting>
        <style>
          .thead{
          border-top-width:0mm;
          border-left-width:0mm;
          border-bottom-width:0mm;
          border-right-width:0mm;
          text-align:center;
          font-style:bold
          }
          .bottom{
          border-left-width:0mm;
          border-bottom-width:0mm;
          border-right-width:0mm;
          }
          .left{
          border-left-width:0mm;
          font-style:bold
          }
          .right{
          border-right-width:0mm;
          font-style:bold
          }
          .leftright{
          border-left-width:0mm;
          border-right-width:0mm;
          font-style:bold
          }
        </style>
      </head>
      <body>
        <table x="0cm" y="0"  style="border:0mm">
          <thead>
            
            <tr height="0cm">
              <td width="4.8cm" format="child">
                <span x="0" y="0cm" style="width:4.8cm; height:1cm;text-align:center;font-size:9"></span>
              </td>
            </tr>

            <tr height="3cm">
              <td width="4.8cm" format="child">
                <span x="0" y="0.6cm" style="width:4.8cm; height:1cm;text-align:center;font-size:17;font-family:黑体;">
                  <xsl:if test="ds/Bill/BillTypeID = 1">消费单</xsl:if>
                  <xsl:if test="ds/Bill/BillTypeID = 0">退货单</xsl:if>
                </span>

                <span x="0" y="1.4cm">
                  姓名：<xsl:value-of select="ds/Bill/StudentName" /><br />
                  学号：<xsl:value-of select="ds/Bill/StudentID" /><br />
                  日期：<xsl:value-of select="String:FormatDate('{0:D}',ds/Bill/DateAndTime)" /><br />
                  流水号：<xsl:value-of select="ds/Bill/BillID" />
                </span>
              </td>
            </tr>
            <tr height="0.5cm" style="border-bottom-width:0.2mm;font-style:bold">
              <td width="2.8cm" style="text-align:left;padding-left:4mm">收费项</td>
              <td width="1.2cm">单价</td>
              <td width="0.8cm">数量</td>
            </tr>
          </thead>

          <tbody>
            <xsl:for-each select="ds/BillItem">
              <xsl:variable name="StuClassID" select="StuClassID" ></xsl:variable>
              <tr height="0.5cm" style="border-top-width:0.1mm">
                <td width="2.8cm" style="text-align:left;text-formatflags:linelimit">
                  ●<xsl:value-of select="ProductName" /><xsl:if test="ProductType = 8 and /ds/Bill/BillTypeID = 1">
                    <xsl:if test="DealWithState = 0">×</xsl:if>
                    <xsl:if test="DealWithState = 1">√</xsl:if>
                  </xsl:if>
                </td>
                <td width="1.2cm" style="text-formatflags:linelimit;font-size:7">
                  <xsl:value-of select="String:FormatNumber('{0:c}',UnitPrice)" />
                </td>
                <td width="0.8cm" align="center">
                  <xsl:value-of select="Amount" />
                </td>
              </tr>

              <xsl:if test="ProductType = 1 and DealWithState = 1">
                <tr height="1cm">
                  <td width="4.8cm" style="font-size:7;text-valign:top;text-align:left;padding-left:4mm;text-formatflags:linelimit">
                    上课时间：<xsl:value-of select="String:FormatDate('{0:D}',/ds/Class[StuClassID = $StuClassID]/StartDate)" />(<xsl:value-of select="/ds/Class[StuClassID = $StuClassID]/TimeRule" />)<br />地点：<xsl:value-of select="/ds/Class[StuClassID = $StuClassID]/SchoolName" />
                    (<xsl:value-of select="/ds/Class[StuClassID = $StuClassID]/ClassroomName" />)讲师：<xsl:value-of select="/ds/Class[StuClassID = $StuClassID]/TeacherName" />
                    <br />
                  </td>
                </tr>
              </xsl:if>
            </xsl:for-each>
          </tbody>

          <tfoot>
            <tr height="2.5cm" style="border-top-width:0.2mm">
              <td width="4.8cm" style="text-align:left;font-style:bold">
                <xsl:if test="ds/Bill/BillTypeID = 1">优惠：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">扣除：</xsl:if>
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Favourable)" /><br />
                <xsl:if test="ds/Bill/BillTypeID = 1">实收：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">实退：</xsl:if>
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Payed)"/><br />
                余额：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Student/AvailableMoney)"/><br />
                欠费：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Student/CreditMoney)"/><br /><br />
                签字或盖章：
              </td>
            </tr>

            <tr height="1cm">
              <td width="4.8cm" style="text-align:left;font-size:8" format="child">
                <span x="0" y="0cm">
                  付款需知：购买后概不退款，√表示教材已发，×表示教材未发。
                </span>

              </td>
            </tr>

            <tr height="1.5cm">
              <td width="4.8cm" style="text-align:left;font-size:8" format="child">
                <span x="0" y="0cm">
                  录入员：<xsl:value-of select="ds/Bill/TrueName" /><br />
                  收费点：<xsl:value-of select="ds/Bill/PostSchoolName" /><br />
                  打印者：<xsl:value-of select="$PrintTrueName" /><br />
                  打印时间：<xsl:value-of select="$PrintDateTime" />
                </span>

              </td>
            </tr>

            <tr height="3cm">
              <td width="5cm" format="child">
                <image x="1cm" y="0cm" width="2.8cm" height="2.8cm" twocode="true">
                  <xsl:value-of select="ds/Bill/BillID" />
                </image>
              </td>
            </tr>

            <tr height="0.5cm">
              <td width="5cm" format="child">
                <line x="0cm" y="0cm" endx="5cm" endy="0cm" style="border:0.1mm; border-style:dot"></line>
              </td>
            </tr>

          </tfoot>
        </table>



      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>