﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString">
  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>
  <xsl:template match="/">
    <html>
      <head>
        <pagesetting>
          <landscape>true</landscape>
          <paperkind>A4</paperkind>
          <pageleft>1cm</pageleft>
          <pageright>1cm</pageright>
          <pagetop>0.3cm</pagetop>
          <pagebottom>1cm</pagebottom>
          <fontname>宋体</fontname>
          <fontsize>10</fontsize>
          <pageno>页码：{0}/{1}</pageno>
          <doctype>3</doctype>
        </pagesetting>
        <style>
          .thead{
          border-top-width:0.5mm;
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          text-align:center;
          font-style:bold
          }
          .bottom{
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }
          .left{
          border-left-width:0.5mm;
          font-style:bold
          }
          .right{
          border-right-width:0.5mm;
          font-style:bold
          }
          .leftright{
          border-left-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }
          .bold
          {
          font-style:bold;
          }
        </style>
      </head>
      <body>
        <text x="0" y="1.3cm" style="font-size:16;font-family:黑体;text-align:center" width="28cm" height="1.3cm">
          <xsl:value-of select="ds/Class/ClassName" />
        </text>
        <text x="0" y="2.9cm" style="fontsize:11; text-align:left" width="28cm" height="1.3cm">
          班级编号：<xsl:value-of select="ds/Class/ClassID" />$nbsp;讲师：<xsl:value-of select="ds/Class/TeacherName" />$nbsp;开课时间：<xsl:value-of select="String:FormatDate('{0:yyyy年MM月dd日}',ds/Class/StartDate)" />$nbsp;上课规律：<xsl:value-of select="ds/Class/TimeRule" />
        </text>
        <text x="0" y="19cm" style="text-align:left" width="28cm" height="1.3cm">
          总数：<xsl:value-of select="count(ds/StuClass[ScStateID=1 or ScStateID=2])" />人
        </text>

        <table x="0" y="3.5cm" style="border:0.25mm" maxlines="24">
          <thead class="thead">
            <tr height="0.6cm">
              <td width="1cm" class="bold">序号</td>
              <td width="2.5cm" class="bold">姓名</td>
              <td width="2.5cm" class="bold">学号</td>
              <td width="1.3cm" class="bold">性别</td>
              <td width="4cm" class="bold">电话</td>
              <td width="5.8cm" class="bold">手机</td>
              <td width="7.6cm" class="bold">家庭地址</td>
              <td width="2.5cm" class="bold">邮编</td>
            </tr>
          </thead>

          <tbody class="bottom">
            <xsl:for-each select="ds/StuClass[ScStateID=1 or ScStateID=2]">
              <xsl:variable select="StudentID" name="StudentID"></xsl:variable>
              <tr height="0.6cm">
                <td width="1cm">
                  <xsl:number value="position()" format="1" />
                </td>
                <td width="2.5cm">
                  <xsl:value-of select="StudentName" />
                </td>
                <td width="2.5cm">
                  <xsl:value-of select="StudentID" />
                </td>
                <td width="1.3cm">
                  <xsl:value-of select="String:GetSex(/ds/Student[StudentID=$StudentID]/Sex)" />
                </td>
                <td width="4cm">
                  <xsl:value-of select="/ds/Student[StudentID=$StudentID]/Tel" />
                </td>
                <td width="5.8cm">
                  <xsl:value-of select="/ds/Student[StudentID=$StudentID]/MobileTel" />
                </td>
                <td width="7.6cm" align="left">
                  <xsl:value-of select="/ds/Student[StudentID=$StudentID]/HomeAddress" />
                </td>
                <td width="2.5cm">
                  <xsl:value-of select="/ds/Student[StudentID=$StudentID]/PostCode" />
                </td>
              </tr>
            </xsl:for-each>
          </tbody>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>