﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString"
>

  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintDateTime"/>

  <xsl:template match="/">

    <html>
      <head>
        <pagesetting>
          <landscape>true</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>10cm</paperwidth>
          <paperheight>21cm</paperheight>
          <papername>学员证</papername>
          <pageleft>10mm</pageleft>
          <pageright>10mm</pageright>
          <pagetop>10mm</pagetop>
          <pagebottom>10mm</pagebottom>
          <fontname>宋体</fontname>
          <doctype>2</doctype>
        </pagesetting>

        <style>
          .thead{
          border-top-width:0.3mm;
          border-left-width:0.3mm;
          border-bottom-width:0.3mm;
          border-right-width:0.3mm;
          text-align:center;
          font-style:bold
          }

          .bottom{
          border-left-width:0.3mm;
          border-bottom-width:0.3mm;
          border-right-width:0.3mm;
          font-style:bold
          }

          .left{
          border-left-width:0.3mm;
          font-style:bold
          }

          .right{
          border-right-width:0.3mm;
          font-style:bold
          }

          .leftright{
          border-left-width:0.3mm;
          border-right-width:0.3mm;
          font-style:bold
          }

          .font6{
          font-size:6;
          }

          .font5{
          font-size:5;
          }

          .bold
          {
          font-style:bold
          }

        </style>
      </head>
      <body>

        <table x="0" y="10" maxlines="5" style="border:0.1mm;border-style:dot">
          <tbody>
            <xsl:for-each select="ds/Student">
              <xsl:variable name="StudentID" select="StudentID" ></xsl:variable>
              <tr height="5cm">
                <td width="8cm" height="5cm" style="border-right-width:0"  format="child">

                  <image x="5.18cm" y="0.76cm" width="2.28cm" height="3cm" byte="true">
                    <xsl:value-of select="/ds/Student[StudentID=$StudentID]/Photo" />
                  </image>
                  <span x="1.5cm" y="0.6cm" style="font-size:16;font-family:黑体;">学员证</span>
                  <p x="0.5cm" y="1.2cm" width="4.5cm" height="2cm" style="line-height:120%">
                    姓名：
                    <span style="font-size:10;font-family:黑体;">
                      <xsl:value-of select="StudentName" />
                    </span><br />
                    性别：<xsl:value-of select="String:GetSex(/ds/Student[StudentID=$StudentID]/Sex)" /><br />
                    学号：<xsl:value-of select="StudentID" /><br />
                  </p>
                </td>
                <td width="8cm" height="5cm" format="child">

                  <span x="3.2cm" y="0.5cm" style="font-size:12;font-family:黑体;">课程表</span>
                  
                  <table x="0.5cm" y="1.2cm" style="border:0.1mm;border-style:solid">

                    <thead class="thead" style="font-size:6">
                      <tr height="0.35cm">
                        <td width="1cm" class="font6,bold">班号</td>
                        <td width="2cm" class="font6,bold">班级</td>
                        <td width="2cm" class="font6,bold">上课规律</td>
                        <td width="1cm" class="font6,bold">教室</td>
                        <td width="1cm" class="font6,bold">教师</td>
                      </tr>

                    </thead>


                    <tbody class="bottom">
                      <xsl:for-each select="/ds/Class">
                        <tr height="0.35cm">
                          <td width="1cm" class="font5">
                            <xsl:value-of select="ClassID" />
                          </td>
                          <td width="2cm" class="font5">
                            <xsl:value-of select="ClassName" />
                          </td>
                          <td width="2cm" class="font5">
                            <xsl:value-of select="TimeRule" />
                          </td>
                          <td width="1cm" class="font5">
                            <xsl:value-of select="ClassroomName" />
                          </td>
                          <td width="1cm" class="font5">
                            <xsl:value-of select="TeacherName" />
                          </td>
                        </tr>
                      </xsl:for-each>
                    </tbody>

                  </table>


                </td>
              </tr>
            </xsl:for-each>
          </tbody>
        </table>

      </body>

    </html>

  </xsl:template>
</xsl:stylesheet>