﻿<%@ Import Namespace="SWTraining" %>

<%@ Page Language="c#" CodeBehind="StuPotentials.aspx.cs" AutoEventWireup="True"
    Inherits="SWTraining.Register.StuPotentials" Title="报名管理-咨询信息管理" %>

<%@ Register src="../UserCol/SimpleCode.ascx" tagname="SimpleCode" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }

        function Send() {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StudentID += "," + e.value;
                    }
                }
            }

            if (StudentID.length > 0) {
                StudentID = StudentID.substring(1, StudentID.length);
                document.getElementById("PotentialID").value = StudentID;
                document.formStudent.action = "../SMS/SendToStudent.aspx";
                document.formStudent.submit();
            }
        }

        function Move() {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StudentID += "," + e.value;
                    }
                }
            }

            if (StudentID.length > 0) {
                StudentID = StudentID.substring(1, StudentID.length);
                this.location = "Move.aspx?PotentialID=" + StudentID;
            }
        }
    </script>
</head>
<body>
    <form id="Form1" method="post" runat="server">


    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="PotentialID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="咨询号">
                    <ItemTemplate>
                        <asp:Label ID="labPotentialID" runat="server" Text='<%# Eval("PotentialID") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="姓名">
                    <ItemTemplate>
                        <%#ShowColorPotentialName(Eval("StatusID"), Eval("NextReplyDate"),Eval("PotentialName")) %>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="来源">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labSourceType" Text='<%#Rs.Items.GetSourceType(Eval("SourceType"))%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="CourseName" ReadOnly="True" HeaderText="课程" />
                <asp:TemplateField HeaderText="媒体渠道">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labMediaName" Text='<%#Eval("MediaName")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="DateAndTime" ReadOnly="True" HeaderText="咨询日期" />
                <asp:TemplateField HeaderText="客户状态">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labStatusName" Text='<%# Eval("StatusName") %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="咨询顾问">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labTrueName" Text='<%#Eval("TrueName") %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="最后回访信息">
                    <ItemTemplate>
                        <div style="float: left;">
                            <%#Eval("LastPostName")%>|</div>
                        <div style="float: left;">
                            <%#Eval("LastPostTime")%>|</div>
                        <div title='<%#swq.Tools.GetSingleText(Eval("LastPostContent"))%>' style="float: left;
                            white-space: nowrap; overflow: hidden; text-overflow: ellipsis; width: 120px">
                            <%#swq.Tools.GetSingleText(Eval("LastPostContent"))%></div>
                        <div class="both">
                        </div>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="回访">
                    <ItemTemplate>
                        <span style="color: red">
                            <%#Eval("ReCount")%>
                        </span>次|<a href='Reply.aspx?PotentialID=<%#Eval("PotentialID")%>&GetURL=<% = swq.Web.PathAndQuery() %>'>回访</a>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkEdit" runat="server" Text="编辑" NavigateUrl='<%# string.Format("PostPotential.aspx?PotentialID={0}&GetURL={1}",Eval("PotentialID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除" SortExpression="delete">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("UserID")%>'
                            OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    </form>
    <!--短信Post传递参数代码S-->
    <!--短信Post传递参数代码E-->
    <div class="divremark">
        <b>注意事项：</b><br />

    </div>
</body>
</html>
