﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="EditStuClass.aspx.cs" Inherits="SWTraining.Register.EditStuClass"
    Title="报名管理-选择已选班级" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/Progress.ascx" TagName="progress" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel">
        <table class="table" cellspacing="0" runat="server" id="tabPost">
            <tr>
                <th colspan="2">
                    选择已选班级
                </th>
            </tr>
            <tr>
                <td>
                    选班：
                </td>
                <td>
                    <span style="color: Red">
                        <asp:DropDownList ID="ddlClass" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlClass_SelectedIndexChanged">
                        </asp:DropDownList>
                        *</span>&nbsp; 按状态筛选：<asp:DropDownList ID="ddlScState" runat="server" AutoPostBack="True"
                            OnSelectedIndexChanged="ddlScState_SelectedIndexChanged">
                            <asp:ListItem Value="true">正常</asp:ListItem>
                            <asp:ListItem Value="false">全部</asp:ListItem>
                        </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    计量方式：
                </td>
                <td>
                    <div style="background-color: #ffffff; border: 1px solid #ECEB7F; border-radius: 5px;
                        width: auto; padding: 4px; background-color: #FEFDC1">

                        <div id="setContent" style="float: left;">
                            <table>
                                <tr runat="server" id="trQuantifiedType">
                                    <td colspan="4">
                                        <asp:RadioButtonList ID="rblQuantifiedType" runat="server" 
                                            RepeatDirection="Horizontal" Width="235px" AutoPostBack="True" 
                                            onselectedindexchanged="rblQuantifiedType_SelectedIndexChanged">
                                            <asp:ListItem Value="0">混合</asp:ListItem>
                                            <asp:ListItem Value="1">课时数量</asp:ListItem>
                                            <asp:ListItem Value="2">到期时间</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </td>
                                </tr>
                                <tr runat="server" id="trLessons">
                                    <td>
                                        课时：
                                    </td>
                                    <td>
                                        <asp:TextBox ID="tbxLessons" runat="server" Width="71px" Enabled="False"></asp:TextBox>
                                        <asp:DropDownList ID="ddlLessons" runat="server" Visible="False">
                                        </asp:DropDownList>
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                        <asp:CheckBox ID="cbxSyncClassLessons" runat="server" OnCheckedChanged="cbxSyncClassLessons_CheckedChanged"
                                            Text="与班级总课时同步" />
                                    </td>
                                </tr>
                                <tr runat="server" id="trExpiryDate">
                                    <td>
                                        到期：
                                    </td>
                                    <td colspan="2">
                                        <asp:TextBox ID="tbxExpiryDate" runat="server"></asp:TextBox>
                                        <asp:Label ID="labTip" runat="server" ForeColor="Red"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:CheckBox ID="cbxSyncClassTime" runat="server" OnCheckedChanged="cbxSyncClassTime_CheckedChanged"
                                            Text="与班级结束日期同步" AutoPostBack="True" />
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div style="clear: both; height: 0px; font-size: 0px">
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    类型：
                </td>
                <td>
                    <asp:DropDownList ID="ddlContinueReg" runat="server">
                        <asp:ListItem Value="0">试听</asp:ListItem>
                        <asp:ListItem Value="1" Selected="True">新增</asp:ListItem>
                        <asp:ListItem Value="2">续报</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    录入员：
                </td>
                <td>
                    <asp:DropDownList ID="ddlUser" runat="server" DataTextField="TrueName" DataValueField="UserID">
                    </asp:DropDownList>
                    <span style="color: Red">*</span>
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;
                </td>
                <td>
                    <label class="lab_buttom">
                        <asp:Button ID="btnSubmit" runat="server" Text="提交" OnClick="btnSubmit_Click" />
                    </label>
                    <label class="lab_buttom">
                        <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
                    </label>
                </td>
            </tr>
        </table>
    </div>
    <div class="divpanel">
        <asp:FormView ID="fvClass" runat="server" Width="100%">
            <ItemTemplate>
                <table class="smallgridview" cellspacing="0" style="width: 100%">
                    <thead>
                    <tr>
                        <th colspan="2" style="text-align: center">
                            班级预览
                        </th>
                    </tr>
                        </thead>
                    <tr>
                        <td>
                            班级名称：
                        </td>
                        <td>
                            <%#Eval("ClassName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            开课时间：
                        </td>
                        <td>
                            <%#Eval("StartDate", "{0:d}") + " -- " + Eval("EndDate", "{0:d}")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            上课规律：
                        </td>
                        <td>
                            <%#Eval("TimeRule")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            主讲老师：
                        </td>
                        <td>
                            <%#Eval("TeacherName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            教室：
                        </td>
                        <td>
                            <%#Eval("ClassroomName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            招生比例：
                        </td>
                        <td>
                            <uc1:progress ID="Progress1" runat="server" Text="人" MaxNum='<%#Eval("PlanCount") %>'
                                MinNum='<%#Eval("StuCount") %>' Width="60px" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            课时进度：
                        </td>
                        <td>
                            <uc1:progress ID="Progress2" runat="server" Text="课时" MaxNum='<%#Eval("Lessons") %>'
                                MinNum='<%#Eval("CourseProgress") %>' Width="60px" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            选班状态：
                        </td>
                        <td>
                            <%# Rs.Items.GetScState( Eval("ScStateID")) %>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
    </div>
    </form>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、按状态筛选，选择“正常”时，只显示班级状态为正常的学员。选择“全部”时，状态为转班、退学、弃学、休学等班级也将会显示出来。<br />
        2、计量方式：是指量化学员上课资源的方式，分为按课时数量量化与按到期时间量化。<br />
            3、当课程单位为课时，系统强制按课时进行量化，当课程单位为学期时，系统同时提供两种方式供选择，但如果学期后面存在二级单位，如：天，周，月，季，年时，系统强制按到期时间进行量化。<br />
            4、当勾选“同步班级总课时”，课时数量会自动与班级总课时同步，只有报整班课时的学员才可以选择此项，慎用。<br />
            5、当勾选“同步班级结束日期”，学员到期时间会自动与班级结束日期同步，只有上课结束日期与班级结束日期相同的学员才可以选择此项，慎用。<br />
    </div>
</body>
</html>
