﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Teacher.aspx.cs" Inherits="SWTraining.Mobile.User.Teacher"
    Title="课程表" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="Header.ascx" TagName="Header" TagPrefix="uc1" %>
<%@ Register Src="../Footer.ascx" TagName="Footer" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <link href="../Themes/css.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <uc1:Header ID="Header1" runat="server" />
    <div class="tool_Search">
        时间：<asp:DropDownList ID="ddlDate" runat="server">
            <asp:ListItem Value="0">全部</asp:ListItem>
            <asp:ListItem Value="-2">前天</asp:ListItem>
            <asp:ListItem Value="-1">昨天</asp:ListItem>
            <asp:ListItem Value="1" Selected="True">今日</asp:ListItem>
            <asp:ListItem Value="2">明日</asp:ListItem>
            <asp:ListItem Value="3">最近7天</asp:ListItem>
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" Text="转到" />
        </label>
    </div>
    <div class="divpanel">
        <div class="tablecontent">
            <div class="tabletitle">
                课程表</div>
            <div class="tabletitle" style="left: 40%; background-color: #DEEEFC">
                <a href="TeacherClass.aspx">我的班级</a></div>
            <div class="splitline">
            </div>
            <asp:GridView ID="GridView1" runat="server" CssClass="gridview" DataKeyNames="LessonDegreeID"
                AutoGenerateColumns="false" OnRowDataBound="GridView1_RowDataBound" ShowHeader="False"
                OnRowDeleting="GridView1_RowDeleting">
                <Columns>
                    <asp:TemplateField>
                        <ItemTemplate>
                            <div class="inforow">
                                <div class="logo">
                                    <asp:Image runat="server" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                                        ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' />
                                </div>
                                <div class="name" style="left: 15px;">
                                    <%#Eval("ClassName")%>
                                </div>
                                <div class="time" style="top: 20px; line-height: 120%; left: 5px">
                                    <%#Eval("StartDate","{0:d}")%>（<%#swq.Tools.ChineseByEnWeek((DateTime)Eval("StartDate"))%>）
                                    <span runat="server" id="spanDate">
                                        <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                                    </span>
                                    <br />
                                    教室：<%#Eval("ClassroomName") %></div>
                                <div class="content">
                                    <div class="lab_buttom">
                                        <asp:HyperLink runat="server" NavigateUrl='<%#string.Format("PostLessonDegree.aspx?LessonDegreeID={0}&ClassID={1}&GetUrl={2}",Eval("LessonDegreeID"),Eval("ClassID"),swq.Web.PathAndQuery())%>'
                                            ID="hlkEdit" Text="编辑" /></div>
                                    <div class="lab_buttom">
                                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("ClassID")%>'
                                            OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                    </div>
                                    <div class="lab_buttom">
                                        <asp:HyperLink ID="hlkAttend" runat="server" Text="考勤" NavigateUrl='<%# string.Format("Attend.aspx?LessonDegreeID={0}&ClassID={1}&GetUrl={2}",Eval("LessonDegreeID"),Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                                    </div>
                                </div>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
        </label>
    </div>
    <uc2:Footer ID="Footer1" runat="server" />
    </form>
</body>
</html>
