﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Analysis.aspx.cs" Inherits="SWTraining.Mobile.User.Analysis" Title="校长分析" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="Header.ascx" TagName="Header" TagPrefix="uc1" %>
<%@ Register Src="../Footer.ascx" TagName="Footer" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <link href="../Themes/css.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <uc1:Header ID="Header1" runat="server" />
    <div class="tool_Search">
        校区：<asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" Text="查询" />
        </label>
    </div>
    <div class="tablecontent">
    <div class="tabletitle">
        今日招生
    </div>
    <div class="divpanel">
        咨询人数：<asp:Label ID="labNum0" runat="server"></asp:Label>
        <br />
        新生人数：<asp:Label ID="labNum1" runat="server" ForeColor="Red"></asp:Label>
        <br />
        购课人数：<asp:Label ID="labNum2" runat="server"></asp:Label>
        <br />
        选班人数：<asp:Label ID="labNum3" runat="server"></asp:Label>
    </div>
    </div>
    <div class="tablecontent">
    <div class="tabletitle">
        今日收入
    </div>
    <div class="divpanel">
        总&nbsp; 收&nbsp; 入：<asp:Label ID="labNum4" runat="server" ForeColor="Red"></asp:Label>
        <br />
        课程消费：<asp:Label ID="labNum5" runat="server"></asp:Label>
        <br />
        其它消费：<asp:Label ID="labNum6" runat="server"></asp:Label>
    </div>
    </div>
    <div class="divpanel" style="margin-top: 1.5em">
        <div class="tablecontent">
            <div class="tabletitle">
                今日对帐</div>
            <div class="splitline">
            </div>
            <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
                DataKeyNames="UserID">
                <RowStyle Height="40px" Font-Size="16px" />
                <Columns>
                    <asp:TemplateField HeaderText="工号">
                        <ItemTemplate>
                            <%#Eval("UserID") %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="姓名">
                        <ItemTemplate>
                            <%# Eval("TrueName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="PayMoney" HeaderText="金额" ReadOnly="True" DataFormatString="{0:c2}">
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="明细">
                        <ItemTemplate>
                            <div style="font-size: 16px">
                                <div class="lab_buttom">
                                    <asp:HyperLink runat="server" ID="hlkShow" Text="明细" NavigateUrl='<%# string.Format("BillDetails.aspx?UserID={0}&SchoolID={1}&GetURL={2}",Eval("UserID"),Eval("SchoolID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                </div>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <uc2:Footer ID="Footer1" runat="server" />
    </form>
</body>
</html>
