﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StudentShow.aspx.cs" Inherits="SWTraining.Mobile.Student.StudentShow"
    Title="基本信息" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="Header.ascx" TagName="Header" TagPrefix="uc1" %>
<%@ Register Src="../Footer.ascx" TagName="Footer" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    
    <link href="../Themes/css.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <uc1:Header ID="Header1" runat="server" />
    <div class="divpanel">
        <div class="tablecontent">
            <div class="tabletitle">
                学员信息</div>
            <div class="splitline">
            </div>
            <asp:FormView ID="fvStudent" runat="server" Width="100%" CellPadding="0" CellSpacing="0">
                <ItemTemplate>
                    <table class="table" cellspacing="0">
                        <tr>

                            <tr>
                                <td>
                                    学号：
                                </td>
                                <td>
                                    <%#Eval("StudentID")%>
                                </td>
                                <td>
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    姓名：
                                </td>
                                <td>
                                    <%#Eval("StudentName")%>
                                </td>
                                <td>
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    别名：
                                </td>
                                <td>
                                    <%#Eval("Byname")%>
                                </td>
                                <td align="center" rowspan="7" valign="middle" style="width: 10em; text-align: center">
                                    <asp:Image ID="Image1" ImageUrl="GetStudentPhoto.aspx" runat="server" />
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    性别：
                                </td>
                                <td>
                                    <%#Rs.Items.GetSex(Eval("Sex"))%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    类型：
                                </td>
                                <td>
                                    <%#CacheItems.GetStudentType(Eval("StudentType"))%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    生日：
                                </td>
                                <td>
                                    <%#Eval("Birthday","{0:d}")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    校区：
                                </td>
                                <td>
                                    <%#Eval("SchoolName")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    登记时间：
                                </td>
                                <td>
                                    <%#Eval("DateAndTime")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    电话：
                                </td>
                                <td>
                                    <%#Eval("Tel")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    手机：
                                </td>
                                <td colspan="2">
                                    <%# Eval("MobileTel")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    QQ：
                                </td>
                                <td colspan="2">
                                    <%# Eval("QQ")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    电子邮箱：
                                </td>
                                <td colspan="2">
                                    <%#Eval("Email")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    地址：
                                </td>
                                <td colspan="2">
                                    <%#Eval("HomeAddress")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    邮编：
                                </td>
                                <td colspan="2">
                                    <%#Eval("PostCode")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    学校：
                                </td>
                                <td colspan="2">
                                    <%#Eval("School")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    年级：
                                </td>
                                <td colspan="2">
                                    <%#Eval("Grade")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    公司：
                                </td>
                                <td colspan="2">
                                    <%#Eval("Company")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    职务：
                                </td>
                                <td colspan="2">
                                    <%#Eval("Headship")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    学历：
                                </td>
                                <td colspan="2">
                                    <%#Eval("Diploma")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    身份证：
                                </td>
                                <td colspan="2">
                                    <%#Eval("IDcard")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    ＩＤ卡号：
                                </td>
                                <td colspan="2">
                                    <%#Eval("SignInID")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    考勤短信：
                                </td>
                                <td colspan="2">
                                    <%#(int)Eval("SignInSMS") == 0 ? "否":"是"%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    父亲信息：
                                </td>
                                <td colspan="2">
                                    <%# Eval("FatherName")%>
                                    <%# Eval("FatherMobileTel")%>
                                    <%# Eval("FatherUnit")%>
                                    <%# Eval("FatherHeadship")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    母亲信息：
                                </td>
                                <td colspan="2">
                                    <%# Eval("MotherName")%>
                                    <%# Eval("MotherMobileTel")%>
                                    <%# Eval("MotherUnit")%>
                                    <%# Eval("MotherHeadship")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    最新加入：
                                </td>
                                <td colspan="2">
                                    <%#Eval("LastClassName")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    选班数：
                                </td>
                                <td colspan="2">
                                    <%#Eval("StuClassCount")%>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    咨询顾问：
                                </td>
                                <td colspan="2">
                                    <%#Eval("ConsultantName")%>
                                </td>
                            </tr>
                        </tr>
                    </table>
                </ItemTemplate>
            </asp:FormView>
        </div>
    </div>
    <div class="backpanel" id="divBack">
        <label class="lab_buttom">
            <input id="Button1" causesvalidation="false" type="button" runat="server" onclick="back()"
                value="返回" />
        </label>
    </div>
    <script type="text/javascript">
        if (window.name == "ifWin") {
            var the = document.getElementById("divBack");
            if (the != null)
                the.style.display = "none";
        }
    </script>
    <uc2:Footer ID="Footer1" runat="server" />
    </form>
</body>
</html>
