﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuLessons.aspx.cs" Inherits="SWTraining.Mobile.Student.StuLessons"
    Title="出勤信息" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="Header.ascx" TagName="Header" TagPrefix="uc1" %>
<%@ Register Src="../Footer.ascx" TagName="Footer" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <link href="../Themes/css.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <uc1:Header ID="Header1" runat="server" />
    <div class="tool_Search">
        班级：<asp:DropDownList ID="ddlStuClass" runat="server">
        </asp:DropDownList>
        类型：<asp:DropDownList ID="ddlShowType" runat="server">
            <asp:ListItem Value="0" Selected="True">显示全部</asp:ListItem>
            <asp:ListItem Value="1">考勤记录</asp:ListItem>
        </asp:DropDownList>
        时间：<asp:DropDownList ID="ddlDate" runat="server">
            <asp:ListItem Value="0">全部</asp:ListItem>
            <asp:ListItem Value="-2">前天</asp:ListItem>
            <asp:ListItem Value="-1">昨天</asp:ListItem>
            <asp:ListItem Value="1">今日</asp:ListItem>
            <asp:ListItem Value="2">明日</asp:ListItem>
            <asp:ListItem Value="3" Selected="True">最近7天</asp:ListItem>
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" Text="转到" />
        </label>
    </div>
    <div class="divpanel">
        <div class="tablecontent">
            <div class="tabletitle">
                上课与考勤信息</div>
            <div class="splitline">
            </div>
            <asp:GridView ID="GridView1" runat="server" CssClass="gridview" DataKeyNames="LessonDegreeID,AttendID"
                AutoGenerateColumns="false" OnRowDataBound="GridView1_RowDataBound" CellPadding="0" CellSpacing="0">
                <RowStyle Height="40px" />
                <Columns>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <asp:ImageButton runat="server" Enabled="false" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                                ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' CommandName="LeStateID"
                                CommandArgument='<%#Eval("LeStateID")%>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课日期">
                        <ItemTemplate>
                            <span runat="server" id="spanDate">
                                <%#Eval("StartDate","{0:d}")%></span><span style="color: Red">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课时段">
                        <ItemTemplate>
                            <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="TeacherName" ReadOnly="True" HeaderText="讲师" />
                    <asp:TemplateField HeaderText="出勤">
                        <ItemTemplate>
                            <%# Rs.Items.GetAtState(Eval("AtStateID"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="详情">
                        <ItemTemplate>
                            <label class="lab_buttom">
                                <asp:HyperLink ID="hlkShow" runat="server" Text="详情" NavigateUrl='<%# string.Format("LessonShow.aspx?LessonDegreeID={0}&AttendID={1}",Eval("LessonDegreeID"),Eval("AttendID")) %>' />
                            </label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
        </label>
    </div>
    <uc2:Footer ID="Footer1" runat="server" />
    </form>
</body>
</html>
