﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuClassShow.aspx.cs" Inherits="SWTraining.Mobile.Student.StuClassShow"
    Title="浏览选班信息" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="Header.ascx" TagName="Header" TagPrefix="uc2" %>
<%@ Register Src="../Footer.ascx" TagName="Footer" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    
    <link href="../Themes/css.css" rel="stylesheet" type="text/css" />
    <script>
        function autoHeight() {
            td_parent.style.height = document.getElementById("fvStuClassInfo_gvScores").clientHeight + 1 + "px";
        }
    </script>
</head>
<body onload="autoHeight()">
    <form id="form1" runat="server">
    <uc2:Header ID="Header1" runat="server" />
    <div class="divpanel">
            <div class="tablecontent">
            <div class="tabletitle">
                基本信息</div>
            <div class="splitline">
            </div>
        <asp:FormView ID="fvStuClassInfo" runat="server" Width="100%" DataSource='<%# BindDB() %>' CellPadding="0" CellSpacing="0">
            <ItemTemplate>
                <table class="table" cellspacing="0">
                    <tr>
                        <td style="width: 30%">
                            学号：
                        </td>
                        <td>
                            <%#Eval("StudentID")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            姓名：
                        </td>
                        <td>
                            <%#Eval("StudentName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            班号：
                        </td>
                        <td>
                            <%#Eval("ClassID")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            班级：
                        </td>
                        <td>
                            <%#Eval("ClassName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            选班日期：
                        </td>
                        <td>
                            <%#Eval("DateAndTime")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            选班状态：
                        </td>
                        <td>
                            <%# Rs.Items.GetScState(Eval("ScStateID"))%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            续报：
                        </td>
                        <td>
                            <%# Rs.Items.GetYN(Eval("ContinueReg"))%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            报名点：
                        </td>
                        <td>
                            <%#Eval("PostSchoolName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            备注：
                        </td>
                        <td>
                            <asp:Literal ID="litRemark" runat="server" Mode="Encode" Text='<%#Eval("Remark")%>'></asp:Literal>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            录入员：
                        </td>
                        <td>
                            <%#Eval("TrueName")%>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
        </div>
    </div>

        <div class="divpanel">
            <div class="tablecontent">
            <div class="tabletitle">
                上课信息</div>
            <div class="splitline">
            </div>
        <asp:FormView ID="FormView1" runat="server" Width="100%" DataSource='<%# BindDB() %>' CellPadding="0" CellSpacing="0">
            <ItemTemplate>
                <table class="table" cellspacing="0">
                    <tr>
                        <td style="width: 30%">
                            上课地点：
                        </td>
                        <td>
                            <%#Eval("SchoolName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            课时进度：
                        </td>
                        <td>
                            <%#Eval("CourseProgress") %>/<%#Eval("Lessons") %>
                            <%#Eval("ExpiryDate") is DateTime ? "("+Eval("ExpiryDate")+")" : ""%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            出勤次数：
                        </td>
                        <td>
                            <%#Eval("FactCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            迟到次数：
                        </td>
                        <td>
                            <%#Eval("LateCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            早退次数：
                        </td>
                        <td>
                            <%#Eval("AdvanceCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            旷课次数：
                        </td>
                        <td>
                            <%#Eval("TruancyCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            请假次数：
                        </td>
                        <td>
                            <%#Eval("LeaveCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            补课次数：
                        </td>
                        <td>
                            <%#Eval("FillCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            评价日期：
                        </td>
                        <td>
                            <%#Eval("OpinionDate")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            总成绩：
                        </td>
                        <td>
                            <%#Eval("Score")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            阶段成绩：
                        </td>
                        <td valign="top" style="height: auto; position: relative" id="td_parent">
                            <div style="width: 90%; height: auto; position: relative; font-size: 16px;">
                                <asp:GridView ID="gvScores" runat="server" Height="100%" Font-Size="16px" CssClass="gridview"
                                    DataSource='<%# db.Score.GetScore((int)Eval("StuClassID")) %>' AutoGenerateColumns="False"
                                    RowStyle-Font-Size="0.8em" HeaderStyle-Font-Size="0.8em">
                                    <Columns>
                                        <asp:TemplateField HeaderText="名称">
                                            <ItemTemplate>
                                                <asp:Label ID="labScoreName" runat="server" Text='<%# Eval("ScoreName") %>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="日期">
                                            <ItemTemplate>
                                                <asp:Label ID="labDateAndTime" runat="server" Text='<%# Eval("DateAndTime","{0:d}") %>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="分数">
                                            <ItemTemplate>
                                                <asp:Label ID="labScore" runat="server" Text='<%# Eval("Score","{0:f2}") %>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="说明">
                                            <ItemTemplate>
                                                <asp:Label ID="labRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            等级：
                        </td>
                        <td>
                            <%#Eval("Grade")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            评价内容：
                        </td>
                        <td>
                            <asp:Literal ID="litOpinion" runat="server" Mode="Encode" Text='<%#Eval("Opinion")%>'></asp:Literal>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
        </div>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
        </label>
    </div>
    <uc1:Footer ID="Footer1" runat="server" />
    </form>
</body>
</html>
