﻿<%@ Import Namespace="SWTraining" %>

<%@ Page Language="c#" CodeBehind="School.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.MicroSite.School"
    Title="微网站-校区设置" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
        <div class="both">
        </div>
        <div class="divpanel">
            <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
                DataKeyNames="SchoolID" OnRowCommand="GridView1_RowCommand"
                OnRowCreated="GridView1_RowCreated" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="图标">
                        <ItemTemplate>
                            <a href="<%# Eval("Logo")%>" target="_blank">
                                <div id="div_tbxLogo" style="width: 30px; height: 30px; background-size: cover; background-color: #ffffff; border: 1px solid #c0c0c0; background-image: url('<%# Eval("Logo")%>')"></div>
                            </a>
                        </ItemTemplate>
                        <ItemStyle HorizontalAlign="Center" Width="35px" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="SchoolName" ReadOnly="True" HeaderText="校区名称" />
                    <asp:TemplateField HeaderText="主题说明">
                        <ItemTemplate>
                            <asp:Label ID="labSubjectRemark" runat="server" Text='<%# Bind("SubjectRemark") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="电话">
                        <ItemTemplate>
                            <asp:Label ID="labTel" runat="server" Text='<%# Bind("Tel") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="地址">
                        <ItemTemplate>
                            <asp:Label ID="labAddress" runat="server" Text='<%# Bind("Address") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="经纬度">
                        <ItemTemplate>
                            <asp:Label ID="labLngAndLat" runat="server" Text='<%# Eval("lng") +","+Eval("lat") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <%# (int)Eval("LockSite") == 0 ? "隐藏" : "显示"%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="提交状态">
                        <ItemTemplate>
                            <%# imgSendState((int)Eval("SendState"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" Text="↑"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" Text="↓"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="设置">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkSet" runat="server" Text="设置"
                                NavigateUrl='<%# string.Format("SchoolPost.aspx?SchoolID={0}&GetURL={1}",Eval("SchoolID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
        <div class="divpanel">
            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
