﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DocList.aspx.cs"
    Inherits="SWTraining.MicroSite.DocList" Title="微网站-文章管理" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div id="sw_content">
            <div class="tool_Search">
                <label class="lab_buttom">
                    <input id="btnAdd" causesvalidation="false" type="button" onclick="window.location = 'DocPost.aspx'"
                        value="增加文章" />
                </label>
            </div>
            <div class="divpanel" style="text-align: right; width: 95%">
                分类导航：<asp:DropDownList ID="ddlOutline" runat="server" AutoPostBack="True" DataTextField="OutlineName"
                    DataValueField="OutlineID" OnSelectedIndexChanged="ddlOutline_SelectedIndexChanged">
                </asp:DropDownList>
            </div>
            <div id="sw_gridview">
                <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="DocID"
                    CssClass="gridview" PageSize="15" AllowSorting="True" OnRowDeleting="GridView1_RowDeleting">
                    <Columns>
                        <asp:TemplateField HeaderText="图标">
                            <ItemTemplate>
                                <a href="<%# Eval("Logo")%>" target="_blank">
                                    <div id="div_tbxLogo" style="width: 30px; height: 30px; background-size: cover; background-color: #ffffff; border: 1px solid #c0c0c0; background-image: url('<%# Eval("Logo")%>')"></div>
                                </a>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Center" Width="35px" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="主题">
                            <ItemTemplate>
                                <asp:HyperLink ID="hlkSubject" runat="server"
                                    Text='<%# Bind("DocName") %>'></asp:HyperLink>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>

                        <asp:BoundField DataField="OutlineName" HeaderText="类别" />
                        <asp:TemplateField HeaderText="日期">
                            <EditItemTemplate>
                                <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:TextBox>
                            </EditItemTemplate>
                            <ItemTemplate>
                                <asp:Label ID="Label1" runat="server" Text='<%# Bind("DateAndTime", "{0:d}") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="Author" HeaderText="作者" />
                        <asp:BoundField DataField="Source" HeaderText="来源" />
                        <asp:TemplateField HeaderText="提交状态">
                            <ItemTemplate>
                                <%# imgSendState((int)Eval("SendState"))%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="编辑">
                            <ItemTemplate>
                                <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl='<%#String.Format("DocPost.aspx?Mode=Edit&OutlineID={0}&DocID={1}&GetURL={2}",Eval("OutlineID"),Eval("DocID"), swq.Web. PathAndQuery()) %>'
                                    Text="编辑"></asp:HyperLink>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="删除">
                            <ItemTemplate>
                                <asp:LinkButton ID="LinkButton2" runat="server" CausesValidation="False" CommandName="Delete"
                                    OnClientClick="return confirm('你是否确定删除这条记录？');" Text="删除"></asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
            </div>
        </div>
        <div class="divpanel">
            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
