﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PostIncome.aspx.cs" Inherits="SWTraining.Finance.PostIncome"
    Title="财务管理-增加收支" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel" runat="server">
        <table class="table" cellspacing="0">
            <tr>
                <th colspan="2">
                    增加新的账目
                </th>
            </tr>
            <tr>
                <td>
                    入帐日期：
                </td>
                <td>
                    <asp:TextBox ID="tbxAccountDate" runat="server"></asp:TextBox>
                    <span style="color: Red">*</span>
                </td>
            </tr>
            <tr>
                <td>
                    校区：
                </td>
                <td>
                    <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                    </asp:DropDownList>
                    <span style="color: Red">*</span>
                </td>
            </tr>
            <tr>
                <td rowspan="2">
                    收支项目：
                </td>
                <td>
                    类型：<asp:DropDownList ID="ddlIncome" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlIncome_SelectedIndexChanged">
                        <asp:ListItem Value="-1">选择</asp:ListItem>
                        <asp:ListItem Value="0">支出</asp:ListItem>
                        <asp:ListItem Value="1">收入</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;账目分类：<asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                        DataValueField="IncomeClassID">
                    </asp:DropDownList>
                    金额：<%= swq.CurrentCurrencySymbol%><asp:TextBox ID="tbxPrice" runat="server" Width="55px"></asp:TextBox>
                    &nbsp;资金账户：<asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName"
                        DataValueField="AccountID">
                    </asp:DropDownList>
                    备注：<asp:TextBox ID="tbxRemark" runat="server" Width="134px"></asp:TextBox>
                    &nbsp;<label class="lab_buttom">
<asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click" />
</label>
                    <br />
                </td>
            </tr>
            <tr>
                <td>
                    <div style="width: 60%">
                        <asp:GridView ID="GridView1" runat="server" CssClass="smallgridview" AutoGenerateColumns="False"
                            DataKeyNames="Index" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing"
                            OnRowUpdating="GridView1_RowUpdating" OnRowDeleting="GridView1_RowDeleting">
                            <Columns>
                                <asp:TemplateField HeaderText="类型">
                                    <ItemTemplate>
                                        <%# (int)Eval("Income") == 0 ? "支出" : "收入" %>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="账目">
                                    <ItemTemplate>
                                        <asp:Label ID="labIncomeClassName" runat="server" Text='<%# Eval("IncomeClassName") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                                            DataValueField="IncomeClassID" DataSource='<%# swq.Cache.GetIncomeClass((int)Eval("Income")) %>'
                                            SelectedValue='<%# Eval("IncomeClassID") %>'>
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="金额">
                                    <ItemTemplate>
                                        <asp:Label ID="labPrice" runat="server" Text='<%# Eval("Price","{0:c2}") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:TextBox ID="tbxPrice" runat="server" Text='<%# Eval("Price") %>' Width="60"></asp:TextBox>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="帐户">
                                    <ItemTemplate>
                                        <asp:Label ID="labAccountName" runat="server" Text='<%# Eval("AccountName") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName" DataValueField="AccountID"
                                            DataSource='<%# swq.Cache.GetAccount() %>' SelectedValue='<%# Eval("AccountID") %>'>
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="备注">
                                    <ItemTemplate>
                                        <asp:Label ID="labRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:TextBox>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                                <asp:TemplateField HeaderText="删除">
                                    <ItemTemplate>
                                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete"></asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;
                </td>
                <td>
                    <label class="lab_buttom">
<asp:Button ID="btnSave" runat="server" Text="保存" onclick="btnSave_Click" />
</label>
                </td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    &nbsp;
                </td>
            </tr>
        </table>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
<input id="Button1" causesvalidation="false" type="button" runat="server" onclick="back()"
            value="返回" />
</label>
    </div>
    </form>
</body>
</html>
