﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="BasicLesson.aspx.cs" Inherits="SWTraining.EasyAnalyzer.BasicLesson" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>老师课时提成原数据</title>
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id.substring(0, 10) == "cblColumn_") {
                    e.checked = checkbox.checked;
                }
            }
        }
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel">
        <table class="table" cellspacing="0" cellpadding="0">
            <tr>
                <th colspan="2">
                    老师课时提成原数据
                </th>
            </tr>
            <tr>
                <td>
                    校区：
                </td>
                <td>
                    <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    班级类型：
                </td>
                <td>
                    <asp:DropDownList ID="ddlClassType" runat="server">
                        <asp:ListItem Value="-1" Text=""></asp:ListItem>
                        <asp:ListItem Value="1">一对一</asp:ListItem>
                        <asp:ListItem Value="0">一对多</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    上课类型：
                </td>
                <td>
                    <asp:DropDownList ID="ddlLessonType" runat="server">
                        <asp:ListItem Value="-1" Text=""></asp:ListItem>
                        <asp:ListItem Value="1">正常</asp:ListItem>
                        <asp:ListItem Value="0">补课</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    量化方式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlQuantifyType" runat="server">
                        <asp:ListItem Value="-1" Text=""></asp:ListItem>
                        <asp:ListItem Value="1">课时</asp:ListItem>
                        <asp:ListItem Value="2">到期时间</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    时间范围：
                </td>
                <td>
                    <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                    -<asp:TextBox ID="tbxEndDate" runat="server"></asp:TextBox>
                    &nbsp;<label class="lab_buttom"><asp:Button ID="btnWeek" runat="server" Text="本周"
                        OnClick="btnWeek_Click" /></label>
                    <label class="lab_buttom">
                        <asp:Button ID="btnMonth" runat="server" Text="本月" OnClick="btnMonth_Click" /></label>
                    <label class="lab_buttom">
                        <asp:Button ID="btnYear" runat="server" Text="本年" OnClick="btnYear_Click" /></label>
                    &nbsp;
                    <label class="lab_buttom">
                        <asp:Button ID="btnPrevMonth" runat="server" Text="上月" OnClick="btnPrevMonth_Click" /></label>
                    <label class="lab_buttom">
                        <asp:Button ID="btnNextMonth" runat="server" Text="下月" OnClick="btnNextMonth_Click" /></label>
                </td>
            </tr>
            <tr>
                <td>
                    字段选择：
                </td>
                <td>
                    <div style="color: #cccccc; float: left; background-color: #5D5D5D">
                        <table border="0">
                            <tr>
                                <td>
                                    <input id="Checkbox1" onclick="Checks(this)" type="checkbox" runat="server" checked="checked">全选
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div style="float: left">
                        <asp:CheckBoxList ID="cblColumn" runat="server" RepeatDirection="Horizontal" RepeatColumns="6">
                        </asp:CheckBoxList>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;
                </td>
                <td>
                    <label class="lab_buttom">
                        <asp:Button ID="btnAcc" runat="server" Text="计算" OnClick="btnAcc_Click" /></label>
                    <label class="lab_buttom">
                        <asp:Button ID="btnExportExcel" runat="server" OnClick="btnExportExcel_Click" Text="导出EXCEL"
                            ToolTip="ExportExcel" /></label>
                </td>
            </tr>
        </table>
    </div>
    <div class="divpanel">
        <div id="printBody" style="padding: 5px; padding-left: 20px; padding-right: 20px;
            border: 1px solid #000000; background-color: #FFFFFF; width: auto">
            <div style="margin-top: 20px; margin-bottom: 50px">
                    <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
                        AllowSorting="True" OnSorting="GridView1_Sorting">
                    </asp:GridView>
            </div>
        </div>
    </div>
    <br />
    <br />
    <div class="divpanel">
        <b>注意事项：</b><br />
        1、基本工资：指员工基本信息上的【基本工资】字段值。<br />
        2、基本课时费：指员工基本信息上的【课时费】字段值。<br />
        3、课次：指一次排课或一次上下课，一般用于解释考勤。<br />
        4、课时：将课程分成N个时间相等的单元，每个单元就是1课时，一般用于量化课程的进度。（公式：1课次=N课时，1课时=N分钟）<br />
        5、小时数：上课的总时长用小时制表示。<br />
        6、总人次（课次）：每次上课正常出勤人数的总和。<br />
        7、总人次（课时）：每次上课正常出勤人数乘以本次课课时数的总和。
        <br />
        8、班级总课次费： 每个班的上课总课次乘以班级【每课时提成】字段值的总和。<br />
        9、班级总课时费： 每个班的上课总课时乘以班级【每课时提成】字段值的总和。<br />
        10、班级总小时费： 每个班的上课总小时乘以班级【每课时提成】字段值的总和。<br />
        11、员工总课次费： 指员工基本信息上的【课时费】字段值乘以总课次。<br />
        12、员工总课时费： 指员工基本信息上的【课时费】字段值乘以总课时。<br />
        13、员工总小时费： 指员工基本信息上的【课时费】字段值乘以总小时。<br />
        14、消耗学费： 每课次消耗学员的学费总和。（系统需开启高精度课时计算，对按课时数进行量化的课程高度精准，按到期时间量化的准确率不高）<br />
    </div>
    </form>
</body>
</html>
